/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.http.client.utils.URIBuilder;

public class ResultHistoryFilter
implements FedmonWebApiClient.FedmonFilter<Long, Result> {
    protected final int testInstanceId;
    protected final Integer limit;
    protected final Date before;
    protected final Date after;

    public ResultHistoryFilter(int testInstanceId, Integer limit, Date before, Date after) {
        this.testInstanceId = testInstanceId;
        this.limit = limit;
        this.before = before;
        this.after = after;
    }

    public int getTestInstanceId() {
        return this.testInstanceId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Date getBefore() {
        return this.before;
    }

    public Date getAfter() {
        return this.after;
    }

    public boolean hasLimitFilter() {
        return this.limit != null;
    }

    public boolean hasBeforeFilter() {
        return this.before != null;
    }

    public boolean hasAfterFilter() {
        return this.after != null;
    }

    @Override
    @Nonnull
    public URIBuilder addToUriParameters(@Nonnull URIBuilder builder) {
        builder = builder.addParameter("testinstanceid", "" + this.testInstanceId);
        if (this.limit != null) {
            builder.addParameter("last", "" + this.limit);
        }
        if (this.before != null) {
            builder.addParameter("till", RFC3339Util.dateToRFC3339String((Date)this.before, (boolean)true, (boolean)true, (boolean)true));
        }
        if (this.after != null) {
            builder.addParameter("from", RFC3339Util.dateToRFC3339String((Date)this.before, (boolean)true, (boolean)true, (boolean)true));
        }
        return builder;
    }

    @Override
    @Nonnull
    public Class<Long> getIdClass() {
        return Long.class;
    }

    @Override
    @Nonnull
    public Class<Result> getObjectClass() {
        return Result.class;
    }
}

