/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.client;

import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.http.client.utils.URIBuilder;

public class TestInstanceFilter
implements FedmonWebApiClient.FedmonFilter<Integer, TestInstance> {
    protected final List<String> versionNames;
    protected final List<String> testInstanceNames;
    protected final List<String> testDefinitionNames;
    protected final List<Integer> testInstanceIds;
    protected final List<String> testbedNames;
    protected final List<String> testbedUrns;
    protected final List<String> testbedCategories;
    protected final List<String> testbedGeniNames;
    protected final Optional<Boolean> disabled;

    public TestInstanceFilter(int testInstanceId) {
        this.versionNames = Collections.emptyList();
        this.testInstanceNames = Collections.emptyList();
        this.testDefinitionNames = Collections.emptyList();
        this.testInstanceIds = Arrays.asList(testInstanceId);
        this.testbedNames = Collections.emptyList();
        this.testbedCategories = Collections.emptyList();
        this.testbedGeniNames = Collections.emptyList();
        this.testbedUrns = Collections.emptyList();
        this.disabled = Optional.empty();
    }

    public TestInstanceFilter(List<Integer> testInstanceIds) {
        this.versionNames = Collections.emptyList();
        this.testInstanceNames = Collections.emptyList();
        this.testDefinitionNames = Collections.emptyList();
        this.testInstanceIds = new ArrayList<Integer>(testInstanceIds);
        this.testbedNames = Collections.emptyList();
        this.testbedCategories = Collections.emptyList();
        this.testbedGeniNames = Collections.emptyList();
        this.testbedUrns = Collections.emptyList();
        this.disabled = Optional.empty();
    }

    public TestInstanceFilter(List<String> versionName, List<String> testInstanceName, List<String> testDefinitionName, List<Integer> testInstanceId, List<String> testbedCategory, List<String> testbedGeniName, List<String> testbedName, List<String> testbedUrns, Optional<Boolean> disabled) {
        this.versionNames = TestInstanceFilter.emptyListIfNull(versionName);
        this.testInstanceNames = TestInstanceFilter.emptyListIfNull(testInstanceName);
        this.testDefinitionNames = TestInstanceFilter.emptyListIfNull(testDefinitionName);
        this.testInstanceIds = TestInstanceFilter.emptyListIfNull(testInstanceId);
        this.testbedNames = TestInstanceFilter.emptyListIfNull(testbedName);
        this.testbedCategories = TestInstanceFilter.emptyListIfNull(testbedCategory);
        this.testbedGeniNames = TestInstanceFilter.emptyListIfNull(testbedGeniName);
        this.testbedUrns = TestInstanceFilter.emptyListIfNull(testbedUrns);
        this.disabled = disabled == null ? Optional.empty() : disabled;
    }

    public TestInstanceFilter(String versionNameArgString, String testInstanceNameArgString, String testDefinitionNameArgString, String testInstanceIdArgString, String testbedCategoryArgString, String testbedGeniNameArgString, String testbedNameArgString, String testbedUrnsArgString, Optional<Boolean> disabled) {
        this.versionNames = TestInstanceFilter.parseColonArgToList(versionNameArgString);
        this.testInstanceNames = TestInstanceFilter.parseColonArgToList(testInstanceNameArgString);
        this.testDefinitionNames = TestInstanceFilter.parseColonArgToList(testDefinitionNameArgString);
        this.testInstanceIds = TestInstanceFilter.parseColonArgToIntList(testInstanceIdArgString);
        this.testbedNames = TestInstanceFilter.parseColonArgToList(testbedNameArgString);
        this.testbedCategories = TestInstanceFilter.parseColonArgToList(testbedCategoryArgString);
        this.testbedGeniNames = TestInstanceFilter.parseColonArgToList(testbedGeniNameArgString);
        this.testbedUrns = TestInstanceFilter.parseColonArgToList(testbedUrnsArgString);
        this.disabled = disabled == null ? Optional.empty() : disabled;
    }

    public TestInstanceFilter(TestInstanceFilter testInstanceFilter) {
        this.versionNames = testInstanceFilter.getVersionNames();
        this.testInstanceNames = testInstanceFilter.getTestInstanceNames();
        this.testDefinitionNames = testInstanceFilter.getTestDefinitionNames();
        this.testInstanceIds = testInstanceFilter.getTestInstanceIds();
        this.testbedNames = testInstanceFilter.getTestbedNames();
        this.testbedCategories = testInstanceFilter.getTestbedCategories();
        this.testbedGeniNames = testInstanceFilter.getTestbedGeniNames();
        this.testbedUrns = testInstanceFilter.getTestbedCategories();
        this.disabled = testInstanceFilter.getDisabled();
    }

    public List<String> getVersionNames() {
        return this.versionNames;
    }

    public List<String> getTestInstanceNames() {
        return this.testInstanceNames;
    }

    public List<String> getTestDefinitionNames() {
        return this.testDefinitionNames;
    }

    public List<Integer> getTestInstanceIds() {
        return this.testInstanceIds;
    }

    public List<String> getTestbedNames() {
        return this.testbedNames;
    }

    public List<String> getTestbedCategories() {
        return this.testbedCategories;
    }

    public List<String> getTestbedGeniNames() {
        return this.testbedGeniNames;
    }

    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public String getVersionNamesAsArg() {
        return TestInstanceFilter.asArg(this.versionNames);
    }

    public String getTestInstanceNamesAsArg() {
        return TestInstanceFilter.asArg(this.testInstanceNames);
    }

    public String getTestDefinitionNamesAsArg() {
        return TestInstanceFilter.asArg(this.testDefinitionNames);
    }

    public String getTestInstanceIdsAsArg() {
        return TestInstanceFilter.asArg(this.testInstanceIds);
    }

    public String getTestbedNamesAsArg() {
        return TestInstanceFilter.asArg(this.testbedNames);
    }

    public String getTestbedUrnsAsArg() {
        return TestInstanceFilter.asArg(this.testbedUrns);
    }

    public String getTestbedCategoriesAsArg() {
        return TestInstanceFilter.asArg(this.testbedCategories);
    }

    public String getTestbedGeniNamesAsArg() {
        return TestInstanceFilter.asArg(this.testbedGeniNames);
    }

    public boolean hasVersionNameFilter() {
        return !this.versionNames.isEmpty();
    }

    public boolean hasTestInstanceNameFilter() {
        return !this.testInstanceNames.isEmpty();
    }

    public boolean hasTestDefinitionNameFilter() {
        return !this.testDefinitionNames.isEmpty();
    }

    public boolean hasTestInstanceIdFilter() {
        return !this.testInstanceIds.isEmpty();
    }

    public boolean hasTestbedNameFilter() {
        return !this.testbedNames.isEmpty();
    }

    public boolean hasTestbedUrnFilter() {
        return !this.testbedUrns.isEmpty();
    }

    public boolean hasTestbedCategoriesFilter() {
        return !this.testbedCategories.isEmpty();
    }

    public boolean hasTestbedGeniNamesFilter() {
        return !this.testbedGeniNames.isEmpty();
    }

    public boolean hasDisabledFilter() {
        return this.disabled != null && this.disabled.isPresent();
    }

    protected static <T> List<T> emptyListIfNull(List<T> o) {
        if (o == null) {
            return Collections.emptyList();
        }
        return o;
    }

    public static List<String> parseColonArgToList(String arg) {
        if (arg == null || arg.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = arg.split(",");
        if (parts.length == 1 && parts[0].trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(parts);
    }

    public static List<Integer> parseColonArgToIntList(String arg) {
        if (arg == null || arg.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] parts = arg.split(",");
        if (parts.length == 1 && parts[0].trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < parts.length; ++i) {
            try {
                res.add(Integer.parseInt(parts[i]));
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Argument \"" + arg + "\" contains a value \"" + parts[i] + "\" which is not a valid integer.", e);
            }
        }
        return res;
    }

    public static List<Integer> stringsToIntegers(List<String> ids) throws NumberFormatException {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (String s : ids) {
            res.add(Integer.parseInt(s));
        }
        return res;
    }

    private static String asArg(List<?> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        Object res = "";
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                res = (String)res + ",";
            }
            res = (String)res + l.get(i);
        }
        return res;
    }

    @Override
    @Nonnull
    public URIBuilder addToUriParameters(@Nonnull URIBuilder builder) {
        if (this.hasVersionNameFilter()) {
            builder = builder.addParameter("testversionname", this.getVersionNamesAsArg());
        }
        if (this.hasTestInstanceIdFilter()) {
            builder = builder.addParameter("testinstanceid", this.getTestInstanceIdsAsArg());
        }
        if (this.hasTestInstanceNameFilter()) {
            builder = builder.addParameter("testname", this.getTestInstanceNamesAsArg());
        }
        if (this.hasTestDefinitionNameFilter()) {
            builder = builder.addParameter("testdefinitionname", this.getTestDefinitionNamesAsArg());
        }
        if (this.hasTestbedNameFilter()) {
            builder = builder.addParameter("testbed", this.getTestbedNamesAsArg());
        }
        if (this.hasTestbedGeniNamesFilter()) {
            builder = builder.addParameter("geni_testbed", this.getTestbedGeniNamesAsArg());
        }
        if (this.hasTestbedCategoriesFilter()) {
            builder = builder.addParameter("testbedcategory", this.getTestbedCategoriesAsArg());
        }
        if (this.hasTestbedUrnFilter()) {
            builder = builder.addParameter("testbed_urn", this.getTestbedUrnsAsArg());
        }
        if (this.hasDisabledFilter()) {
            builder = builder.addParameter("disabled", "" + this.getDisabled().get());
        }
        return builder;
    }

    public boolean matchesVersion(String testVersionName) {
        if (this.versionNames.isEmpty()) {
            return true;
        }
        for (String versionName : this.versionNames) {
            if (!testVersionName.equalsIgnoreCase(versionName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Class<Integer> getIdClass() {
        return Integer.class;
    }

    @Override
    @Nonnull
    public Class<TestInstance> getObjectClass() {
        return TestInstance.class;
    }
}

