/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface AdvertisementCounts {
    @Nullable
    public Integer getCount(@Nonnull CountedObject var1, @Nonnull CountScope var2);

    @Nullable
    public Integer getHwCount(@Nonnull String var1, @Nonnull CountScope var2);

    @Nonnull
    public Collection<AdvertisementCountEntry> getCountEntries();

    public int getCountEntriesSize();

    @Nonnull
    public Collection<AdvertisementHwCountEntry> getHwCountEntries();

    public int getHwCountEntriesSize();

    public List<String> getHwCountKeys();

    @Nullable
    public Date getCountDate();

    public static class AdvertisementHwCountEntry {
        @Nonnull
        private final String hwType;
        @Nonnull
        private final CountScope scope;
        private final int count;

        public AdvertisementHwCountEntry(@Nonnull String hwType, @Nonnull CountScope scope, int count) {
            this.hwType = hwType;
            this.scope = scope;
            this.count = count;
        }

        @Nonnull
        public String getHwType() {
            return this.hwType;
        }

        @Nonnull
        public CountScope getScope() {
            return this.scope;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class AdvertisementCountEntry {
        @Nonnull
        private final CountedObject object;
        @Nonnull
        private final CountScope scope;
        private final int count;

        public AdvertisementCountEntry(@Nonnull CountedObject object, @Nonnull CountScope scope, int count) {
            this.object = object;
            this.scope = scope;
            this.count = count;
        }

        @Nonnull
        public CountedObject getObject() {
            return this.object;
        }

        @Nonnull
        public CountScope getScope() {
            return this.scope;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static enum CountScope {
        AVAILABLE("Available"),
        ALL("Total");

        private final String keySuffixName;

        private CountScope(String keySuffixName) {
            this.keySuffixName = keySuffixName;
        }

        @Nonnull
        public String getKeySuffixName() {
            return this.keySuffixName;
        }
    }

    public static enum CountedObject {
        ANY("any"),
        RAW_PC("rawPCs"),
        VM("VMs"),
        IPV4("Ipv4s"),
        OPENFLOW("Openflows");

        private final String keyPrefixName;

        private CountedObject(String keyPrefixName) {
            this.keyPrefixName = keyPrefixName;
        }

        @Nonnull
        public String getKeyPrefixName() {
            return this.keyPrefixName;
        }
    }
}

