/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FrequencyBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="frequency", builderClass=FrequencyBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.PRIMARY)
public class Frequency
extends PrimaryIdObject<Integer> {
    private final String description;
    private final String cron;

    @JsonCreator
    Frequency(@JsonProperty(value="id") Integer id, @JsonProperty(value="description") String description, @JsonProperty(value="cron") String cron, @JsonProperty(value="@id") URI uri) {
        this(id, description, cron, uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
    }

    Frequency(Integer id, String description, String cron, URI uri, boolean serializeInfo_SerializeAsEmbeddedObject) {
        super((Object)id, uri, serializeInfo_SerializeAsEmbeddedObject);
        this.description = description;
        this.cron = cron;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public String getCron() {
        return this.cron;
    }

    @JsonIgnore
    public boolean isNever() {
        if (this.description != null && this.description.toLowerCase().startsWith("never")) {
            return true;
        }
        if (this.description != null && this.description.toLowerCase().replaceAll(" ", "").startsWith("notautomatic")) {
            return true;
        }
        if (this.cron != null && this.cron.trim().equals("3 3 31 2 0")) {
            return true;
        }
        return this.cron == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Frequency frequency = (Frequency)((Object)o);
        if (this.cron != null ? !this.cron.equals(frequency.cron) : frequency.cron != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(frequency.description) : frequency.description != null) {
            return false;
        }
        if (this.id != null ? !((Integer)this.id).equals(frequency.id) : frequency.id != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(frequency.uri) : frequency.uri != null);
    }

    public int hashCode() {
        int result = this.id != null ? ((Integer)this.id).hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.cron != null ? this.cron.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "Exception converting Frequency to JSON: " + e.getMessage();
        }
    }
}

