/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Log.class)
public class LogBuilder
extends PrimaryIdObjectBuilder<Long, Log, LogBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(LogBuilder.class);
    private String name;
    private Task task;
    private Result result;
    private Timestamp startTime;
    private Timestamp stopTime;
    private Boolean live;
    private Boolean complete;
    private Long size;
    private Log.LogMediaType mediaType;
    private URI content;

    public LogBuilder() {
        this.complete = false;
    }

    public LogBuilder(Log orig) {
        super((PrimaryIdObject)orig);
        this.task = orig.getTask();
        this.result = orig.getResult();
        this.startTime = orig.getStartTime();
        this.name = orig.getName();
        this.stopTime = orig.getStopTime();
        this.live = orig.getLive();
        this.complete = orig.getComplete();
        this.size = orig.getSize();
        this.mediaType = orig.getMediaType();
        this.content = orig.getContent();
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Task.class, name="task")
    public LogBuilder setTask(Task task) {
        this.task = task;
        return this;
    }

    public LogBuilder setTaskId(Long taskId) {
        this.task = taskId == null ? null : ((TaskBuilder)new TaskBuilder().setId(taskId)).create();
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=Result.class, name="result")
    public LogBuilder setResult(Result result) {
        this.result = result;
        return this;
    }

    public LogBuilder setResultId(Long resultId) {
        this.result = resultId == null ? null : ((ResultBuilder)new ResultBuilder().setId(resultId)).create();
        return this;
    }

    public LogBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public LogBuilder setStartTime(Timestamp startTime) {
        this.startTime = startTime;
        return this;
    }

    public LogBuilder setStopTime(Timestamp stopTime) {
        this.stopTime = stopTime;
        return this;
    }

    public LogBuilder setLive(Boolean live) {
        this.live = live;
        return this;
    }

    public LogBuilder setComplete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    public LogBuilder setSize(Long size) {
        this.size = size;
        return this;
    }

    public LogBuilder setMediaType(Log.LogMediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public LogBuilder setMediaType(String mediaType) {
        this.mediaType = Log.LogMediaType.valueOf(mediaType);
        assert (mediaType == null == (this.mediaType == null));
        return this;
    }

    public LogBuilder setContent(URI content) {
        this.content = content;
        return this;
    }

    public Log create() {
        return new Log((Long)this.id, this.name, this.task, this.result, this.startTime, this.stopTime, this.live, this.complete, this.size, this.mediaType, this.content, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    public Log createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        return new Log(minimization.includeId() ? (Long)this.id : null, minimization.includeOtherProperties() ? this.name : null, minimization.includeOtherProperties() ? this.task : null, minimization.includeOtherProperties() ? this.result : null, minimization.includeOtherProperties() ? this.startTime : null, minimization.includeOtherProperties() ? this.stopTime : null, minimization.includeOtherProperties() ? this.live : null, minimization.includeOtherProperties() ? this.complete : null, minimization.includeOtherProperties() ? this.size : null, minimization.includeOtherProperties() ? this.mediaType : null, minimization.includeOtherProperties() ? this.content : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Task.class, name="task")
    public Task getTask() {
        return this.task;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=Result.class, name="result")
    public Result getResult() {
        return this.result;
    }

    public Long getResultId() {
        return this.result != null ? (Long)this.result.getId() : null;
    }

    public Long getTaskId() {
        return this.task != null ? (Long)this.task.getId() : null;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public String getName() {
        return this.name;
    }

    public Timestamp getStopTime() {
        return this.stopTime;
    }

    public Boolean getLive() {
        return this.live;
    }

    public Boolean getComplete() {
        return this.complete;
    }

    public Long getSize() {
        return this.size;
    }

    public Log.LogMediaType getMediaType() {
        return this.mediaType;
    }

    public URI getContent() {
        return this.content;
    }
}

