/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Location;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedBuilder;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=Organisation.class)
public class OrganisationBuilder
extends PrimaryIdObjectBuilder<String, Organisation, OrganisationBuilder> {
    private String name;
    private String logoUrl;
    private String siteUrl;
    private Location location;
    private List<Testbed> testbeds;
    private List<TestbedBuilder> testbedBuilders;
    List<String> technicalContactEmails;

    public OrganisationBuilder() {
    }

    public OrganisationBuilder(@Nonnull Organisation orig) {
        super((PrimaryIdObject)orig);
        this.name = orig.getName();
        this.logoUrl = orig.getLogoUrl();
        this.siteUrl = orig.getSiteUrl();
        this.location = orig.getLocation();
        this.testbeds = orig.getTestbeds();
        this.technicalContactEmails = orig.getTechnicalContactEmails();
    }

    public OrganisationBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public OrganisationBuilder setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    public OrganisationBuilder setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
        return this;
    }

    public OrganisationBuilder setLocation(Location location) {
        this.location = location;
        return this;
    }

    public OrganisationBuilder setTechnicalContactEmails(List<String> technicalContactEmails) {
        this.technicalContactEmails = technicalContactEmails;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Testbed.class)
    public OrganisationBuilder setTestbeds(List<Testbed> testbeds) {
        this.testbeds = testbeds;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Testbed.class, builderReference=true)
    public OrganisationBuilder setTestbedBuilders(List<TestbedBuilder> testbedBuilders) {
        this.testbedBuilders = new ArrayList<TestbedBuilder>(testbedBuilders);
        return this;
    }

    public OrganisationBuilder addTestbedBuilder(TestbedBuilder curTestbedBuilder) {
        if (this.testbedBuilders == null) {
            this.testbedBuilders = new ArrayList<TestbedBuilder>();
        }
        this.testbedBuilders.add(curTestbedBuilder);
        return this;
    }

    public Organisation create() {
        if (this.testbedBuilders != null && this.testbeds != null) {
            throw new IllegalStateException("Either none, only testbeds or only testbedBuilders must be set, not both.");
        }
        if (this.testbedBuilders != null) {
            return new Organisation(this.testbedBuilders, (String)this.id, this.name, this.logoUrl, this.siteUrl, this.location, this.technicalContactEmails, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
        }
        return new Organisation((String)this.id, this.name, this.logoUrl, this.siteUrl, this.location, this.testbeds, this.technicalContactEmails, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    public Organisation createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        if (minimization == JsonLdObjectsMetaData.Minimization.FULL) {
            return this.create();
        }
        if (this.testbedBuilders != null) {
            throw new IllegalStateException("It makes no sense to use createMinimized when testbedBuilders is set");
        }
        return new Organisation(minimization.includeId() ? (String)this.id : null, minimization.includeOtherProperties() ? this.name : null, minimization.includeOtherProperties() ? this.logoUrl : null, minimization.includeOtherProperties() ? this.siteUrl : null, minimization.includeOtherProperties() ? this.location : null, this.testbeds == null || !minimization.includeChildren() ? null : TestbedBuilder.minimize(minimization.getChildrenMinimization(), this.testbeds), minimization.includeOtherProperties() ? this.technicalContactEmails : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<Organisation> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<Organisation> in) {
        if (in == null) {
            return null;
        }
        ArrayList<Organisation> res = new ArrayList<Organisation>();
        for (Organisation s : in) {
            res.add(new OrganisationBuilder(s).createMinimized(minimization));
        }
        return res;
    }

    public static Organisation minimize(JsonLdObjectsMetaData.Minimization minimization, Organisation in) {
        if (in == null) {
            return null;
        }
        return new OrganisationBuilder(in).createMinimized(minimization);
    }

    public String getName() {
        return this.name;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public Location getLocation() {
        return this.location;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Testbed.class)
    public List<Testbed> getTestbeds() {
        return this.testbeds;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Testbed.class, builderReference=true)
    public List<TestbedBuilder> getTestbedBuilders() {
        return this.testbedBuilders;
    }

    public List<String> getTechnicalContactEmails() {
        return this.technicalContactEmails;
    }
}

