/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=ResourceClass.class)
public class ResourceClassBuilder
extends PrimaryIdObjectBuilder<String, ResourceClass, ResourceClassBuilder> {
    private String imageUrl;
    private String imageId;
    private String hrn;
    private ResourceClass parent;
    private ResourceClassBuilder parentBuilder;
    private Boolean visibleInToolbox;
    private Boolean draggableFromToolbox;
    private ResourceClass instantiateAs;
    private ResourceClassBuilder instantiateAsBuilder;
    private List<Resource> defaultResource;
    private List<ResourceBuilder> defaultResourceBuilders;
    private List<Resource> resources;
    private List<ResourceBuilder> resourceBuilders;
    private List<String> configsetId;
    private Integer weight;

    public ResourceClassBuilder() {
    }

    public ResourceClassBuilder(ResourceClass orig) {
        super((PrimaryIdObject)orig);
        this.id = orig.getId();
        this.imageUrl = orig.getImageUrl();
        this.imageId = orig.getImageId();
        this.hrn = orig.getHrn();
        this.parent = orig.getParent_ReferenceObjectOnly();
        this.visibleInToolbox = orig.getVisibleInToolbox();
        this.draggableFromToolbox = orig.getDraggableFromToolbox();
        this.instantiateAs = orig.getInstantiateAs_ReferenceObjectOnly();
        this.defaultResource = orig.getDefaultResource() != null ? new ArrayList<Resource>(orig.getDefaultResource()) : null;
        this.resources = orig.getResources() != null ? new ArrayList<Resource>(orig.getResources()) : null;
        this.configsetId = orig.getConfigsetIds() == null ? null : new ArrayList<String>(orig.getConfigsetIds());
        this.weight = orig.getWeight();
    }

    public ResourceClassBuilder setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public ResourceClassBuilder setImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public ResourceClassBuilder setHrn(String hrn) {
        this.hrn = hrn;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=ResourceClass.class, name="parent")
    public ResourceClassBuilder setParent(ResourceClass parent) {
        this.parent = parent;
        return this;
    }

    public ResourceClassBuilder setParentId(String parentId) {
        this.parent = parentId == null ? null : ((ResourceClassBuilder)new ResourceClassBuilder().setId(parentId)).create();
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=ResourceClass.class, name="parent", builderReference=true)
    public ResourceClassBuilder setParentBuilder(ResourceClassBuilder parentBuilder) {
        this.parentBuilder = parentBuilder;
        return this;
    }

    public ResourceClassBuilder setVisibleInToolbox(Boolean visibleInToolbox) {
        this.visibleInToolbox = visibleInToolbox;
        return this;
    }

    public ResourceClassBuilder setDraggableFromToolbox(Boolean draggableFromToolbox) {
        this.draggableFromToolbox = draggableFromToolbox;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=ResourceClass.class, name="instantiateAs")
    public ResourceClassBuilder setInstantiateAs(ResourceClass instantiateAs) {
        this.instantiateAs = instantiateAs;
        return this;
    }

    public ResourceClassBuilder setInstantiateAsId(String instantiateAsId) {
        this.instantiateAs = instantiateAsId == null ? null : ((ResourceClassBuilder)new ResourceClassBuilder().setId(instantiateAsId)).create();
        return this;
    }

    public ResourceClassBuilder setConfigsetId(List<String> configsetId) {
        this.configsetId = configsetId;
        return this;
    }

    public ResourceClassBuilder addConfigsetId(String singleConfigsetId) {
        if (this.configsetId == null) {
            this.configsetId = new ArrayList<String>();
        }
        this.configsetId.add(singleConfigsetId);
        return this;
    }

    public ResourceClassBuilder setWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceSetter(objectClass=ResourceClass.class, name="instantiateAs", builderReference=true)
    public ResourceClassBuilder setInstantiateAsBuilder(ResourceClassBuilder instantiateAsBuilder) {
        this.instantiateAsBuilder = instantiateAsBuilder;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Resource.class, name="defaultResource")
    public ResourceClassBuilder setDefaultResource(List<Resource> defaultResource) {
        this.defaultResource = defaultResource;
        return this;
    }

    public ResourceClassBuilder setDefaultResourceIdsCsv(String defaultResourceIdsCsv) {
        this.defaultResource = defaultResourceIdsCsv == null ? null : Arrays.asList(defaultResourceIdsCsv.trim().split(",")).stream().map(String::trim).filter(s -> !s.isEmpty()).map(Integer::parseInt).map(id -> ((ResourceBuilder)new ResourceBuilder().setId(id)).create()).collect(Collectors.toList());
        return this;
    }

    public ResourceClassBuilder addDefaultResource(Resource defaultResource) {
        if (this.defaultResource == null) {
            this.defaultResource = new ArrayList<Resource>();
        }
        this.defaultResource.add(defaultResource);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Resource.class, name="defaultResource", builderReference=true)
    public ResourceClassBuilder setDefaultResourceBuilders(List<ResourceBuilder> defaultResourceBuilders) {
        this.defaultResourceBuilders = defaultResourceBuilders == null ? null : new ArrayList<ResourceBuilder>(defaultResourceBuilders);
        return this;
    }

    public ResourceClassBuilder addDefaultResourceBuilder(ResourceBuilder defaultResourceBuilder) {
        if (this.defaultResourceBuilders == null) {
            this.defaultResourceBuilders = new ArrayList<ResourceBuilder>();
        }
        this.defaultResourceBuilders.add(defaultResourceBuilder);
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Resource.class, name="resources")
    public ResourceClassBuilder setResources(List<Resource> resources) {
        this.resources = resources;
        return this;
    }

    @JsonLdObjectsMetaData.ReferenceListSetter(objectClass=Resource.class, name="resources", builderReference=true)
    public ResourceClassBuilder setResourceBuilders(List<ResourceBuilder> resourceBuilders) {
        this.resourceBuilders = resourceBuilders == null ? null : new ArrayList<ResourceBuilder>(resourceBuilders);
        return this;
    }

    public ResourceClassBuilder addResourceBuilder(ResourceBuilder resourceBuilder) {
        if (this.resourceBuilders == null) {
            this.resourceBuilders = new ArrayList<ResourceBuilder>();
        }
        this.resourceBuilders.add(resourceBuilder);
        return this;
    }

    public ResourceClass create() {
        if (this.resourceBuilders != null && this.resources != null) {
            throw new IllegalStateException("Either none, only resources or only resourceBuilders must be set, not both.");
        }
        if (this.defaultResourceBuilders != null && this.defaultResource != null) {
            throw new IllegalStateException("Either none, only defaultResource or only defaultResourceBuilders must be set, not both.");
        }
        if (this.resourceBuilders != null && this.defaultResource != null || this.resources != null && this.defaultResourceBuilders != null) {
            throw new IllegalStateException("builder usage of resources and defaultResource must match.");
        }
        if (this.parent != null && this.parentBuilder != null) {
            throw new IllegalStateException("Either none, only parent or only parentBuilder must be set, not both.");
        }
        if (this.instantiateAs != null && this.instantiateAsBuilder != null) {
            throw new IllegalStateException("Either none, only instantiateAs or only instantiateAsBuilder must be set, not both.");
        }
        ResourceClass usedParent = null;
        ResourceClass usedInstantiateAs = null;
        if (this.parent != null) {
            usedParent = this.parent;
        }
        if (this.parentBuilder != null) {
            usedParent = this.parentBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        }
        if (this.instantiateAs != null) {
            usedInstantiateAs = this.instantiateAs;
        }
        if (this.instantiateAsBuilder != null) {
            usedInstantiateAs = this.instantiateAsBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        }
        if (this.defaultResourceBuilders != null || this.resourceBuilders != null) {
            return new ResourceClass((String)this.id, this.imageUrl, this.imageId, this.hrn, usedParent, this.visibleInToolbox, this.draggableFromToolbox, usedInstantiateAs, this.configsetId, this.weight, this.uri, this.defaultResourceBuilders, this.resourceBuilders, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
        }
        return new ResourceClass((String)this.id, this.imageUrl, this.imageId, this.hrn, usedParent, this.visibleInToolbox, this.draggableFromToolbox, usedInstantiateAs, this.defaultResource, this.resources, this.configsetId, this.weight, this.uri, this.mustSerializeAsEmbeddedObjectForNonMinimizedCreate());
    }

    public ResourceClass createMinimized(JsonLdObjectsMetaData.Minimization minimization) {
        if (this.resourceBuilders != null && this.resources != null) {
            throw new IllegalStateException("Either none, only resources or only resourceBuilders must be set, not both.");
        }
        if (this.defaultResourceBuilders != null && this.defaultResource != null) {
            throw new IllegalStateException("Either none, only defaultResource or only defaultResourceBuilders must be set, not both.");
        }
        if (this.parent != null && this.parentBuilder != null) {
            throw new IllegalStateException("Either none, only parent or only parentBuilder must be set, not both.");
        }
        if (this.instantiateAs != null && this.instantiateAsBuilder != null) {
            throw new IllegalStateException("Either none, only instantiateAs or only instantiateAsBuilder must be set, not both.");
        }
        List<Resource> usedResources = null;
        List<Resource> usedDefaultResourceList = null;
        if (this.resources != null) {
            usedResources = this.resources;
        }
        if (this.resourceBuilders != null) {
            usedResources = this.resourceBuilders.stream().map(ResourceBuilder::create).collect(Collectors.toList());
        }
        if (this.defaultResource != null) {
            usedDefaultResourceList = this.defaultResource;
        }
        if (this.defaultResourceBuilders != null) {
            usedDefaultResourceList = this.defaultResourceBuilders.stream().map(ResourceBuilder::create).collect(Collectors.toList());
        }
        ResourceClass usedParent = null;
        ResourceClass usedInstantiateAs = null;
        if (this.parent != null) {
            usedParent = this.parent;
        }
        if (minimization.includeParent() && this.parentBuilder != null) {
            usedParent = this.parentBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        }
        if (this.instantiateAs != null) {
            usedInstantiateAs = this.instantiateAs;
        }
        if (minimization.includeChildren() && this.instantiateAsBuilder != null) {
            usedInstantiateAs = this.instantiateAsBuilder.createMinimized(JsonLdObjectsMetaData.Minimization.ID_ONLY);
        }
        if (usedDefaultResourceList != null && !usedDefaultResourceList.isEmpty()) {
            usedDefaultResourceList = ResourceBuilder.minimize(JsonLdObjectsMetaData.Minimization.ID_ONLY, usedDefaultResourceList);
        }
        return new ResourceClass(minimization.includeId() ? (String)this.id : null, minimization.includeOtherProperties() ? this.imageUrl : null, minimization.includeOtherProperties() ? this.imageId : null, minimization.includeOtherProperties() ? this.hrn : null, usedParent != null && minimization.includeParent() ? ResourceClassBuilder.minimize(minimization.getParentMinimization(), usedParent) : null, minimization.includeOtherProperties() ? this.visibleInToolbox : null, minimization.includeOtherProperties() ? this.draggableFromToolbox : null, usedInstantiateAs != null && minimization.includeOtherProperties() && minimization.includeChildren() ? ResourceClassBuilder.minimize(minimization.getChildrenMinimization(), usedInstantiateAs) : null, usedDefaultResourceList != null && minimization.includeOtherProperties() && minimization.includeChildren() ? ResourceBuilder.minimize(minimization.getChildrenMinimization(), usedDefaultResourceList) : null, usedResources != null && minimization.includeChildren() ? ResourceBuilder.minimize(minimization.getChildrenMinimization(), usedResources) : null, this.configsetId, minimization.includeOtherProperties() ? this.weight : null, minimization.includeId() ? this.uri : null, minimization.serializeAsEmbeddedObject());
    }

    public static List<ResourceClass> minimize(JsonLdObjectsMetaData.Minimization minimization, Collection<ResourceClass> in) {
        if (in == null) {
            return null;
        }
        ArrayList<ResourceClass> res = new ArrayList<ResourceClass>();
        for (ResourceClass rc : in) {
            res.add(new ResourceClassBuilder(rc).createMinimized(minimization));
        }
        return res;
    }

    public static ResourceClass minimize(JsonLdObjectsMetaData.Minimization minimization, ResourceClass in) {
        if (in == null) {
            return null;
        }
        return new ResourceClassBuilder(in).createMinimized(minimization);
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getHrn() {
        return this.hrn;
    }

    public Boolean getVisibleInToolbox() {
        return this.visibleInToolbox;
    }

    public Boolean getDraggableFromToolbox() {
        return this.draggableFromToolbox;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=ResourceClass.class, name="parent")
    public ResourceClass getParent() {
        return this.parent;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=ResourceClass.class, name="instantiateAs")
    public ResourceClass getInstantiateAs() {
        return this.instantiateAs;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Resource.class, name="defaultResource")
    public List<Resource> getDefaultResource() {
        return this.defaultResource;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Resource.class, name="resources")
    public List<Resource> getResources() {
        return this.resources;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=ResourceClass.class, name="parent", builderReference=true)
    public ResourceClassBuilder getParentBuilder() {
        return this.parentBuilder;
    }

    @JsonLdObjectsMetaData.ReferenceGetter(objectClass=ResourceClass.class, name="instantiateAs", builderReference=true)
    public ResourceClassBuilder getInstantiateAsBuilder() {
        return this.instantiateAsBuilder;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Resource.class, name="defaultResource", builderReference=true)
    public List<ResourceBuilder> getDefaultResourceBuilders() {
        return this.defaultResourceBuilders;
    }

    @JsonLdObjectsMetaData.ReferenceListGetter(objectClass=Resource.class, name="resources", builderReference=true)
    public List<ResourceBuilder> getResourceBuilders() {
        return this.resourceBuilders;
    }

    public List<String> getConfigsetId() {
        return this.configsetId;
    }

    public Integer getWeight() {
        return this.weight;
    }
}

