/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.FedmonFullObjectLinkDeserializers;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.MaintenanceInfo;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Deserializer;
import be.iminds.ilabt.jfed.json.util.JsonTimeStampRFC3339Serializer;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkSerializer;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.impl.ForeignIdObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.dropwizard.jackson.Jackson;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"@context", "availableComponentIds", "unavailableComponentIds"})
@JsonLdObjectsMetaData.JsonLdObjectInfo(pathName="serverglimpse", builderClass=ServerGlimpseBuilder.class, uriType=JsonLdObjectsMetaData.UriType.ID_BASED, idType=JsonLdObjectsMetaData.IdType.FOREIGN)
public class ServerGlimpse
extends ForeignIdObject {
    private static final Logger LOG = LoggerFactory.getLogger(ServerGlimpse.class);
    private final AdvertisementInfo advertisementInfo;
    private final HealthInfo healthInfo;
    private final Server server;
    private final Integer reputation;
    private final List<MaintenanceInfo> maintenance;

    @JsonCreator
    ServerGlimpse(@JsonProperty(value="advertisementInfo") AdvertisementInfo advertisementInfo, @JsonProperty(value="healthInfo") HealthInfo healthInfo, @JsonProperty(value="server") Server server, @JsonProperty(value="reputation") Integer reputation, @JsonProperty(value="maintenance") List<MaintenanceInfo> maintenance, @JsonProperty(value="@id") URI uri) {
        super(uri, JsonLdObjectsMetaData.mustSerializeAsEmbeddedObjectForJacksonConstructor());
        this.advertisementInfo = advertisementInfo;
        this.healthInfo = healthInfo;
        this.server = server;
        this.reputation = reputation;
        this.maintenance = maintenance;
    }

    @JsonProperty
    public AdvertisementInfo getAdvertisementInfo() {
        return this.advertisementInfo;
    }

    @JsonProperty
    public HealthInfo getHealthInfo() {
        return this.healthInfo;
    }

    @JsonProperty
    @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ServerDeserializer.class)
    @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedParentLinkSerializer.class)
    public Server getServer() {
        return this.server;
    }

    @JsonIgnore
    public Integer getServerId() {
        return this.server == null ? null : (Integer)this.server.getId();
    }

    @JsonProperty
    public Integer getReputation() {
        return this.reputation;
    }

    @JsonProperty
    public List<MaintenanceInfo> getMaintenance() {
        return this.maintenance;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception converting " + ((Object)((Object)this)).getClass().getSimpleName() + " to JSON", (Throwable)e);
            return "Exception converting " + ((Object)((Object)this)).getClass().getSimpleName() + " to JSON: " + e.getMessage();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class AdvertisementInfo
    implements AdvertisementCounts {
        private final Timestamp timestamp;
        private final Result result;
        private final URI rspec;
        private final List<DiskImage> diskImages;
        private final List<SliverTypeInfo> sliverTypeInfo;
        private final List<String> componentManagerIds;
        private final TreeMap<String, Integer> counts;
        private final TreeMap<String, Integer> hwCounts;
        private final List<ComponentDetails> componentDetails;
        private final HardwareTypeInfo hardwareTypeInfo;

        @JsonCreator
        AdvertisementInfo(@JsonProperty(value="timestamp") Timestamp timestamp, @JsonProperty(value="result") Result result, @JsonProperty(value="rspec") URI rspec, @JsonProperty(value="sliverTypeInfo") Collection<SliverTypeInfo> sliverTypeInfo, @JsonProperty(value="diskImages") Collection<DiskImage> diskImages, @JsonProperty(value="componentManagerIds") Collection<String> componentManagerIds, @JsonProperty(value="componentDetails") Collection<ComponentDetails> componentDetails, @JsonProperty(value="counts") Map<String, Integer> counts, @JsonProperty(value="hwCounts") Map<String, Integer> hwCounts, @JsonProperty(value="hardwareTypeInfo") HardwareTypeInfo hardwareTypeInfo) {
            this.timestamp = timestamp;
            this.result = result;
            this.rspec = rspec;
            this.hardwareTypeInfo = hardwareTypeInfo;
            List<SliverTypeInfo> list = this.sliverTypeInfo = sliverTypeInfo == null ? null : Collections.unmodifiableList(new ArrayList<SliverTypeInfo>(sliverTypeInfo));
            if (diskImages == null) {
                this.diskImages = null;
            } else {
                ArrayList<DiskImage> newList = new ArrayList<DiskImage>(diskImages);
                Comparator<DiskImage> diskImageComparator = Comparator.comparing(DiskImage::getName).thenComparing(DiskImage::getUrl).thenComparing(DiskImage::getVersion).thenComparing(DiskImage::getOs).thenComparing(DiskImage::getDescription);
                Collections.sort(newList, diskImageComparator);
                this.diskImages = Collections.unmodifiableList(newList);
            }
            this.componentManagerIds = componentManagerIds == null ? null : Collections.unmodifiableList(new ArrayList<String>(componentManagerIds));
            this.componentDetails = componentDetails == null ? null : Collections.unmodifiableList(new ArrayList<ComponentDetails>(componentDetails));
            TreeMap treeMap = this.counts = counts == null ? null : new TreeMap(String.CASE_INSENSITIVE_ORDER);
            if (counts != null) {
                this.counts.putAll(counts);
            }
            TreeMap treeMap2 = this.hwCounts = hwCounts == null ? null : new TreeMap(String.CASE_INSENSITIVE_ORDER);
            if (hwCounts != null) {
                this.hwCounts.putAll(hwCounts);
            }
        }

        @JsonProperty
        public HardwareTypeInfo getHardwareTypeInfo() {
            return this.hardwareTypeInfo;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty
        @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResultDeserializer.class)
        @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
        public Result getResult() {
            return this.result;
        }

        @JsonProperty
        public URI getRspec() {
            return this.rspec;
        }

        @JsonProperty
        public List<DiskImage> getDiskImages() {
            return this.diskImages;
        }

        @JsonProperty
        public List<SliverTypeInfo> getSliverTypeInfo() {
            return this.sliverTypeInfo;
        }

        @JsonProperty
        public List<String> getComponentManagerIds() {
            return this.componentManagerIds;
        }

        @JsonIgnore
        public List<GeniUrn> getComponentManagerUrns() {
            return this.componentManagerIds.stream().map(GeniUrn::parse).filter(Objects::nonNull).collect(Collectors.toList());
        }

        @JsonProperty
        public List<ComponentDetails> getComponentDetails() {
            return this.componentDetails;
        }

        @JsonIgnore
        public List<String> getAvailableComponentIds() {
            if (this.componentDetails == null) {
                return null;
            }
            ArrayList<String> res = new ArrayList<String>();
            for (ComponentDetails d : this.componentDetails) {
                if (d.getAvailable() != Boolean.TRUE) continue;
                res.add(d.getId());
            }
            return res;
        }

        @JsonIgnore
        public List<String> getUnavailableComponentIds() {
            if (this.componentDetails == null) {
                return null;
            }
            ArrayList<String> res = new ArrayList<String>();
            for (ComponentDetails d : this.componentDetails) {
                if (d.getAvailable() == Boolean.TRUE) continue;
                res.add(d.getId());
            }
            return res;
        }

        @JsonProperty
        public Map<String, Integer> getCounts() {
            if (this.counts == null) {
                return null;
            }
            return Collections.unmodifiableMap(this.counts);
        }

        @JsonProperty
        public Map<String, Integer> getHwCounts() {
            if (this.hwCounts == null) {
                return null;
            }
            return Collections.unmodifiableMap(this.hwCounts);
        }

        @Override
        @JsonIgnore
        @Nullable
        public Integer getCount(@Nonnull AdvertisementCounts.CountedObject object, @Nonnull AdvertisementCounts.CountScope scope) {
            if (this.counts == null) {
                return null;
            }
            return this.counts.get(object.getKeyPrefixName() + scope.getKeySuffixName());
        }

        @Override
        @JsonIgnore
        @Nullable
        public Integer getHwCount(@Nonnull String hwType, @Nonnull AdvertisementCounts.CountScope scope) {
            if (this.hwCounts == null) {
                return null;
            }
            return this.hwCounts.get(hwType + scope.getKeySuffixName());
        }

        @Override
        @JsonIgnore
        @Nonnull
        public Collection<AdvertisementCounts.AdvertisementCountEntry> getCountEntries() {
            if (this.counts == null) {
                return Collections.emptyList();
            }
            ArrayList<AdvertisementCounts.AdvertisementCountEntry> res = new ArrayList<AdvertisementCounts.AdvertisementCountEntry>();
            for (AdvertisementCounts.CountScope scope : AdvertisementCounts.CountScope.values()) {
                for (AdvertisementCounts.CountedObject obj : AdvertisementCounts.CountedObject.values()) {
                    Integer glimpseCount = this.getCount(obj, scope);
                    if (glimpseCount == null) continue;
                    res.add(new AdvertisementCounts.AdvertisementCountEntry(obj, scope, glimpseCount));
                }
            }
            return res;
        }

        @Override
        @JsonIgnore
        public int getCountEntriesSize() {
            if (this.counts == null) {
                return 0;
            }
            return this.counts.size();
        }

        @Override
        @JsonIgnore
        @Nonnull
        public Collection<AdvertisementCounts.AdvertisementHwCountEntry> getHwCountEntries() {
            if (this.counts == null) {
                return Collections.emptyList();
            }
            ArrayList<AdvertisementCounts.AdvertisementHwCountEntry> res = new ArrayList<AdvertisementCounts.AdvertisementHwCountEntry>();
            for (AdvertisementCounts.CountScope scope : AdvertisementCounts.CountScope.values()) {
                for (String hwType : this.getHwCountKeys()) {
                    Integer glimpseCount = this.getHwCount(hwType, scope);
                    if (glimpseCount == null) continue;
                    res.add(new AdvertisementCounts.AdvertisementHwCountEntry(hwType, scope, glimpseCount));
                }
            }
            return res;
        }

        @Override
        @JsonIgnore
        public int getHwCountEntriesSize() {
            if (this.hwCounts == null) {
                return 0;
            }
            return this.hwCounts.size();
        }

        @Override
        @JsonIgnore
        public List<String> getHwCountKeys() {
            if (this.hwCounts == null) {
                return Collections.emptyList();
            }
            Set res = this.hwCounts.keySet().stream().map(s -> s.replaceAll("(" + Pattern.quote(AdvertisementCounts.CountScope.AVAILABLE.getKeySuffixName()) + "|" + Pattern.quote(AdvertisementCounts.CountScope.ALL.getKeySuffixName()) + ")$", "")).collect(Collectors.toSet());
            return new ArrayList<String>(res);
        }

        @Override
        @JsonIgnore
        @Nullable
        public Date getCountDate() {
            return this.timestamp;
        }

        public String toString() {
            ObjectMapper mapper = Jackson.newObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting SliverTypeInfo to JSON", (Throwable)e);
                return "Exception converting SliverTypeInfo to JSON: " + e.getMessage();
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class HardwareTypeInfo {
            @Nullable
            private final String textOverview;
            @Nullable
            private final URI htmlOverview;
            @Nonnull
            private final List<HardwareTypeInfoEntry> entries;

            public HardwareTypeInfo(@Nullable @JsonProperty(value="textOverview") String textOverview, @Nullable @JsonProperty(value="htmlOverview") URI htmlOverview, @Nullable @JsonProperty(value="entries") List<HardwareTypeInfoEntry> entries) {
                this.textOverview = textOverview;
                this.htmlOverview = htmlOverview;
                this.entries = entries == null ? Collections.emptyList() : entries;
            }

            @Nullable
            @JsonProperty
            public String getTextOverview() {
                return this.textOverview;
            }

            @Nullable
            @JsonProperty
            public URI getHtmlOverview() {
                return this.htmlOverview;
            }

            @Nonnull
            @JsonProperty
            public List<HardwareTypeInfoEntry> getEntries() {
                return this.entries;
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class HardwareTypeInfoEntry {
                @Nonnull
                private final String name;
                @Nullable
                private final String hrn;
                @Nullable
                private final String textDescription;
                @Nullable
                private final URI htmlDescription;

                public HardwareTypeInfoEntry(@Nonnull @JsonProperty(value="name") String name, @Nullable @JsonProperty(value="hrn") String hrn, @Nullable @JsonProperty(value="textDescription") String textDescription, @Nullable @JsonProperty(value="htmlDescription") URI htmlDescription) {
                    this.name = name;
                    this.hrn = hrn;
                    this.textDescription = textDescription;
                    this.htmlDescription = htmlDescription;
                }

                @JsonProperty
                @Nonnull
                public String getName() {
                    return this.name;
                }

                @Nullable
                @JsonProperty
                public String getHrn() {
                    return this.hrn;
                }

                @Nullable
                @JsonProperty
                public String getTextDescription() {
                    return this.textDescription;
                }

                @Nullable
                @JsonProperty
                public URI getHtmlDescription() {
                    return this.htmlDescription;
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(value={"@context"})
        public static class ComponentDetails {
            private final String id;
            private final String componentManagerId;
            private final String siteId;
            private final List<String> hardwareTypes;
            private final Boolean available;
            private final Location location;

            @JsonCreator
            public ComponentDetails(@JsonProperty(value="id") String id, @JsonProperty(value="hw") List<String> hardwareTypes, @JsonProperty(value="available") Boolean available, @JsonProperty(value="loc") Location location, @JsonProperty(value="compMan") String componentManagerId, @JsonProperty(value="site") String siteId) {
                this.id = id;
                this.hardwareTypes = hardwareTypes == null ? null : Collections.unmodifiableList(new ArrayList<String>(hardwareTypes));
                this.available = available;
                this.location = location;
                this.componentManagerId = componentManagerId;
                this.siteId = siteId;
            }

            public ComponentDetails(String id, List<String> hardwareTypes, Boolean available) {
                this(id, hardwareTypes, available, null, null, null);
            }

            @JsonProperty
            public String getId() {
                return this.id;
            }

            @JsonProperty(value="hw")
            public List<String> getHardwareTypes() {
                return this.hardwareTypes;
            }

            @JsonProperty
            public Boolean getAvailable() {
                return this.available;
            }

            @JsonIgnore
            public Boolean getUnavailable() {
                return this.available == false;
            }

            @JsonProperty(value="loc")
            public Location getLocation() {
                return this.location;
            }

            @JsonProperty(value="compMan")
            public String getComponentManagerId() {
                return this.componentManagerId;
            }

            @JsonProperty(value="site")
            public String getSiteId() {
                return this.siteId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ComponentDetails that = (ComponentDetails)o;
                return Objects.equals(this.id, that.id) && Objects.equals(this.componentManagerId, that.componentManagerId) && Objects.equals(this.siteId, that.siteId) && Objects.equals(this.hardwareTypes, that.hardwareTypes) && Objects.equals(this.available, that.available) && Objects.equals(this.location, that.location);
            }

            public int hashCode() {
                return Objects.hash(this.id, this.componentManagerId, this.siteId, this.hardwareTypes, this.available, this.location);
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonIgnoreProperties(value={"@context"})
            public static class Location {
                private String country;
                private Double lat;
                private Double lng;

                public Location(@JsonProperty(value="country") String country, @JsonProperty(value="lat") Double lat, @JsonProperty(value="lng") Double lng) {
                    this.country = country;
                    this.lat = lat;
                    this.lng = lng;
                }

                public Location(Double lat, Double lng) {
                    this.country = null;
                    this.lat = lat;
                    this.lng = lng;
                }

                @JsonProperty(value="country")
                public String getCountry() {
                    return this.country;
                }

                @JsonProperty(value="lat")
                public Double getLatitude() {
                    return this.lat;
                }

                @JsonProperty(value="lng")
                public Double getLongitude() {
                    return this.lng;
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    Location location = (Location)o;
                    if (this.country != null ? !this.country.equals(location.country) : location.country != null) {
                        return false;
                    }
                    if (this.lat != null ? !this.lat.equals(location.lat) : location.lat != null) {
                        return false;
                    }
                    return this.lng != null ? this.lng.equals(location.lng) : location.lng == null;
                }

                public int hashCode() {
                    int result = this.country != null ? this.country.hashCode() : 0;
                    result = 31 * result + (this.lat != null ? this.lat.hashCode() : 0);
                    result = 31 * result + (this.lng != null ? this.lng.hashCode() : 0);
                    return result;
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(value={"@context"})
        public static class SliverTypeInfo {
            private final String sliverType;
            private final Set<String> hardwareTypes;
            private final Set<String> flavors;
            private final String defaultDiskImage;

            @JsonCreator
            public SliverTypeInfo(@JsonProperty(value="sliverType") String sliverType, @JsonProperty(value="hardwareTypes") Collection<String> hardwareTypes, @JsonProperty(value="flavors") Collection<String> flavors, @JsonProperty(value="defaultDiskImage") String defaultDiskImage) {
                this.sliverType = sliverType;
                this.hardwareTypes = hardwareTypes == null ? null : Collections.unmodifiableSet(new TreeSet<String>(hardwareTypes));
                this.flavors = flavors == null ? null : Collections.unmodifiableSet(new TreeSet<String>(flavors));
                this.defaultDiskImage = defaultDiskImage;
            }

            @JsonProperty
            public String getSliverType() {
                return this.sliverType;
            }

            @JsonProperty
            public Set<String> getHardwareTypes() {
                return this.hardwareTypes;
            }

            @JsonProperty
            public Set<String> getFlavors() {
                return this.flavors;
            }

            @JsonProperty
            public String getDefaultDiskImage() {
                return this.defaultDiskImage;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SliverTypeInfo that = (SliverTypeInfo)o;
                return Objects.equals(this.sliverType, that.sliverType) && Objects.equals(this.hardwareTypes, that.hardwareTypes) && Objects.equals(this.flavors, that.flavors) && Objects.equals(this.defaultDiskImage, that.defaultDiskImage);
            }

            public int hashCode() {
                return Objects.hash(this.sliverType, this.hardwareTypes, this.flavors, this.defaultDiskImage);
            }

            public String toString() {
                ObjectMapper mapper = Jackson.newObjectMapper();
                try {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
                }
                catch (JsonProcessingException e) {
                    LOG.error("Exception converting SliverTypeInfo to JSON", (Throwable)e);
                    return "Exception converting SliverTypeInfo to JSON: " + e.getMessage();
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(value={"@context"})
        public static class DiskImage {
            private final String description;
            private final String name;
            private final String os;
            private final String url;
            private final String version;
            private final Set<String> sliverTypes;

            @JsonCreator
            public DiskImage(@JsonProperty(value="description") String description, @JsonProperty(value="name") String name, @JsonProperty(value="os") String os, @JsonProperty(value="url") String url, @JsonProperty(value="version") String version, @JsonProperty(value="sliverTypes") Collection<String> sliverTypes) {
                this.description = description;
                this.name = name;
                this.os = os;
                this.url = url;
                this.version = version;
                this.sliverTypes = sliverTypes == null ? null : new TreeSet<String>(sliverTypes);
            }

            @JsonProperty
            public String getDescription() {
                return this.description;
            }

            @JsonProperty
            public String getName() {
                return this.name;
            }

            @JsonProperty
            public String getOs() {
                return this.os;
            }

            @JsonProperty
            public String getUrl() {
                return this.url;
            }

            @JsonProperty
            public String getVersion() {
                return this.version;
            }

            @JsonProperty
            public Set<String> getSliverTypes() {
                return Collections.unmodifiableSet(this.sliverTypes);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DiskImage diskImage = (DiskImage)o;
                if (this.description != null ? !this.description.equals(diskImage.description) : diskImage.description != null) {
                    return false;
                }
                if (this.name != null ? !this.name.equals(diskImage.name) : diskImage.name != null) {
                    return false;
                }
                if (this.os != null ? !this.os.equals(diskImage.os) : diskImage.os != null) {
                    return false;
                }
                if (this.sliverTypes != null ? !this.sliverTypes.equals(diskImage.sliverTypes) : diskImage.sliverTypes != null) {
                    return false;
                }
                if (this.url != null ? !this.url.equals(diskImage.url) : diskImage.url != null) {
                    return false;
                }
                return !(this.version != null ? !this.version.equals(diskImage.version) : diskImage.version != null);
            }

            public int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                result = 31 * result + (this.sliverTypes != null ? this.sliverTypes.hashCode() : 0);
                return result;
            }

            public String toString() {
                ObjectMapper mapper = Jackson.newObjectMapper();
                try {
                    return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
                }
                catch (JsonProcessingException e) {
                    LOG.error("Exception converting DiskImage to JSON", (Throwable)e);
                    return "Exception converting DiskImage to JSON: " + e.getMessage();
                }
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(value={"@context"})
    public static class HealthInfo {
        private final Timestamp timestamp;
        private final Result result;
        private final Integer health;
        private final String healthExplanation;
        private final String healthExplanationFull;
        private final String status;

        @JsonCreator
        public HealthInfo(@JsonProperty(value="timestamp") Timestamp timestamp, @JsonProperty(value="result") Result result, @JsonProperty(value="health") Integer health, @JsonProperty(value="healthExplanation") String healthExplanation, @JsonProperty(value="healthExplanationFull") String healthExplanationFull, @JsonProperty(value="status") String status) {
            this.timestamp = timestamp;
            this.result = result;
            this.health = health;
            this.healthExplanation = healthExplanation;
            this.healthExplanationFull = healthExplanationFull;
            this.status = status;
        }

        @JsonProperty
        @JsonSerialize(using=JsonTimeStampRFC3339Serializer.class)
        @JsonDeserialize(using=JsonTimeStampRFC3339Deserializer.class)
        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty
        @JsonDeserialize(using=FedmonFullObjectLinkDeserializers.ResultDeserializer.class)
        @JsonSerialize(using=JsonLdObjectLinkSerializer.NeverEmbedChildLinkSerializer.class)
        public Result getResult() {
            return this.result;
        }

        @JsonProperty
        public Integer getHealth() {
            return this.health;
        }

        @JsonProperty
        public String getHealthExplanation() {
            return this.healthExplanation;
        }

        @JsonProperty
        public String getHealthExplanationFull() {
            return this.healthExplanationFull;
        }

        @JsonProperty
        public String getStatus() {
            return this.status;
        }

        public String toString() {
            ObjectMapper mapper = Jackson.newObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                LOG.error("Exception converting HealthInfo to JSON", (Throwable)e);
                return "Exception converting HealthInfo to JSON: " + e.getMessage();
            }
        }
    }
}

