/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.webapi.service.json;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestEmailConfig;
import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.impl.BasicLdObjectBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonLdObjectsMetaData.JsonLdObjectBuilderInfo(objectClass=TestEmailConfig.class)
public class TestEmailConfigBuilder
extends BasicLdObjectBuilder<TestEmailConfig> {
    private List<String> addresses;
    private List<String> altAddresses;
    private List<TestEmailConfig.Trigger> triggers;
    private TestEmailConfig.Limits limits;
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public TestEmailConfigBuilder() {
    }

    public TestEmailConfigBuilder(TestEmailConfig orig) {
        super((JsonLdObject)orig);
        this.addresses = orig.getAddresses() == null ? null : new ArrayList<String>(orig.getAddresses());
        this.altAddresses = orig.getAltAddresses() == null ? null : new ArrayList<String>(orig.getAltAddresses());
        this.triggers = orig.getTriggers() == null ? null : new ArrayList<TestEmailConfig.Trigger>(orig.getTriggers());
        this.limits = orig.getLimits();
    }

    public TestEmailConfigBuilder(Map jsonMap) throws IOException {
        this((TestEmailConfig)((Object)MAPPER.readValue(MAPPER.writer().writeValueAsString((Object)jsonMap), TestEmailConfig.class)));
    }

    public TestEmailConfigBuilder setAddresses(List<String> addresses) {
        this.addresses = addresses == null ? null : new ArrayList<String>(addresses);
        return this;
    }

    public TestEmailConfigBuilder addAddress(String address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(address);
        return this;
    }

    public TestEmailConfigBuilder setAltAddresses(List<String> altAddresses) {
        this.altAddresses = altAddresses == null ? null : new ArrayList<String>(altAddresses);
        return this;
    }

    public TestEmailConfigBuilder addAltAddress(String address) {
        if (this.altAddresses == null) {
            this.altAddresses = new ArrayList<String>();
        }
        this.altAddresses.add(address);
        return this;
    }

    public TestEmailConfigBuilder setTriggers(@Nullable List<TestEmailConfig.Trigger> triggers) {
        this.triggers = triggers == null ? null : new ArrayList<TestEmailConfig.Trigger>(triggers);
        return this;
    }

    public TestEmailConfigBuilder removeTrigger(@Nonnull TestEmailConfig.TestResultStatus requiredStatus, boolean onlyForFirst, boolean negate) {
        if (this.triggers == null) {
            return this;
        }
        ArrayList<TestEmailConfig.Trigger> toRemove = new ArrayList<TestEmailConfig.Trigger>();
        for (TestEmailConfig.Trigger trigger : this.triggers) {
            assert (trigger.getRequiredStatus() != null);
            if (trigger.getOnlyForFirstOrDefault() != onlyForFirst || trigger.getNegationOrDefault() != negate || !trigger.getRequiredStatus().equals((Object)requiredStatus)) continue;
            toRemove.add(trigger);
        }
        this.triggers.removeAll(toRemove);
        return this;
    }

    public TestEmailConfigBuilder removeTrigger(@Nonnull TestEmailConfig.Trigger trigger) {
        return this.removeTrigger(trigger.getRequiredStatus(), trigger.getOnlyForFirstOrDefault(), trigger.getNegationOrDefault());
    }

    public TestEmailConfigBuilder setTrigger(@Nonnull TestEmailConfig.Trigger trigger) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<TestEmailConfig.Trigger>();
        } else {
            assert (trigger.getRequiredStatus() != null);
            this.removeTrigger(trigger.getRequiredStatus(), trigger.getOnlyForFirstOrDefault(), trigger.getNegationOrDefault());
        }
        this.triggers.add(trigger);
        return this;
    }

    public TestEmailConfigBuilder setTrigger(@Nonnull TestEmailConfig.TestResultStatus requiredStatus, boolean onlyForFirst, boolean negate, @Nullable String repeatCron, @Nullable String subject, @Nullable String body) {
        if (this.triggers == null) {
            this.triggers = new ArrayList<TestEmailConfig.Trigger>();
        } else {
            this.removeTrigger(requiredStatus, onlyForFirst, negate);
        }
        this.triggers.add(new TestEmailConfig.Trigger(requiredStatus, onlyForFirst, negate, repeatCron, subject, body));
        return this;
    }

    public TestEmailConfigBuilder setLimits(TestEmailConfig.Limits limits) {
        this.limits = limits;
        return this;
    }

    public TestEmailConfigBuilder setLimits(Integer maxPerDay, Integer maxPerHour) {
        this.limits = new TestEmailConfig.Limits(maxPerDay, maxPerHour);
        return this;
    }

    public TestEmailConfigBuilder setLimitMaxPerDay(Integer maxPerDay) {
        this.limits = this.limits == null ? new TestEmailConfig.Limits(maxPerDay, null) : new TestEmailConfig.Limits(maxPerDay, this.limits.getMaxPerHour());
        return this;
    }

    public TestEmailConfigBuilder setLimitMaxPerHour(Integer maxPerHour) {
        this.limits = this.limits == null ? new TestEmailConfig.Limits(null, maxPerHour) : new TestEmailConfig.Limits(this.limits.getMaxPerDay(), maxPerHour);
        return this;
    }

    public TestEmailConfigBuilder fillInDefaults(@Nullable TestEmailConfig fallbackDefault) {
        if (fallbackDefault != null) {
            if (this.getAddresses() == null) {
                this.setAddresses(fallbackDefault.getAddresses());
            }
            if (this.getAltAddresses() == null) {
                this.setAltAddresses(fallbackDefault.getAltAddresses());
            }
            if (this.getTriggers() == null) {
                this.setTriggers(fallbackDefault.getTriggers());
            }
            if (this.getLimits() == null) {
                this.setLimits(fallbackDefault.getLimits());
            }
        }
        return this;
    }

    public TestEmailConfig create() {
        return new TestEmailConfig(this.addresses, this.altAddresses, this.triggers, this.limits);
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public List<String> getAltAddresses() {
        return this.altAddresses;
    }

    public List<TestEmailConfig.Trigger> getTriggers() {
        return this.triggers;
    }

    public TestEmailConfig.Limits getLimits() {
        return this.limits;
    }

    public TestEmailConfig.Trigger getTrigger(@Nonnull TestEmailConfig.TestResultStatus requiredStatus, boolean onlyForFirst, boolean negate) {
        if (this.triggers == null) {
            return null;
        }
        for (TestEmailConfig.Trigger trigger : this.triggers) {
            assert (trigger.getRequiredStatus() != null);
            if (trigger.getOnlyForFirstOrDefault() != onlyForFirst || trigger.getNegationOrDefault() != negate || !trigger.getRequiredStatus().equals((Object)requiredStatus)) continue;
            return trigger;
        }
        return null;
    }
}

