/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.ConnectionMonitor;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.HTTPProxyData;
import ch.ethz.ssh2.HTTPProxyException;
import ch.ethz.ssh2.ProxyData;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.crypto.Base64;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketDisconnect;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.server.ServerConnectionState;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.transport.ClientKexManager;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.ServerKexManager;
import ch.ethz.ssh2.transport.TransportConnection;
import ch.ethz.ssh2.util.SocketWithCustomSocketFactory;
import ch.ethz.ssh2.util.StringEncoder;
import ch.ethz.ssh2.util.Tokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportManager {
    private static final Logger log = Logger.getLogger(TransportManager.class);
    protected SocketImplFactory socketImplFactory;
    private final List<AsynchronousEntry> asynchronousQueue = new Vector<AsynchronousEntry>();
    private Thread asynchronousThread = null;
    private boolean asynchronousPending = false;
    private Socket sock;
    private final Object connectionSemaphore = new Object();
    private boolean flagKexOngoing = false;
    private boolean connectionClosed = false;
    private Throwable reasonClosedCause = null;
    private TransportConnection tc;
    private KexManager km;
    private final List<HandlerEntry> messageHandlers = new Vector<HandlerEntry>();
    private Thread receiveThread;
    private List<ConnectionMonitor> connectionMonitors = new Vector<ConnectionMonitor>();
    private boolean monitorsWereInformed = false;
    private boolean idle;

    public TransportManager(SocketImplFactory socketImplFactory) throws SocketException {
        this.socketImplFactory = socketImplFactory;
        this.sock = socketImplFactory != null ? new SocketWithCustomSocketFactory(socketImplFactory) : new Socket();
    }

    private static InetAddress createInetAddress(String host) throws UnknownHostException {
        InetAddress addr = TransportManager.parseIPv4Address(host);
        if (addr != null) {
            return addr;
        }
        return InetAddress.getByName(host);
    }

    private static InetAddress parseIPv4Address(String host) throws UnknownHostException {
        if (host == null) {
            return null;
        }
        String[] quad = Tokenizer.parseTokens(host, '.');
        if (quad == null || quad.length != 4) {
            return null;
        }
        byte[] addr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int part = 0;
            if (quad[i].length() == 0 || quad[i].length() > 3) {
                return null;
            }
            for (int k = 0; k < quad[i].length(); ++k) {
                char c = quad[i].charAt(k);
                if (c < '0' || c > '9') {
                    return null;
                }
                part = part * 10 + (c - 48);
            }
            if (part > 255) {
                return null;
            }
            addr[i] = (byte)part;
        }
        return InetAddress.getByAddress(host, addr);
    }

    public int getPacketOverheadEstimate() {
        return this.tc.getPacketOverheadEstimate();
    }

    public void setTcpNoDelay(boolean state) throws IOException {
        this.sock.setTcpNoDelay(state);
    }

    public void setSoTimeout(int timeout) throws IOException {
        this.sock.setSoTimeout(timeout);
    }

    public ConnectionInfo getConnectionInfo(int kexNumber) throws IOException {
        return this.km.getOrWaitForConnectionInfo(kexNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            return this.reasonClosedCause;
        }
    }

    public byte[] getSessionIdentifier() {
        return this.km.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable cause, boolean useDisconnectPacket) {
        if (!useDisconnectPacket) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (!this.connectionClosed) {
                if (useDisconnectPacket) {
                    try {
                        byte[] msg = new PacketDisconnect(11, cause.getMessage(), "").getPayload();
                        if (this.tc != null) {
                            this.tc.sendMessage(msg);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.connectionClosed = true;
                this.reasonClosedCause = cause;
            }
            this.connectionSemaphore.notifyAll();
        }
        Vector<ConnectionMonitor> monitors = new Vector<ConnectionMonitor>();
        TransportManager transportManager = this;
        synchronized (transportManager) {
            if (!this.monitorsWereInformed) {
                this.monitorsWereInformed = true;
                monitors.addAll(this.connectionMonitors);
            }
        }
        for (ConnectionMonitor cmon : monitors) {
            try {
                cmon.connectionLost(this.reasonClosedCause);
            }
            catch (Exception exception) {}
        }
    }

    private static Socket establishConnection(SocketImplFactory socketImplFactory, String hostname, int port, ProxyData proxyData, int connectTimeout) throws IOException {
        if (proxyData == null) {
            InetAddress addr = TransportManager.createInetAddress(hostname);
            Socket s = socketImplFactory == null ? new Socket() : new SocketWithCustomSocketFactory(socketImplFactory);
            s.connect(new InetSocketAddress(addr, port), connectTimeout);
            return s;
        }
        if (proxyData instanceof HTTPProxyData) {
            HTTPProxyData pd = (HTTPProxyData)proxyData;
            InetAddress addr = TransportManager.createInetAddress(pd.proxyHost);
            Socket s = socketImplFactory == null ? new Socket() : new SocketWithCustomSocketFactory(socketImplFactory);
            s.connect(new InetSocketAddress(addr, pd.proxyPort), connectTimeout);
            StringBuilder sb = new StringBuilder();
            sb.append("CONNECT ");
            sb.append(hostname);
            sb.append(':');
            sb.append(port);
            sb.append(" HTTP/1.0\r\n");
            if (pd.proxyUser != null && pd.proxyPass != null) {
                String credentials = pd.proxyUser + ":" + pd.proxyPass;
                char[] encoded = Base64.encode(StringEncoder.GetBytes(credentials));
                sb.append("Proxy-Authorization: Basic ");
                sb.append(encoded);
                sb.append("\r\n");
            }
            if (pd.requestHeaderLines != null) {
                for (int i = 0; i < pd.requestHeaderLines.length; ++i) {
                    if (pd.requestHeaderLines[i] == null) continue;
                    sb.append(pd.requestHeaderLines[i]);
                    sb.append("\r\n");
                }
            }
            sb.append("\r\n");
            OutputStream out = s.getOutputStream();
            out.write(StringEncoder.GetBytes(sb.toString()));
            out.flush();
            byte[] buffer = new byte[1024];
            InputStream in = s.getInputStream();
            int len = ClientServerHello.readLineRN(in, buffer);
            String httpReponse = StringEncoder.GetString(buffer, 0, len);
            if (!httpReponse.startsWith("HTTP/")) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (httpReponse.length() < 14 || httpReponse.charAt(8) != ' ' || httpReponse.charAt(12) != ' ') {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            int errorCode = 0;
            try {
                errorCode = Integer.parseInt(httpReponse.substring(9, 12));
            }
            catch (NumberFormatException ignore) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (errorCode < 0 || errorCode > 999) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (errorCode != 200) {
                throw new HTTPProxyException(httpReponse.substring(13), errorCode);
            }
            while ((len = ClientServerHello.readLineRN(in, buffer)) != 0) {
            }
            return s;
        }
        throw new IOException("Unsupported ProxyData");
    }

    private void startReceiver() throws IOException {
        this.receiveThread = new Thread(new Runnable(){

            public void run() {
                try {
                    TransportManager.this.receiveLoop();
                }
                catch (Exception e) {
                    TransportManager.this.close(e, false);
                    log.warning("Receive thread: error in receiveLoop: " + e.getMessage());
                }
                if (log.isDebugEnabled()) {
                    log.debug("Receive thread: back from receiveLoop");
                }
                if (TransportManager.this.km != null) {
                    try {
                        TransportManager.this.km.handleMessage(null, 0);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                for (HandlerEntry he : TransportManager.this.messageHandlers) {
                    try {
                        he.mh.handleMessage(null, 0);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
    }

    public void clientInit(String hostname, int port, String softwareversion, CryptoWishList cwl, ServerHostKeyVerifier verifier, DHGexParameters dhgex, int connectTimeout, SecureRandom rnd, ProxyData proxyData) throws IOException {
        this.sock = TransportManager.establishConnection(this.socketImplFactory, hostname, port, proxyData, connectTimeout);
        ClientServerHello csh = ClientServerHello.clientHello(softwareversion, this.sock.getInputStream(), this.sock.getOutputStream());
        this.tc = new TransportConnection(this.sock.getInputStream(), this.sock.getOutputStream(), rnd);
        this.km = new ClientKexManager(this, csh, cwl, hostname, port, verifier, rnd);
        this.km.initiateKEX(cwl, dhgex, null, null);
        this.startReceiver();
    }

    public void serverInit(ServerConnectionState state) throws IOException {
        this.sock = state.s;
        state.csh = ClientServerHello.serverHello(state.softwareversion, this.sock.getInputStream(), this.sock.getOutputStream());
        this.tc = new TransportConnection(this.sock.getInputStream(), this.sock.getOutputStream(), state.generator);
        this.km = new ServerKexManager(this.socketImplFactory, state);
        this.km.initiateKEX(state.next_cryptoWishList, null, state.next_dsa_key, state.next_rsa_key);
        this.startReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(MessageHandler mh, int low, int high) {
        HandlerEntry he = new HandlerEntry();
        he.mh = mh;
        he.low = low;
        he.high = high;
        List<HandlerEntry> list = this.messageHandlers;
        synchronized (list) {
            this.messageHandlers.add(he);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler mh, int low, int high) {
        List<HandlerEntry> list = this.messageHandlers;
        synchronized (list) {
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry he = this.messageHandlers.get(i);
                if (he.mh != mh || he.low != low || he.high != high) continue;
                this.messageHandlers.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKexMessage(byte[] msg) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
            }
            this.flagKexOngoing = true;
            try {
                this.tc.sendMessage(msg);
            }
            catch (IOException e) {
                this.close(e, false);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kexFinished() throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            this.flagKexOngoing = false;
            this.connectionSemaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceKeyExchange(CryptoWishList cwl, DHGexParameters dhgex, DSAPrivateKey dsa, RSAPrivateKey rsa) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
            }
        }
        this.km.initiateKEX(cwl, dhgex, dsa, rsa);
    }

    public void changeRecvCipher(BlockCipher bc, MAC mac) {
        this.tc.changeRecvCipher(bc, mac);
    }

    public void changeSendCipher(BlockCipher bc, MAC mac) {
        this.tc.changeSendCipher(bc, mac);
    }

    public void sendAsynchronousMessage(byte[] msg) throws IOException {
        this.sendAsynchronousMessage(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsynchronousMessage(byte[] msg, Runnable run) throws IOException {
        List<AsynchronousEntry> list = this.asynchronousQueue;
        synchronized (list) {
            this.asynchronousQueue.add(new AsynchronousEntry(msg, run));
            this.asynchronousPending = true;
            if (this.asynchronousQueue.size() > 100) {
                throw new IOException("Error: the peer is not consuming our asynchronous replies.");
            }
            if (this.asynchronousThread == null) {
                this.asynchronousThread = new AsynchronousWorker();
                this.asynchronousThread.setDaemon(true);
                this.asynchronousThread.start();
            }
            this.asynchronousQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionMonitors(List<ConnectionMonitor> monitors) {
        TransportManager transportManager = this;
        synchronized (transportManager) {
            this.connectionMonitors = new Vector<ConnectionMonitor>();
            this.connectionMonitors.addAll(monitors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] msg) throws IOException {
        List<AsynchronousEntry> list = this.asynchronousQueue;
        synchronized (list) {
            while (this.asynchronousPending) {
                try {
                    this.asynchronousQueue.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.sendMessageImmediate(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageImmediate(byte[] msg) throws IOException {
        if (Thread.currentThread() == this.receiveThread) {
            throw new IOException("Assertion error: sendMessage may never be invoked by the receiver thread!");
        }
        boolean wasInterrupted = false;
        try {
            Object object = this.connectionSemaphore;
            synchronized (object) {
                while (true) {
                    if (this.connectionClosed) {
                        throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
                    }
                    if (!this.flagKexOngoing) break;
                    try {
                        this.connectionSemaphore.wait();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                }
                try {
                    this.tc.sendMessage(msg);
                    this.idle = false;
                }
                catch (IOException e) {
                    this.close(e, false);
                    throw e;
                }
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void receiveLoop() throws IOException {
        byte[] msg = new byte[35000];
        while (true) {
            TypesReader tr;
            int msglen;
            try {
                msglen = this.tc.receiveMessage(msg, 0, msg.length);
            }
            catch (SocketTimeoutException e) {
                if (this.idle) {
                    log.debug("Ignoring socket timeout");
                    continue;
                }
                throw e;
            }
            this.idle = true;
            int type = msg[0] & 0xFF;
            if (type == 2) continue;
            if (type == 4) {
                if (!log.isDebugEnabled()) continue;
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                tr.readBoolean();
                StringBuilder debugMessageBuffer = new StringBuilder();
                debugMessageBuffer.append(tr.readString("UTF-8"));
                for (int i = 0; i < debugMessageBuffer.length(); ++i) {
                    char c = debugMessageBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    debugMessageBuffer.setCharAt(i, '\ufffd');
                }
                log.debug("DEBUG Message from remote: '" + debugMessageBuffer.toString() + "'");
                continue;
            }
            if (type == 3) {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            if (type == 1) {
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                int reason_code = tr.readUINT32();
                StringBuilder reasonBuffer = new StringBuilder();
                reasonBuffer.append(tr.readString("UTF-8"));
                if (reasonBuffer.length() > 255) {
                    reasonBuffer.setLength(255);
                    reasonBuffer.setCharAt(254, '.');
                    reasonBuffer.setCharAt(253, '.');
                    reasonBuffer.setCharAt(252, '.');
                }
                for (int i = 0; i < reasonBuffer.length(); ++i) {
                    char c = reasonBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    reasonBuffer.setCharAt(i, '\ufffd');
                }
                throw new IOException("Peer sent DISCONNECT message (reason code " + reason_code + "): " + reasonBuffer.toString());
            }
            if (type == 20 || type == 21 || type >= 30 && type <= 49) {
                this.km.handleMessage(msg, msglen);
                continue;
            }
            MessageHandler mh = null;
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry he = this.messageHandlers.get(i);
                if (he.low > type || type > he.high) continue;
                mh = he.mh;
                break;
            }
            if (mh == null) {
                throw new IOException("Unexpected SSH message (type " + type + ")");
            }
            mh.handleMessage(msg, msglen);
        }
    }

    class AsynchronousWorker
    extends Thread {
        AsynchronousWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                AsynchronousEntry item = null;
                List list = TransportManager.this.asynchronousQueue;
                synchronized (list) {
                    if (TransportManager.this.asynchronousQueue.size() == 0) {
                        TransportManager.this.asynchronousPending = false;
                        TransportManager.this.asynchronousQueue.notifyAll();
                        try {
                            TransportManager.this.asynchronousQueue.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TransportManager.this.asynchronousQueue.size() == 0) {
                            TransportManager.this.asynchronousThread = null;
                            return;
                        }
                    }
                    item = (AsynchronousEntry)TransportManager.this.asynchronousQueue.remove(0);
                }
                try {
                    TransportManager.this.sendMessageImmediate(item.msg);
                }
                catch (IOException e) {
                    return;
                }
                if (item.run == null) continue;
                try {
                    item.run.run();
                }
                catch (Exception exception) {
                }
            }
        }
    }

    class AsynchronousEntry {
        public byte[] msg;
        public Runnable run;

        public AsynchronousEntry(byte[] msg, Runnable run) {
            this.msg = msg;
            this.run = run;
        }
    }

    private static class HandlerEntry {
        MessageHandler mh;
        int low;
        int high;

        private HandlerEntry() {
        }
    }
}

