/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.HostAndPortTest;
import be.iminds.ilabt.jfed.connectivity_tester.TestsGenerator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AMConnectionTestGenerator
implements TestsGenerator {
    private final TestbedInfoSource testbedInfoSource;

    @Inject
    public AMConnectionTestGenerator(TestbedInfoSource testbedInfoSource) {
        this.testbedInfoSource = testbedInfoSource;
    }

    public Collection<ConnectivityTest> generateTests() {
        HashMultimap testsPerHost = HashMultimap.create();
        ArrayList<ConnectivityTest> tests = new ArrayList<ConnectivityTest>();
        this.testbedInfoSource.getServers().stream().filter(auth -> auth.hasFlag(Server.Flag.includeInConnectivityTest)).filter(auth -> !auth.hasFlag(Server.Flag.excludeInConnectivityTest)).forEach(arg_0 -> AMConnectionTestGenerator.lambda$generateTests$2((Multimap)testsPerHost, arg_0));
        tests.addAll(testsPerHost.keySet().stream().map(arg_0 -> AMConnectionTestGenerator.lambda$generateTests$3((Multimap)testsPerHost, arg_0)).collect(Collectors.toList()));
        return tests;
    }

    private static /* synthetic */ HostAndPortTest lambda$generateTests$3(Multimap testsPerHost, HostnameAndPort hostnameAndPort) {
        return new HostAndPortTest(hostnameAndPort.getHostname(), hostnameAndPort.getPort(), ApiInfo.mergeApiInfos(testsPerHost.get((Object)hostnameAndPort)), "AM");
    }

    private static /* synthetic */ void lambda$generateTests$2(Multimap testsPerHost, Server server) {
        for (Service service : server.getServices()) {
            try {
                URL url = new URL(service.getUrl());
                testsPerHost.put((Object)new HostnameAndPort(url.getHost(), url.getPort() != -1 ? url.getPort() : url.getDefaultPort()), (Object)new ApiInfo(server.getName(), service.getApi(), service.getApiVersion()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private static class HostnameAndPort {
        private final String hostname;
        private final int port;

        private HostnameAndPort(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostnameAndPort that = (HostnameAndPort)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.hostname != null ? !Objects.equals(this.hostname, that.hostname) : that.hostname != null);
        }

        public int hashCode() {
            int result = this.hostname != null ? this.hostname.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }
    }

    private static class ApiInfo
    implements Comparable<ApiInfo> {
        private final String name;
        private final String role;
        private final String version;

        private ApiInfo(String name, String role, String version) {
            this.name = name;
            this.role = role;
            this.version = version;
        }

        public String toString() {
            return String.format("%s %sv%s", this.name, this.role, this.version);
        }

        public static String mergeApiInfos(Collection<ApiInfo> apiInfos) {
            ArrayList<ApiInfo> infos = new ArrayList<ApiInfo>(apiInfos);
            Collections.sort(infos);
            String currentName = null;
            StringBuilder result = new StringBuilder();
            boolean newName = true;
            for (ApiInfo apiInfo : infos) {
                if (!Objects.equals(apiInfo.name, currentName)) {
                    if (currentName != null) {
                        result.append("; ");
                    }
                    result.append(apiInfo.name).append(" ");
                    currentName = apiInfo.name;
                    newName = true;
                }
                if (!newName) {
                    result.append(", ");
                }
                result.append(apiInfo.role).append("v").append(apiInfo.version);
                newName = false;
            }
            return result.toString();
        }

        @Override
        public int compareTo(ApiInfo o) {
            int result = this.name.compareTo(o.name);
            if (result == 0) {
                result = this.role.compareTo(o.role);
            }
            if (result == 0) {
                result = this.version.compareTo(o.version);
            }
            return result;
        }
    }
}

