/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;

public interface ConnectivityTest
extends Callable<ConnectivityTestResult> {
    public String getName();

    public boolean isLoginRequired();

    public static class ConnectivityTestResult {
        private final Status status;
        private final String message;
        private final Throwable exception;

        public ConnectivityTestResult(Status status, String message, Throwable exception) {
            this.status = status;
            this.message = message;
            this.exception = exception;
        }

        public ConnectivityTestResult(Status status, String message) {
            this.status = status;
            this.message = message;
            this.exception = null;
        }

        public ConnectivityTestResult(Status status, Throwable exception) {
            this.status = status;
            this.message = exception.getMessage();
            this.exception = exception;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getExceptionString() {
            if (this.exception == null) {
                return null;
            }
            StringWriter sw = new StringWriter();
            this.exception.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }

        public String toString() {
            return "ConnectivityTestResult{status=" + this.status + ", message='" + this.message + "', exception=" + this.exception + (String)(this.exception == null ? "" : ", exception_message=" + this.exception.getMessage() + ", exception_class=" + this.exception.getClass().getName() + ", exception_stacktrace=" + IOUtils.exceptionToStacktraceString((Throwable)this.exception)) + "}";
        }
    }

    public static enum Status {
        SUCCEEDED,
        WARNING,
        FAILED,
        SKIPPED;

    }
}

