/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;

public class HasIPv4AddressTest
implements ConnectivityTest {
    @Override
    public String getName() {
        return "Check for IPv4-address";
    }

    @Override
    public boolean isLoginRequired() {
        return false;
    }

    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface interf = interfaces.nextElement();
                if (!interf.isUp() || interf.isLoopback()) continue;
                List<InterfaceAddress> adrs = interf.getInterfaceAddresses();
                for (InterfaceAddress adr : adrs) {
                    InetAddress inadr = adr.getAddress();
                    if (!(inadr instanceof Inet4Address)) continue;
                    return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Found network-address " + inadr.getHostAddress() + " on interface " + interf.getDisplayName());
                }
            }
        }
        catch (SocketException e) {
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, e);
        }
        return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Could not find non-loopback IPv4-address for this computer");
    }
}

