/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.util.library.SshProxySocketImplFactory;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class HostAndPortTest
implements ConnectivityTest {
    private static final Logger LOG = LoggerFactory.getLogger(HostAndPortTest.class);
    private static final int TIMEOUT = 5000;
    private final JFedConnection.ProxyInfo proxyInfo;
    @Nonnull
    private final String hostname;
    private final int port;
    private final String description;
    private final String category;

    public HostAndPortTest(@Nonnull String hostname, int port, String description, String category) {
        this(hostname, port, description, category, null);
    }

    public HostAndPortTest(String hostname, int port, String description, String category, JFedConnection.ProxyInfo proxyInfo) {
        this.hostname = hostname;
        this.port = port;
        this.proxyInfo = proxyInfo;
        this.description = description;
        this.category = category;
    }

    public HostAndPortTest(URL url, String description, String category, JFedConnection.ProxyInfo proxyInfo) {
        this(url.getHost(), url.getPort() != -1 ? url.getPort() : url.getDefaultPort(), description, category, proxyInfo);
    }

    public HostAndPortTest(URL url, String description, String category) {
        this(url, description, category, null);
    }

    @Override
    public String getName() {
        return String.format("[%s] %s", this.category, this.description);
    }

    @Override
    public boolean isLoginRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        InetAddress[] inetAddresses;
        try {
            inetAddresses = Address.getAllByName((String)this.hostname);
        }
        catch (UnknownHostException e) {
            LOG.trace("Got UnknownHostException when trying to resolve {}", (Object)this.hostname, (Object)e);
            try {
                inetAddresses = InetAddress.getAllByName(this.hostname);
                LOG.trace("Could resolve {} to {} with backup method", (Object)this.hostname, (Object)inetAddresses);
            }
            catch (UnknownHostException e1) {
                LOG.trace("Also got UnknownHostException when trying to resolve {} with backup method", (Object)this.hostname, (Object)e1);
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, e);
            }
        }
        ArrayList<CallSite> errorMessages = new ArrayList<CallSite>();
        IOException lastError = null;
        for (InetAddress inetAddress : inetAddresses) {
            LOG.trace("Trying to connect using InetAddress {} and port {} to host {}", new Object[]{inetAddress, this.port, this.hostname});
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, this.port);
            Socket socket = null;
            try {
                Object proxy;
                if (this.proxyInfo != null) {
                    if (this.proxyInfo instanceof JFedConnection.SshProxyInfo) {
                        JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)this.proxyInfo;
                        SshProxySocketImplFactory sshHSocketImplFactory = SshProxySocketImplFactory.getFactory((JFedConnection.SshProxyInfo)sshProxyInfo);
                        socket = new SSHSocket(sshHSocketImplFactory);
                    } else {
                        proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.proxyInfo.getHostname(), this.proxyInfo.getPort()));
                        socket = new Socket((Proxy)proxy);
                    }
                } else {
                    socket = new Socket();
                }
                socket.connect(socketAddress, 5000);
                if (socket.isConnected()) {
                    LOG.trace("Could successfully connect to {}:{}", (Object)this.hostname, (Object)this.port);
                    proxy = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Successfully opened socket to " + this.hostname + ":" + this.port);
                    return proxy;
                }
                LOG.trace("Could not connect socket when trying to reach " + this.hostname);
                errorMessages.add((CallSite)((Object)("Socket isn't connected to " + this.hostname + ":" + this.port)));
            }
            catch (SocketTimeoutException e) {
                LOG.trace("Socket connection timed out when trying to reach " + this.hostname, (Throwable)e);
                errorMessages.add((CallSite)((Object)("Connection to " + this.hostname + ":" + this.port + " timed out")));
                lastError = e;
            }
            catch (IOException e) {
                LOG.trace("Could not open a socket when trying to reach " + this.hostname, (Throwable)e);
                errorMessages.add((CallSite)((Object)("Could not open a socket to " + this.hostname + ":" + this.port)));
                lastError = e;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, errorMessages.stream().collect(Collectors.joining(", ")), lastError);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPortTest that = (HostAndPortTest)o;
        if (this.port != that.port) {
            return false;
        }
        if (this.category != null ? !Objects.equals(this.category, that.category) : that.category != null) {
            return false;
        }
        if (this.description != null ? !Objects.equals(this.description, that.description) : that.description != null) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        return !(this.proxyInfo != null ? !Objects.equals(this.proxyInfo, that.proxyInfo) : that.proxyInfo != null);
    }

    public int hashCode() {
        int result = this.proxyInfo != null ? this.proxyInfo.hashCode() : 0;
        result = 31 * result + this.hostname.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        return result;
    }

    static {
        Security.setProperty("networkaddress.cache.ttl", "10");
    }

    private static class SSHSocket
    extends Socket {
        public SSHSocket(SshProxySocketImplFactory sshProxySocketImplFactory) throws SocketException {
            super(sshProxySocketImplFactory.createSocketImpl());
        }
    }
}

