/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.PingUtils;

public class Ping6Test
implements ConnectivityTest {
    private static final String DEFAULT_IPV6_ADDRESS = "flsmonitor.fed4fire.eu";
    private final String address;

    public Ping6Test() {
        this(DEFAULT_IPV6_ADDRESS);
    }

    public Ping6Test(String address) {
        this.address = address;
    }

    @Override
    public String getName() {
        return "Ping to IPv6-host '" + this.address + "'";
    }

    @Override
    public boolean isLoginRequired() {
        return false;
    }

    @Override
    public ConnectivityTest.ConnectivityTestResult call() throws Exception {
        if (PingUtils.isReachableByPing6(this.address)) {
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Successfully connected to " + this.address);
        }
        return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Unable to reach " + this.address);
    }
}

