/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.xbill.DNS.Address;

public abstract class ResolveTest
implements ConnectivityTest {
    private final String address;
    private final boolean useAlternativeResolver;
    private final String expectedAddress;
    private final String ipVersion;
    private final Class<? extends InetAddress> inetAddressClass;

    public ResolveTest(String ipVersion, Class<? extends InetAddress> inetAddressClass, String address, boolean useAlternativeResolver) {
        this.ipVersion = ipVersion;
        this.inetAddressClass = inetAddressClass;
        this.address = address;
        this.useAlternativeResolver = useAlternativeResolver;
        this.expectedAddress = null;
    }

    public ResolveTest(String ipVersion, Class<? extends InetAddress> inetAddressClass, String address, boolean useAlternativeResolver, String expectedAddress) {
        this.ipVersion = ipVersion;
        this.inetAddressClass = inetAddressClass;
        this.address = address;
        this.useAlternativeResolver = useAlternativeResolver;
        this.expectedAddress = expectedAddress;
    }

    @Override
    public String getName() {
        return "DNS Resolve IPv" + this.ipVersion + "-host using " + (this.useAlternativeResolver ? "org.xbill.DNS resolver" : "native java resolver") + " '" + this.address + "'" + (String)(this.expectedAddress == null ? "" : " expecting to get address \"" + this.expectedAddress + "\"");
    }

    @Override
    public boolean isLoginRequired() {
        return false;
    }

    private static String otherAddresses(InetAddress excludeInetAddress, InetAddress[] allInetAddresses) {
        Object res = "";
        for (InetAddress inetAddress : allInetAddresses) {
            if (excludeInetAddress != null && Objects.equals(inetAddress.getHostAddress(), excludeInetAddress.getHostAddress())) continue;
            res = ((String)res).isEmpty() ? (String)res + inetAddress.getHostAddress() : (String)res + ", " + inetAddress.getHostAddress();
        }
        return res;
    }

    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        try {
            InetAddress[] inetAddresses = this.useAlternativeResolver ? Address.getAllByName((String)this.address) : InetAddress.getAllByName(this.address);
            for (InetAddress inetAddress : inetAddresses) {
                if (!this.inetAddressClass.isInstance(inetAddress) || this.expectedAddress != null && !inetAddress.getHostAddress().equals(this.expectedAddress)) continue;
                String other = ResolveTest.otherAddresses(inetAddress, inetAddresses);
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Successfully resolved \"" + this.address + "\" to " + inetAddress.getHostAddress() + (String)(other.isEmpty() ? "" : " (additional results: " + other + ")"));
            }
            if (this.expectedAddress == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Successfully resolved \"" + this.address + "\" but found no IPv" + this.ipVersion + " address: " + ResolveTest.otherAddresses(null, inetAddresses));
            }
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Successfully resolved \"" + this.address + "\" but did not find expected IPv" + this.ipVersion + " address \"" + this.expectedAddress + "\": " + ResolveTest.otherAddresses(null, inetAddresses));
        }
        catch (UnknownHostException e) {
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Unable to resolve \"" + this.address + "\"");
        }
    }
}

