/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConnectionTest
implements ConnectivityTest {
    private static final Logger LOG = LoggerFactory.getLogger(URLConnectionTest.class);
    private static final int TIMEOUT = 5000;
    @Nonnull
    private final URL url;
    private final String description;
    private final String category;

    public URLConnectionTest(@Nonnull URL url, String description, String category) {
        this.url = url;
        this.description = description;
        this.category = category;
    }

    @Override
    public String getName() {
        return String.format("[%s] %s", this.category, this.description);
    }

    @Override
    public boolean isLoginRequired() {
        return false;
    }

    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
            conn.setRequestMethod("HEAD");
            if (conn.getResponseMessage() != null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Successfully connected to " + this.url.toExternalForm());
            }
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Could not connect to " + this.url.toExternalForm());
        }
        catch (IOException e) {
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Error while connecting to " + this.url.toExternalForm());
        }
    }
}

