/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.espec.filefetcher.ESpecFileFetchException;
import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.experiment.DefaultWaitForReadyTimeoutHandler;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentChangeListener;
import be.iminds.ilabt.jfed.experiment.ExperimentConnectivityTesterFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerListener;
import be.iminds.ilabt.jfed.experiment.ExperimentLinkTesterFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.WaitForReadyTimeoutHandler;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEvent;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEventHandler;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEventHandlerManager;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEventType;
import be.iminds.ilabt.jfed.experiment.events.ExperimentPartsEvent;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpiration;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpirationBinding;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.highlevel.jobs.AllocateExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobFactory;
import be.iminds.ilabt.jfed.highlevel.jobs.ProvisionExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.TestConnectivityJob;
import be.iminds.ilabt.jfed.highlevel.jobs.WaitForOpStatusExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobReport;
import be.iminds.ilabt.jfed.highlevel.jobs.report.StitchingJobReport;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryListener;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentControllerImpl
implements ExperimentChangeListener,
ExperimentController,
LogEntryListener {
    private static final Logger ORIG_LOG = LoggerFactory.getLogger(ExperimentController.class);
    private final LogEntryGeneratorWrappingLogger LOG = new LogEntryGeneratorWrappingLogger(ORIG_LOG, this);
    @Nonnull
    private final Experiment experiment;
    private final ExperimentEventHandlerManager eventHandlerManager = new ExperimentEventHandlerManager();
    private final JobFactory jobFactory;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final JFedCorePreferences jFedPreferences;
    private final GeniUserProvider geniUserProvider;
    private final SliceRegistryUtil sliceRegistryUtil;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, ThreadFactoryUtil.getFactory((String)"ExperimentController-Scheduled"));
    private static final ExecutorService jobExecutorService = Executors.newCachedThreadPool(ThreadFactoryUtil.getFactory((String)"JobExecutor"));
    private final List<ExperimentControllerListener> listeners = new ArrayList<ExperimentControllerListener>();
    private final ExpirationDetector expirationDetector;
    private ExperimentConnectivityTesterFactory experimentConnectivityTesterFactory = null;
    private ExperimentLinkTesterFactory experimentLinkTesterFactory = null;
    private WaitForReadyTimeoutHandler waitForReadyTimeoutHandler = new DefaultWaitForReadyTimeoutHandler();

    public ExperimentControllerImpl(@Nonnull Experiment experiment, @Nonnull JobFactory jobFactory, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authorityFinder, @Nonnull JFedCorePreferences jFedPreferences, @Nonnull GeniUserProvider geniUserProvider, @Nonnull SliceRegistryUtil sliceRegistryUtil) {
        this.experiment = experiment;
        this.jobFactory = jobFactory;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.jFedPreferences = jFedPreferences;
        this.geniUserProvider = geniUserProvider;
        this.sliceRegistryUtil = sliceRegistryUtil;
        this.expirationDetector = new ExpirationDetector();
        experiment.addExperimentChangeListener(this);
    }

    @Override
    public void start() {
        this.LOG.info("ExperimentController.start() when in state={}", (Object)this.experiment.getExperimentState());
        this.LOG.debug("Bootstrapping experiment controller of '{}' in state {}", (Object)this.experiment.getName(), (Object)this.experiment.getExperimentState());
        this.onExperimentStateChange(this.experiment.getExperimentState());
    }

    @Override
    public void onExperimentStateChange(@Nonnull ExperimentState newExperimentState) {
        this.LOG.debug("onExperimentStateChange({})", (Object)newExperimentState);
        switch (newExperimentState) {
            case PENDING: {
                this.createSlice();
                break;
            }
            case RESTORING: {
                this.restoreSlice();
                break;
            }
            case RENEW_EXISTING: {
                this.renewExistingSlice();
                break;
            }
            case RESTORED: {
                this.handleRestored();
                break;
            }
            case CREATED: {
                assert (this.experiment.getNewRequestRspecSource() != null);
                if (this.experiment.getRequestedStartTime() != null) {
                    if (!this.experiment.isReservationMade()) {
                        this.experiment.setExperimentState(ExperimentState.ALLOCATING);
                        break;
                    }
                    if (this.experiment.getRequestedStartTime().isAfter(Instant.now())) {
                        this.experiment.setExperimentState(ExperimentState.FUTURE_RESERVATION);
                        break;
                    }
                    this.experiment.setExperimentState(ExperimentState.PROVISIONING);
                    break;
                }
                this.experiment.setExperimentState(ExperimentState.ALLOCATING);
                break;
            }
            case ALLOCATING: {
                this.allocateResources();
                break;
            }
            case FUTURE_RESERVATION: {
                this.waitForReservationStart();
                break;
            }
            case PROVISIONING: {
                this.provisionResources();
                break;
            }
            case WAIT_FOR_READY: {
                this.waitForReady();
                break;
            }
            case TESTING_CONNECTIVITY: {
                this.testSliversConnectivity(true);
                break;
            }
            case TESTING_LINKS: {
                this.testLinkConnectivity();
                break;
            }
            case SETUP_SOFTWARE: {
                this.setupSoftware();
                break;
            }
            case READY: {
                break;
            }
            case TIMEOUT_WAITING: {
                this.submitJob(this.jobFactory.createWaitForReadyTimeoutHandlerJob(this.experiment, this.waitForReadyTimeoutHandler));
                break;
            }
            case FAILING: {
                break;
            }
            case FAILED: {
                break;
            }
            case UNKNOWN: {
                break;
            }
            case EXPIRING: {
                this.checkForExpiration();
                break;
            }
            case EXPIRED: 
            case EMPTY: {
                this.deleteRestoreInformation();
            }
        }
    }

    private void deleteRestoreInformation() {
        this.experiment.getExperimentRestoreInformation().delete();
    }

    @Override
    public void onExperimentPartAdded(ExperimentPart experimentPart) {
    }

    private void checkForExpiration() {
        this.requestUpdate();
    }

    private void checkExperimentPartsStates() {
        boolean allPartsDeletedOrExpired = this.experiment.getPartsListCopy().stream().filter(Objects::nonNull).filter(ep -> ep.getState() != null).allMatch(ep -> ep.getState().equals((Object)InternalState.DELETED) || ep.getState().equals((Object)InternalState.UNALLOCATED));
        if (allPartsDeletedOrExpired) {
            if (this.experiment.getSliceOrNull() != null && this.experiment.getSliceOrNull().getExpirationDate() != null && this.experiment.getSliceOrNull().getExpirationDate().isBefore(Instant.now())) {
                this.experiment.setExperimentState(ExperimentState.EXPIRED);
            } else {
                this.experiment.setExperimentState(ExperimentState.EMPTY);
            }
        } else {
            boolean hasAnyFailingSliver;
            boolean bl = hasAnyFailingSliver = this.experiment.getSliceOrNull() != null && this.experiment.getSliceOrNull().getSliversStream().anyMatch(Sliver::hasAnyFailStatus);
            if (hasAnyFailingSliver) {
                this.LOG.debug("Setting experiment to FAILING due to failing sliver(s): {}", (Object)this.experiment.getSliceOrNull().getSliversStream().filter(Sliver::hasAnyFailStatus).map(s -> s.getUrnString() + " with state " + s.getStatusString()).collect(Collectors.toList()));
                this.experiment.setExperimentState(ExperimentState.FAILING);
            } else {
                this.experiment.setExperimentState(ExperimentState.READY);
            }
        }
    }

    public CompletableFuture<TestConnectivityJob.TestConnectivityJobResult> testConnectivity() {
        return this.testSliversConnectivity(false);
    }

    private CompletableFuture<TestConnectivityJob.TestConnectivityJobResult> testSliversConnectivity(boolean autoNextState) {
        if (this.experimentConnectivityTesterFactory != null) {
            return this.submitJob(this.experimentConnectivityTesterFactory.createTestExperimentConnectivityJob(this.experiment)).whenCompleteAsync((success, throwable) -> {
                NextExperimentExpiration nextExperimentExpiration = new NextExperimentExpiration(this.experiment);
                if (nextExperimentExpiration.hasPartExpired()) {
                    this.experiment.setExperimentState(ExperimentState.EXPIRING);
                    return;
                }
                if (autoNextState) {
                    this.experiment.setExperimentState(ExperimentState.TESTING_LINKS);
                }
            }, Platform::runLater);
        }
        this.LOG.info("Skipping testing of experiment, as no ExperimentConnectivityTesterFactory is registered.");
        if (autoNextState) {
            this.experiment.setExperimentState(ExperimentState.TESTING_LINKS);
        }
        return CompletableFuture.completedFuture(TestConnectivityJob.TestConnectivityJobResult.createFalseEmpty());
    }

    private static boolean hasLinks(Experiment experiment) {
        for (ExperimentPart part : experiment.getPartsListCopy()) {
            if (!(part instanceof SfaExperimentPart)) continue;
            for (Sliver sliver : ((SfaExperimentPart)part).getSlivers()) {
                if (sliver.getLinks() == null || sliver.getLinks().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void testLinkConnectivity() {
        if (!this.experiment.isLinkTestRequested()) {
            this.LOG.info("Skipping Link Test: Not requested.");
            this.deriveAndSetExperimentStateAfterTestingLinks();
        } else if (!ExperimentControllerImpl.hasLinks(this.experiment)) {
            this.LOG.info("Skipping Link Test: No links.");
            this.deriveAndSetExperimentStateAfterTestingLinks();
        } else if (this.experimentLinkTesterFactory == null) {
            this.LOG.info("Skipping link testing of experiment, as no ExperimentLinkTesterFactory is registered.");
            this.deriveAndSetExperimentStateAfterTestingLinks();
        } else {
            this.submitJob(this.experimentLinkTesterFactory.createTestLinkJob(this.experiment)).whenCompleteAsync((aBoolean, throwable) -> this.deriveAndSetExperimentStateAfterTestingLinks(), Platform::runLater);
        }
    }

    private void deriveAndSetExperimentStateAfterTestingLinks() {
        assert (this.experiment.getExperimentState() == ExperimentState.TESTING_LINKS) : "experiment.getExperimentState() is not TESTING_LINKS but " + this.experiment.getExperimentState();
        NextExperimentExpiration nextExperimentExpiration = new NextExperimentExpiration(this.experiment);
        if (nextExperimentExpiration.hasPartExpired()) {
            this.experiment.setExperimentState(ExperimentState.EXPIRING);
            return;
        }
        boolean allReady = true;
        boolean allEmpty = true;
        for (ExperimentPart part : this.experiment.getPartsListCopy()) {
            this.LOG.debug("ExperimentController deriveAndSetExperimentStateAfterTesting part.getState()=" + part.getState());
            allReady = allReady && part.getState() == InternalState.READY;
            allEmpty = allEmpty && part.getState() == InternalState.UNALLOCATED;
        }
        this.LOG.debug("ExperimentController deriveAndSetExperimentStateAfterTesting allReady=" + allReady + " allEmpty=" + allEmpty);
        if (allReady) {
            if (this.experiment.getNewRequestRspecSource() != null) {
                this.experiment.setExperimentState(ExperimentState.SETUP_SOFTWARE);
            } else {
                this.experiment.setExperimentState(ExperimentState.READY);
            }
        } else if (allEmpty) {
            this.experiment.setExperimentState(ExperimentState.EMPTY);
        } else {
            this.LOG.warn("Could not determine a valid experiment state for {}. Defaulting to allReady", (Object)this.experiment.getName());
            if (this.experiment.getNewRequestRspecSource() != null) {
                this.experiment.setExperimentState(ExperimentState.SETUP_SOFTWARE);
            } else {
                this.experiment.setExperimentState(ExperimentState.READY);
            }
        }
        this.LOG.debug("ExperimentController deriveAndSetExperimentStateAfterTesting post state = " + this.experiment.getExperimentState());
    }

    @Override
    @Nullable
    public CompletableFuture<Void> createSlice() {
        assert (this.experiment.getRequestedEndTime() != null);
        if (this.experiment.getContainsExperimentSpecification()) {
            assert (this.experiment.getExperimentSpecificationFileManager() != null);
            try {
                this.LOG.debug("Fetching all ESpec files before experiment start");
                this.experiment.getExperimentSpecificationFileManager().fetchAll();
                try {
                    this.LOG.debug("... waiting for all files to be fetched");
                    this.experiment.getExperimentSpecificationFileManager().waitUntilReady();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Something went wrong trying to fetch the ESpec files.", e);
            }
            if (this.experiment.getExperimentSpecificationFileManager().getErrorOccured()) {
                this.experiment.setExperimentState(ExperimentState.FAILED);
                this.LOG.warn("Something went wrong trying to fetch the ESpec files. Aborting slice creation.");
                throw new ESpecFileFetchException("Something went wrong trying to fetch the ESpec files. Aborting slice creation.");
            }
            this.LOG.debug("Fetched all ESpec files successfully.");
        }
        this.LOG.info("ExperimentController.createSlice()");
        return this.submitJob(this.jobFactory.createRegisterExperimentJob(this.experiment));
    }

    private void restoreSlice() {
        this.submitJob(this.jobFactory.createRestoreExperimentJob(this.experiment));
    }

    private void renewExistingSlice() {
        if (this.experiment.getRequestedEndTime() == null) {
            this.experiment.setExperimentState(ExperimentState.CREATED);
            return;
        }
        NextExperimentExpiration nextExperimentExpiration = new NextExperimentExpiration(this.experiment);
        if (nextExperimentExpiration.getFirstExpirationTime() == null || nextExperimentExpiration.getFirstExpirationTime().isBefore(this.experiment.getRequestedEndTime())) {
            this.submitJob(this.jobFactory.createRenewSliceJob(this.experiment, this.experiment.getRequestedEndTime())).whenCompleteAsync((renewStatus, throwable) -> {
                if (throwable == null) {
                    if (renewStatus == ExperimentTaskStatus.SUCCESS) {
                        this.experiment.setExperimentState(ExperimentState.CREATED);
                    } else {
                        this.LOG.debug("Renew Slice for {} job success but renew failed: returned renewStatus={}", (Object)this.experiment.getName(), renewStatus);
                        this.experiment.setExperimentState(ExperimentState.FAILING);
                    }
                } else {
                    this.LOG.error("Renew Slice for " + this.experiment.getName() + " failed", (Throwable)throwable);
                    this.experiment.setExperimentState(ExperimentState.FAILING);
                }
            }, Platform::runLater);
        } else {
            this.experiment.setExperimentState(ExperimentState.CREATED);
        }
    }

    private void handleRestored() {
        if (this.experiment.getRequestedStartTime() != null && this.experiment.getRequestedStartTime().isAfter(Instant.now())) {
            this.experiment.setExperimentState(ExperimentState.FUTURE_RESERVATION);
        } else {
            boolean hasFailure = this.experiment.getPartsStream().anyMatch(part -> part.getState() == InternalState.FAILED);
            boolean hasChanging = this.experiment.getPartsStream().filter(Objects::nonNull).map(ExperimentPart::getState).filter(Objects::nonNull).anyMatch(partState -> {
                switch (partState) {
                    case CHANGING: 
                    case ALLOCATING: 
                    case PROVISIONING: 
                    case DELETING: 
                    case RESERVING: 
                    case UNKNOWN: 
                    case WAIT_FOR_READY: {
                        return true;
                    }
                }
                return false;
            });
            this.LOG.debug("handleRestored hasFailure=" + hasFailure + " hasChanging=" + (hasChanging |= this.experiment.getPartsStream().filter(Objects::nonNull).filter(ep -> ep instanceof SfaExperimentPart).map(ep -> ((SfaExperimentPart)ep).getStatusDetails().getGlobalStatus()).filter(Objects::nonNull).anyMatch(sliverStatus -> {
                switch (sliverStatus) {
                    case CHANGING: {
                        return true;
                    }
                }
                return false;
            })) + " getPartsSize=" + this.experiment.getPartsSize());
            if (hasFailure) {
                this.experiment.setExperimentState(ExperimentState.FAILED);
                return;
            }
            if (hasChanging) {
                this.experiment.setExperimentState(ExperimentState.WAIT_FOR_READY);
                return;
            }
            this.experiment.setExperimentState(ExperimentState.TESTING_CONNECTIVITY);
        }
    }

    private void allocateResources() {
        if (this.experiment.getSliceOrNull() != null) {
            String requestRspecXmlString;
            RequestRspecSource requestRspecSource = this.experiment.getNewRequestRspecSource();
            this.experiment.getSlice().setRequestRspec(requestRspecSource);
            if (this.sliceRegistryUtil != null && requestRspecSource != null && (requestRspecXmlString = requestRspecSource.getRspecXmlString()) != null) {
                this.sliceRegistryUtil.registerSliceAtSA(AbstractFederationApi.SliceRspecType.REQUEST, this.experiment.getSlice(), null, requestRspecXmlString, Instant.now(), null, new ResultListener[0]);
            }
        }
        if (this.experiment.getExperimentSpecification() != null) {
            this.experiment.getExperimentSpecificationLogger().firePreRSpec();
            if (this.experiment.getExperimentSpecification().getRspecs() != null && !this.experiment.getExperimentSpecification().getRspecs().isEmpty()) {
                assert (this.experiment.getNewRequestRspecSource() != null);
                assert (this.experiment.getExistingRequestRspecSource() == null);
                if (this.experiment.getNewRequestRspecSource() != null && this.experiment.getNewRequestRspecSource().getRspecXmlString() != null) {
                    this.experiment.getExperimentSpecificationLogger().fireRequestRSpecKnown((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), this.experiment.getNewRequestRspecSource().getRspecXmlString());
                }
            }
        }
        Server scs = this.getScsAuthority();
        Boolean isStitching = this.experiment.getNewRequestRspecSource() != null && this.experiment.getNewRequestRspecSource().getStringRspec() != null && Objects.equals(this.experiment.getNewRequestRspecSource().getStringRspec().isStitching(this.testbedInfoSource, this.authorityFinder), Boolean.TRUE);
        if (scs == null && isStitching.booleanValue()) {
            this.LOG.error("Stitching needed for this experiment, but SCS cannot be found.");
            this.experiment.setExperimentState(ExperimentState.FAILING);
            return;
        }
        AllocateExperimentJob allocateExperimentJob = this.jobFactory.createAllocateExperimentJob(this.experiment, scs);
        StitchingJobReport stitchingJobReport = allocateExperimentJob.getStitchingJobReport();
        this.experiment.addJobReport(stitchingJobReport);
        this.submitJob(allocateExperimentJob).whenCompleteAsync((success, throwable) -> {
            if (throwable != null) {
                this.LOG.error("AllocateExperimentJob for " + this.experiment.getName() + " failed: ", (Throwable)throwable);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            } else if (Objects.equals(success, Boolean.TRUE)) {
                if (this.experiment.getRequestedStartTime() == null || this.experiment.getRequestedStartTime().isBefore(Instant.now())) {
                    this.experiment.setExperimentState(ExperimentState.PROVISIONING);
                } else {
                    this.experiment.setExperimentState(ExperimentState.FUTURE_RESERVATION);
                }
            } else {
                this.LOG.debug("AllocateExperimentJob for {} succeeded but returned success={}", (Object)this.experiment.getName(), success);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            }
        }, Platform::runLater);
    }

    private void waitForReservationStart() {
        assert (this.experiment.getRequestedStartTime() != null);
        Duration durationToStartTime = Duration.between(Instant.now(), this.experiment.getRequestedStartTime());
        Runnable startProvisioning = () -> this.experiment.setExperimentState(ExperimentState.PROVISIONING);
        if (!durationToStartTime.isNegative()) {
            this.scheduledExecutorService.schedule(startProvisioning, durationToStartTime.getSeconds() + 1L, TimeUnit.SECONDS);
        } else {
            startProvisioning.run();
        }
    }

    @Override
    public CompletableFuture<Void> requestUpdate() {
        return this.submitJob(this.jobFactory.createUpdateExperimentJob(this.getExperiment())).whenComplete((v, throwable) -> Platform.runLater(() -> {
            if (throwable != null) {
                this.LOG.warn("Update experiment failed: {}. Checking for experiment part states anyway.", (Object)throwable.getMessage(), throwable);
            }
            this.checkExperimentPartsStates();
        }));
    }

    @Override
    public void shareWithUsers(@Nonnull List<GeniUrn> selectedUsers, boolean registerSshKeys) {
        this.submitJob(this.jobFactory.createShareSliceJob(this.experiment, selectedUsers, registerSshKeys));
    }

    @Override
    public void unshareWithUsers(@Nonnull List<GeniUrn> selectedUsers, boolean unregisterSshKeys) {
        this.submitJob(this.jobFactory.createUnshareSliceJob(this.experiment, selectedUsers, unregisterSshKeys));
    }

    @Override
    public void updateSshKeys(@Nonnull List<UserSpec> userspec) {
        this.submitJob(this.jobFactory.createEditSshKeysJob(this.experiment, userspec));
    }

    @Override
    public void reloadOS(Sliver sliver) {
        this.submitJob(this.jobFactory.createReloadOSJob(this.experiment, sliver));
    }

    @Override
    public void createDiskImage(FXRspecNode node, String imageName, boolean global, boolean updatePrepare) {
        this.submitJob(this.jobFactory.createCreateDiskImageJob(this.experiment, node, imageName, global, updatePrepare));
    }

    @Override
    public void stop(Collection<ExperimentPart> experimentParts) {
        this.LOG.info("ExperimentController is stopping experiment");
        this.submitJob(this.jobFactory.createStopExperimentJob(this.experiment, experimentParts)).whenCompleteAsync((aVoid, throwable) -> {
            if (throwable != null) {
                this.LOG.warn("Stopping experiment failed: {}. Checking experiment part states anyway.", (Object)throwable.getMessage(), throwable);
            }
            this.checkExperimentPartsStates();
        }, Platform::runLater);
        this.eventHandlerManager.dispatch(new ExperimentPartsEvent(this, ExperimentPartsEvent.STOPPED, experimentParts));
    }

    @Override
    public void stop() {
        this.stop(this.experiment.getPartsListCopy());
    }

    @Override
    public CompletableFuture<Boolean> testLinks() {
        assert (this.experimentLinkTesterFactory != null);
        return this.submitJob(this.experimentLinkTesterFactory.createTestLinkJob(this.experiment)).whenComplete((success, throwable) -> {
            if (throwable == null) {
                this.LOG.debug("Link Test Job got result: " + success);
            } else {
                this.LOG.warn("Link Test Job Failed.", (Object)throwable.getMessage(), throwable);
            }
        });
    }

    @Override
    public void reboot(Sliver sliver) {
        this.submitJob(this.jobFactory.createRebootJob(this.experiment, sliver));
    }

    @Override
    public void reboot(ExperimentPart experimentPart) {
        assert (this.experiment.getPartsListCopy().contains(experimentPart));
        this.submitJob(this.jobFactory.createRebootJob(experimentPart));
    }

    @Override
    public void openConsole(Sliver sliver) {
        this.submitJob(this.jobFactory.createOpenConsoleJob(this.experiment, sliver));
    }

    @Override
    public void shareLan(FXRspecLink link, String sharedLanName) {
        this.submitJob(this.jobFactory.createShareLanJob(this.experiment, link, sharedLanName));
    }

    @Override
    public void unshareLan(FXRspecLink link, String sharedLanName) {
        this.submitJob(this.jobFactory.createUnshareLanJob(this.experiment, link, sharedLanName));
    }

    @Override
    public CompletableFuture<Collection<UserSpec>> fetchSliceMemberSshKeys() {
        return this.submitJob(this.jobFactory.createFetchSliceMemberSshKeysJob(this.experiment));
    }

    @Override
    public CompletableFuture<ExperimentTaskStatus> renew(Instant newExpirationTime) {
        return this.submitJob(this.jobFactory.createRenewExperimentJob(this.experiment, newExpirationTime));
    }

    @Override
    public void renewParts(Instant newExpirationTime, Collection<ExperimentPart> parts) {
        this.submitJob(this.jobFactory.createRenewExperimentJob(this.experiment, newExpirationTime, parts));
    }

    @Override
    public void log(@Nonnull LogOutput.LogEntry logEntry) {
        this.experiment.log(logEntry);
    }

    private void provisionResources() {
        assert (this.experiment.getNewRequestRspecSource() != null);
        assert (this.experiment.getSliceOrNull() != null);
        if (this.experiment.getSliceOrNull() != null) {
            this.experiment.getSliceOrNull().setRequestRspec(this.experiment.getNewRequestRspecSource());
        }
        ProvisionExperimentJob job = this.jobFactory.createProvisionExperimentJob(this.experiment);
        JobReport jobReport = job.getJobReport();
        this.experiment.addJobReport(jobReport);
        this.submitJob(job).whenCompleteAsync((success, throwable) -> {
            if (throwable != null) {
                this.LOG.error("ProvisionExperimentJob for " + this.experiment.getName() + " failed: ", (Throwable)throwable);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            } else if (Objects.equals(success, Boolean.TRUE)) {
                this.experiment.setExperimentState(ExperimentState.WAIT_FOR_READY);
            } else {
                this.LOG.debug("ProvisionExperimentJob for {} succeeded but returned success={}", (Object)this.experiment.getName(), success);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            }
        }, Platform::runLater);
    }

    @Override
    public void waitForReady() {
        this.LOG.debug("experimentController.waitForReady()");
        WaitForOpStatusExperimentJob job = this.jobFactory.createWaitForReadyExperimentJob(this.experiment);
        JobReport jobReport = job.getJobReport();
        this.experiment.addJobReport(jobReport);
        this.submitJob(job).whenCompleteAsync((success, throwable) -> {
            if (throwable != null) {
                this.LOG.error("WaitForOpStatusExperimentJob for " + this.experiment.getName() + " failed: ", (Throwable)throwable);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            } else if (Objects.equals(success, Boolean.TRUE)) {
                String manifestRspecXmlString;
                this.experiment.setExperimentState(ExperimentState.TESTING_CONNECTIVITY);
                ManifestRspecSource manifestRspecSource = this.experiment.getSlice().getManifestRspec();
                if (this.sliceRegistryUtil != null && manifestRspecSource != null && (manifestRspecXmlString = manifestRspecSource.getRspecXmlString()) != null) {
                    this.sliceRegistryUtil.registerSliceAtSA(AbstractFederationApi.SliceRspecType.COMBINED_MANIFEST, this.experiment.getSlice(), null, manifestRspecXmlString, Instant.now(), null, new ResultListener[0]);
                }
            } else if (Objects.equals(job.isTimeout(), Boolean.TRUE)) {
                this.LOG.debug("WaitForOpStatusExperimentJob for {} succeeded but there was a timeout", (Object)this.experiment.getName(), success);
                this.experiment.setExperimentState(ExperimentState.TIMEOUT_WAITING);
            } else {
                this.LOG.debug("WaitForOpStatusExperimentJob for {} succeeded but returned success={}", (Object)this.experiment.getName(), success);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            }
        }, Platform::runLater);
    }

    @Override
    public void setupSoftware() {
        SetupSoftwareExperimentJob job = this.jobFactory.createSetupSoftwareExperimentJob(this.experiment);
        JobReport jobReport = job.getJobReport();
        this.experiment.addJobReport(jobReport);
        this.submitJob(job).whenCompleteAsync((success, throwable) -> {
            if (throwable != null) {
                this.LOG.error("SetupSoftwareExperimentJob for " + this.experiment.getName() + " failed: ", (Throwable)throwable);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            } else if (Objects.equals(success, Boolean.TRUE)) {
                this.experiment.setExperimentState(ExperimentState.READY);
            } else {
                this.LOG.debug("SetupSoftwareExperimentJob for {} succeeded but returned success={}", (Object)this.experiment.getName(), success);
                this.experiment.setExperimentState(ExperimentState.FAILING);
            }
        }, Platform::runLater);
    }

    @Override
    public CompletableFuture<Boolean> rerunESpec(@Nullable ESpecStep startPosition, @Nullable ESpecStep stopPosition) {
        this.LOG.debug("do rerunESpec start=" + startPosition + " stop=" + stopPosition);
        return this.submitJob(this.jobFactory.createRerunEspecJob(this.experiment, startPosition, stopPosition)).whenComplete((success, throwable) -> {
            if (throwable != null) {
                this.LOG.error("Rerun ESpec SetupSoftwareExperimentJob for " + this.experiment.getName() + " failed: ", (Throwable)throwable);
            } else if (Objects.equals(success, Boolean.TRUE)) {
                this.LOG.debug("Rerun ESpec SetupSoftwareExperimentJob for {} succeeded successfully", (Object)this.experiment.getName());
            } else {
                this.LOG.debug("Rerun ESpec SetupSoftwareExperimentJob for {} succeeded but returned success={}", (Object)this.experiment.getName(), success);
            }
        });
    }

    @Nullable
    private Server getScsAuthority() {
        if (this.experiment.getScs() != null && this.experiment.getScs().getServer() != null) {
            return this.experiment.getScs().getServer();
        }
        Server scsServer = this.jFedPreferences.getScsAuthority(this.testbedInfoSource);
        if (scsServer == null) {
            Integer scsId;
            Integer n = scsId = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer() != null ? this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer().getDefaultScsId() : null;
            if (scsId != null) {
                Service scsService = this.testbedInfoSource.getServiceById(scsId);
                assert (scsService != null) : "Could not find scs " + scsId;
                if (scsService != null) {
                    scsServer = scsService.getServer();
                    assert (scsServer != null);
                }
            }
        }
        return scsServer;
    }

    private <V> CompletableFuture<V> submitJob(Job<V> job) {
        this.listeners.forEach(listener -> listener.onJobSubmitted(job));
        job.stateProperty().addListener(observable -> this.listeners.forEach(listener -> listener.onJobStateChanged(job, job.getState())));
        CompletableFuture completableFuture = new CompletableFuture();
        jobExecutorService.submit(() -> {
            try {
                completableFuture.complete(job.call());
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture.whenComplete((v, throwable) -> this.listeners.forEach(listener -> listener.onJobFinished(job)));
    }

    @Override
    @Nonnull
    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    public void addListener(ExperimentControllerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExperimentControllerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public ExperimentConnectivityTesterFactory getExperimentConnectivityTesterFactory() {
        return this.experimentConnectivityTesterFactory;
    }

    @Override
    public void setExperimentConnectivityTesterFactory(ExperimentConnectivityTesterFactory experimentConnectivityTesterFactory) {
        this.experimentConnectivityTesterFactory = experimentConnectivityTesterFactory;
    }

    @Override
    public void setExperimentLinkTesterFactory(ExperimentLinkTesterFactory experimentLinkTesterFactory) {
        this.experimentLinkTesterFactory = experimentLinkTesterFactory;
    }

    @Override
    public WaitForReadyTimeoutHandler getWaitForReadyTimeoutHandler() {
        return this.waitForReadyTimeoutHandler;
    }

    @Override
    public void setWaitForReadyTimeoutHandler(WaitForReadyTimeoutHandler waitForReadyTimeoutHandler) {
        this.waitForReadyTimeoutHandler = waitForReadyTimeoutHandler;
    }

    @Override
    public <T extends ExperimentEvent> void addEventHandler(ExperimentEventType<T> type, ExperimentEventHandler<T> eventHandler) {
        this.eventHandlerManager.addExperimentEventHandler(type, eventHandler);
    }

    private class ExpirationDetector
    implements Runnable {
        private final NextExperimentExpirationBinding nextExperimentExpirationBinding;
        private ScheduledFuture<?> previousScheduledExpiration = null;

        public ExpirationDetector() {
            this.nextExperimentExpirationBinding = new NextExperimentExpirationBinding(ExperimentControllerImpl.this.experiment);
            this.nextExperimentExpirationBinding.addListener(observable -> this.scheduleForNextExpiration());
        }

        @Override
        public void run() {
            NextExperimentExpiration nextExpiration = (NextExperimentExpiration)this.nextExperimentExpirationBinding.get();
            if (nextExpiration.hasPartExpired()) {
                ExperimentControllerImpl.this.LOG.trace("A part of the experiment {} has expired!", (Object)ExperimentControllerImpl.this.experiment.getName());
                ExperimentControllerImpl.this.experiment.setExperimentState(ExperimentState.EXPIRING);
            } else {
                this.scheduleForNextExpiration();
            }
        }

        private void scheduleForNextExpiration() {
            NextExperimentExpiration nextExpiration;
            if (this.previousScheduledExpiration != null) {
                this.previousScheduledExpiration.cancel(false);
            }
            if ((nextExpiration = (NextExperimentExpiration)this.nextExperimentExpirationBinding.get()).getFirstExpirationTime() != null) {
                Duration durationToFirstExpiration = Duration.between(Instant.now(), nextExpiration.getFirstExpirationTime());
                if (!durationToFirstExpiration.isNegative()) {
                    ExperimentControllerImpl.this.LOG.debug("Scheduling next expiration check for {} in {} seconds", (Object)ExperimentControllerImpl.this.experiment.getName(), (Object)(durationToFirstExpiration.getSeconds() + 1L));
                    this.previousScheduledExpiration = ExperimentControllerImpl.this.scheduledExecutorService.schedule(this, durationToFirstExpiration.getSeconds() + 1L, TimeUnit.SECONDS);
                } else {
                    ExperimentControllerImpl.this.LOG.warn("NOT Scheduling next expiration check for {}: experiment expired {} seconds ago", (Object)ExperimentControllerImpl.this.experiment.getName(), (Object)durationToFirstExpiration.getSeconds());
                }
            } else if (!nextExpiration.hasPartExpired()) {
                ExperimentControllerImpl.this.LOG.debug("Could not find an expiration time. Trying again in 10 seconds");
                this.previousScheduledExpiration = ExperimentControllerImpl.this.scheduledExecutorService.schedule(this, 10L, TimeUnit.SECONDS);
            }
        }
    }
}

