/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.events;

import be.iminds.ilabt.jfed.experiment.events.ExperimentEvent;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEventHandler;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEventType;
import java.util.LinkedList;
import java.util.List;

public class ExperimentEventHandlerManager {
    private final List<ExperimentEventHandlerRecord<? extends ExperimentEvent>> experimentEventHandlerRecords = new LinkedList<ExperimentEventHandlerRecord<? extends ExperimentEvent>>();

    public <T extends ExperimentEvent> void addExperimentEventHandler(ExperimentEventType<T> eventType, ExperimentEventHandler<T> experimentEventHandler) {
        this.experimentEventHandlerRecords.add(new ExperimentEventHandlerRecord<T>(eventType, experimentEventHandler));
    }

    public void dispatch(ExperimentEvent experimentEvent) {
        for (ExperimentEventHandlerRecord<? extends ExperimentEvent> experimentEventHandlerRecord : this.experimentEventHandlerRecords) {
            if (!ExperimentEventHandlerManager.isTypeOrSuperTypeOf(experimentEvent.getType(), experimentEventHandlerRecord.getEventType())) continue;
            experimentEventHandlerRecord.getExperimentEventHandler().handle(experimentEvent);
        }
    }

    private static boolean isTypeOrSuperTypeOf(ExperimentEventType experimentEventType, ExperimentEventType handlerEventType) {
        do {
            if (experimentEventType != handlerEventType) continue;
            return true;
        } while ((experimentEventType = experimentEventType.getSuperType()) != null);
        return false;
    }

    private static final class ExperimentEventHandlerRecord<T extends ExperimentEvent> {
        private final ExperimentEventType<T> eventType;
        private final ExperimentEventHandler<T> experimentEventHandler;

        public ExperimentEventHandlerRecord(ExperimentEventType<T> eventType, ExperimentEventHandler<T> experimentEventHandler) {
            this.eventType = eventType;
            this.experimentEventHandler = experimentEventHandler;
        }

        public ExperimentEventType<T> getEventType() {
            return this.eventType;
        }

        public ExperimentEventHandler getExperimentEventHandler() {
            return this.experimentEventHandler;
        }
    }
}

