/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup;

import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Provision;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.experiment.setup.config.WaitForReady;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentSetupConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentSetupConfig.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    @Nonnull
    protected final Slice slice;
    @Nullable
    protected final RequestRSpec requestRSpec;
    @Nullable
    protected final ESpec eSpec;
    @Nonnull
    protected final Provision provision;
    @Nonnull
    protected final WaitForReady waitForReady;
    protected final boolean overrideESpecRSpec;
    protected final boolean runLinkTest;

    public ExperimentSetupConfig() {
        this.slice = new Slice();
        this.requestRSpec = RequestRSpec.getDefault();
        this.eSpec = null;
        this.provision = new Provision();
        this.waitForReady = new WaitForReady();
        this.overrideESpecRSpec = false;
        this.runLinkTest = false;
    }

    @JsonCreator
    public ExperimentSetupConfig(@Nullable @JsonProperty(value="slice") Slice slice, @Nullable @JsonProperty(value="requestRSpec") RequestRSpec requestRSpec, @Nullable @JsonProperty(value="eSpec") ESpec eSpec, @Nullable @JsonProperty(value="provision") Provision provision, @Nullable @JsonProperty(value="waitForReady") WaitForReady waitForReady, @Nullable @JsonProperty(value="overrideESpecRSpec") Boolean overrideESpecRSpec, @Nullable @JsonProperty(value="runLinkTest") Boolean runLinkTest) {
        Slice slice2 = this.slice = slice == null ? new ExperimentSetupConfig().getSlice() : slice;
        this.requestRSpec = requestRSpec == null ? (eSpec == null ? new ExperimentSetupConfig().getRequestRSpec() : null) : requestRSpec;
        this.eSpec = eSpec == null ? null : eSpec;
        this.provision = provision == null ? new ExperimentSetupConfig().getProvision() : provision;
        this.waitForReady = waitForReady == null ? new ExperimentSetupConfig().getWaitForReady() : waitForReady;
        this.overrideESpecRSpec = overrideESpecRSpec == null ? new ExperimentSetupConfig().getOverrideESpecRSpec() : overrideESpecRSpec.booleanValue();
        this.runLinkTest = runLinkTest == null ? new ExperimentSetupConfig().getRunLinkTest() : runLinkTest.booleanValue();
    }

    @JsonIgnore
    public boolean isValid() {
        boolean res = this.getSlice().isValid();
        RequestRSpec requestRspec = this.getRequestRSpec();
        ESpec espec = this.getESpec();
        res = res && (requestRspec == null || requestRspec.isValid());
        res = res && (espec == null || espec.isValid());
        res = res && (espec != null || requestRspec != null);
        res = res && this.getProvision().isValid();
        boolean bl = res = res && this.getWaitForReady().isValid();
        if (!this.getProvision().isEnabled() && !this.getWaitForReady().isEnabled()) {
            throw new IllegalArgumentException("Config Error: if the Provision step is disabled, waitForReady should be disabled too.");
        }
        if (this.getOverrideESpecRSpec()) {
            if (espec == null || requestRspec == null) {
                throw new IllegalArgumentException("Config Error: overrideESpecRSpec=true requires specifying both an RSpec and an ESpec");
            }
        } else if (espec != null && requestRspec != null) {
            throw new IllegalArgumentException("Config Error: Specifying both an RSpec and an ESpec requires overrideESpecRSpec=true");
        }
        return res;
    }

    @JsonProperty
    @Nonnull
    public Slice getSlice() {
        return this.slice;
    }

    @JsonProperty
    @Nullable
    public RequestRSpec getRequestRSpec() {
        return this.requestRSpec;
    }

    @JsonProperty(value="eSpec")
    @Nullable
    public ESpec getESpec() {
        return this.eSpec;
    }

    @JsonProperty
    @Nonnull
    public Provision getProvision() {
        return this.provision;
    }

    @JsonProperty
    @Nonnull
    public WaitForReady getWaitForReady() {
        return this.waitForReady;
    }

    @JsonProperty(value="overrideESpecRSpec")
    public boolean getOverrideESpecRSpec() {
        return this.overrideESpecRSpec;
    }

    @JsonProperty(value="runLinkTest")
    public boolean getRunLinkTest() {
        return this.runLinkTest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExperimentSetupConfig)) {
            return false;
        }
        ExperimentSetupConfig that = (ExperimentSetupConfig)o;
        return this.overrideESpecRSpec == that.overrideESpecRSpec && this.runLinkTest == that.runLinkTest && Objects.equals(this.slice, that.slice) && Objects.equals(this.requestRSpec, that.requestRSpec) && Objects.equals(this.eSpec, that.eSpec) && Objects.equals(this.provision, that.provision) && Objects.equals(this.waitForReady, that.waitForReady);
    }

    public int hashCode() {
        return Objects.hash(this.slice, this.requestRSpec, this.eSpec, this.provision, this.waitForReady, this.overrideESpecRSpec, this.runLinkTest);
    }
}

