/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup;

import be.iminds.ilabt.jfed.espec.bundle.BundleFetcher;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.bundle.ModifiedESpecBundle;
import be.iminds.ilabt.jfed.espec.filefetcher.FileFetcher;
import be.iminds.ilabt.jfed.espec.model.BasicExperimentSpecificationBuilder;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.parser.ExperimentSpecificationParser;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupConfig;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupContext;
import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupLogger;
import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateSimpleRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateUsingAdvertisementRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateUsingJFedRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedFileRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.git.SingleSshGitAuthPreferences;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec.adv_based_generator.AdvertisementBasedRspecGenerator;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGenerator;
import be.iminds.ilabt.jfed.rspec.generator.RSpecGeneratorFactory;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.RspecBinder;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public class ExperimentSetupHelper {
    @Nonnull
    private final String uniqueId;
    @Nonnull
    private final ExperimentSetupLogger logger;
    @Nonnull
    private final ExperimentSetupConfig config;
    @Nonnull
    private final ExperimentSetupContext context;
    @Nonnull
    private final Supplier<RSpecGeneratorFactory> rSpecGeneratorFactoryProvider;
    @Nonnull
    private final RspecFactory rspecFactory;
    @Nullable
    private final AdvertisementRspecSource advertisementRspecSource;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final GeniUser user;
    @Nonnull
    private final AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory auasawf;
    @Nonnull
    private final Logger callLogger;
    @Nullable
    private final Service scs;
    private boolean notEnoughFreeResourcesDetected;
    private UserAndSliceApiWrapper userAndSliceApiWrapper;

    public ExperimentSetupHelper(@Nullable String uniqueId, @Nonnull ExperimentSetupLogger logger, @Nonnull ExperimentSetupConfig config, @Nullable ExperimentSetupContext context, @Nonnull Supplier<RSpecGeneratorFactory> rSpecGeneratorFactoryProvider, @Nonnull RspecFactory rspecFactory, @Nullable AdvertisementRspecSource advertisementRspecSource, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authorityFinder, @Nonnull GeniUser user, AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory auasawf, @Nonnull SfaModel sfaModel, @Nonnull Logger callLogger) {
        this.uniqueId = uniqueId == null ? "" : uniqueId;
        this.logger = logger;
        this.config = config;
        this.context = context == null ? new ExperimentSetupContext() : context;
        this.rSpecGeneratorFactoryProvider = rSpecGeneratorFactoryProvider;
        this.rspecFactory = rspecFactory;
        this.advertisementRspecSource = advertisementRspecSource;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.sfaModel = sfaModel;
        this.user = user;
        this.auasawf = auasawf;
        this.callLogger = callLogger;
        this.notEnoughFreeResourcesDetected = false;
        this.scs = ExperimentSetupHelper.findScsFromString(config.getProvision().getScs(), testbedInfoSource);
    }

    public ExperimentSetupHelper(@Nullable String uniqueId, @Nonnull ExperimentSetupLogger logger, @Nonnull ExperimentSetupConfig config, @Nullable ExperimentSetupContext context, @Nonnull Supplier<RSpecGeneratorFactory> rSpecGeneratorFactoryProvider, @Nullable AdvertisementRspecSource advertisementRspecSource, @Nonnull Injector injector) {
        this.uniqueId = uniqueId == null ? "" : uniqueId;
        this.logger = logger;
        this.config = config;
        this.context = context == null ? new ExperimentSetupContext() : context;
        this.rSpecGeneratorFactoryProvider = rSpecGeneratorFactoryProvider;
        this.advertisementRspecSource = advertisementRspecSource;
        this.rspecFactory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.BASIC);
        this.testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
        this.authorityFinder = (AuthorityFinder)injector.getInstance(AuthorityFinder.class);
        this.sfaModel = (SfaModel)injector.getInstance(SfaModel.class);
        this.user = (GeniUser)injector.getInstance(GeniUser.class);
        this.auasawf = (AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory)injector.getInstance(AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory.class);
        this.callLogger = (Logger)injector.getInstance(Logger.class);
        this.notEnoughFreeResourcesDetected = false;
        this.scs = ExperimentSetupHelper.findScsFromString(config.getProvision().getScs(), this.testbedInfoSource);
    }

    @Nullable
    @Contract(value="null,_ -> null")
    public static Service findScsFromString(@Nullable String scsSource, @Nonnull TestbedInfoSource testbedInfoSource) {
        if (scsSource == null || scsSource.trim().isEmpty()) {
            return null;
        }
        if ((scsSource = scsSource.trim()).startsWith("urn:publicid:IDN+")) {
            GeniUrn scsUrn = GeniUrn.parse((String)scsSource);
            return testbedInfoSource.getServiceByUrn(scsUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY, false, "Geni.SCS", "1");
        }
        try {
            int id = Integer.parseInt(scsSource);
            return testbedInfoSource.getServiceById(Integer.valueOf(id));
        }
        catch (NumberFormatException id) {
            try {
                URL scsUrl = new URL(scsSource);
                Service res = testbedInfoSource.getServiceByUrl(scsUrl);
                if (res != null) {
                    return res;
                }
                Server server = JFedCorePreferences.createFakeScsServer((URL)scsUrl, null);
                return (Service)server.getServices().get(0);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to process SCS from string \"" + scsSource + "\"");
            }
        }
    }

    @Nonnull
    public ExperimentSetupLogger getLogger() {
        return this.logger;
    }

    @Nonnull
    public ExperimentSetupConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public ExperimentSetupContext getContext() {
        return this.context;
    }

    public void getRspec(@Nullable String generateAndBindTargetCmUrn) throws GeniUrn.GeniUrnParseException, ESpecBundle.ESpecBundleInitException, InterruptedException, IOException, ExperimentSpecificationParser.ExperimentSpecificationParseException {
        try {
            ESpec eConfig;
            RequestRSpec rspecConfig = this.config.getRequestRSpec();
            if (rspecConfig != null) {
                switch (rspecConfig.getSource()) {
                    case GENERATE_USING_ADVERTISEMENT: {
                        RequestRSpec specRspecConfig = (GenerateUsingAdvertisementRequestRSpec)rspecConfig;
                        this.assertNotNull(this.advertisementRspecSource, "internal error");
                        this.assertNotNull(((GenerateUsingAdvertisementRequestRSpec)specRspecConfig).getConfig(), "internal error: check not done yet");
                        RSpecGenerator gen = new AdvertisementBasedRspecGenerator(this.rspecFactory, ((GenerateUsingAdvertisementRequestRSpec)specRspecConfig).getConfig(), this.advertisementRspecSource, this.testbedInfoSource);
                        this.context.requestRspec = gen.generate().getRspecXmlString();
                        this.logger.info("Generated Request RSpec using \"GENERATE_USING_ADVERTISEMENT\" method:");
                        this.logger.info(this.context.requestRspec, true);
                        break;
                    }
                    case GENERATE_USING_JFED: {
                        if (generateAndBindTargetCmUrn == null) {
                            this.logger.fatal("GENERATE_USING_JFED requires a CM URN");
                        }
                        RequestRSpec specRspecConfig = (GenerateUsingJFedRequestRSpec)rspecConfig;
                        RSpecGenerator gen = this.rSpecGeneratorFactoryProvider.get().createRSpecGenerator();
                        gen.setAm(generateAndBindTargetCmUrn);
                        gen.setNodeCount(((GenerateUsingJFedRequestRSpec)specRspecConfig).getNodeCount());
                        gen.setResourceClassIdPrefix(((GenerateUsingJFedRequestRSpec)specRspecConfig).getjFedResourceClass());
                        gen.setNodeAnsibleGroup(((GenerateUsingJFedRequestRSpec)specRspecConfig).getNodeAnsibleGroup());
                        this.context.requestRspec = gen.generateRequest();
                        this.logger.info("Generated Request RSpec using \"GENERATE_USING_JFED\" method:");
                        this.logger.info(this.context.requestRspec, true);
                        break;
                    }
                    case GENERATE_SIMPLE: {
                        RequestRSpec specRspecConfig;
                        if (generateAndBindTargetCmUrn == null) {
                            this.logger.fatal("GENERATE_SIMPLE requires a CM URN");
                        }
                        String exclusive = ((GenerateSimpleRequestRSpec)(specRspecConfig = (GenerateSimpleRequestRSpec)rspecConfig)).getNodeExclusive() ? "true" : "false";
                        String sliverTypeName = ((GenerateSimpleRequestRSpec)specRspecConfig).getNodeSliverType();
                        int nodeCount = ((GenerateSimpleRequestRSpec)specRspecConfig).getNodeCount();
                        List<String> compIds = ((GenerateSimpleRequestRSpec)specRspecConfig).getNodeComponentUrn();
                        this.assertTrue(compIds.isEmpty() || nodeCount == compIds.size(), "Config error: Mismatch of componentIds and nodeCount");
                        String compManId = generateAndBindTargetCmUrn;
                        this.context.requestRspec = "<?xml version='1.0'?>\n<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" type=\"request\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.geni.net/resources/rspec/3 http://www.geni.net/resources/rspec/3/request.xsd \">\n";
                        for (int i = 0; i < nodeCount; ++i) {
                            String ansibleGroup = i < ((GenerateSimpleRequestRSpec)specRspecConfig).getNodeAnsibleGroup().size() ? ((GenerateSimpleRequestRSpec)specRspecConfig).getNodeAnsibleGroup().get(i) : (((GenerateSimpleRequestRSpec)specRspecConfig).getNodeAnsibleGroup().isEmpty() ? null : ((GenerateSimpleRequestRSpec)specRspecConfig).getNodeAnsibleGroup().get(((GenerateSimpleRequestRSpec)specRspecConfig).getNodeAnsibleGroup().size() - 1));
                            Object compId = "";
                            if (compIds.size() > i) {
                                compId = " component_id=\"" + compIds.get(i) + "\"";
                            }
                            this.context.requestRspec = this.context.requestRspec + "  <node client_id=\"n" + i + "\" exclusive=\"" + exclusive + "\" component_manager_id=\"" + compManId + "\"" + (String)compId + ">\n    <sliver_type name=\"" + sliverTypeName + "\"/>\n" + (String)(ansibleGroup == null ? "" : "    <ansible_group xmlns=\"http://jfed.iminds.be/rspec/ext/jfed/1\" name=\"" + ansibleGroup + "\"/>\n") + "  </node>\n";
                        }
                        this.context.requestRspec = this.context.requestRspec + "</rspec>";
                        this.logger.info("Generated Request RSpec using \"simple\" method:");
                        this.logger.info(this.context.requestRspec, true);
                        break;
                    }
                    case PROVIDE_URL: {
                        URL url;
                        RequestRSpec specRspecConfig = (ProvidedRequestRSpec)rspecConfig;
                        String rspecUrl = ((ProvidedRequestRSpec)specRspecConfig).getProvidedContentSource();
                        this.assertNotNull(rspecUrl, "Config error: no RSpec URL provided");
                        try {
                            url = new URL(rspecUrl);
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException("Invalid URL specified for RSpec: \"" + rspecUrl + "\"", e);
                        }
                        try (InputStream is = url.openStream();){
                            String rspec = IOUtils.streamToString((InputStream)is, (String)"UTF-8");
                            if (rspec.trim().isEmpty()) {
                                this.logger.warn("Empty Rspec read from URL \"" + rspecUrl + "\"");
                            }
                            String head = TextUtil.abbreviate((String)rspec, (int)200);
                            this.logger.info("Downloaded Rspec from \"" + rspecUrl + "\". Rspec size: " + rspec.length() + " characters.\nHead: " + head, true);
                            this.context.requestRspec = rspec;
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to fetch RSpec at \"" + rspecUrl + "\"", e);
                        }
                    }
                    case PROVIDE_CONTENT: {
                        RequestRSpec specRspecConfig = (ProvidedRequestRSpec)rspecConfig;
                        this.context.requestRspec = ((ProvidedRequestRSpec)specRspecConfig).getProvidedContentSource();
                        this.assertNotNull(this.context.requestRspec, "Config error: no RSpec provided");
                        String head = TextUtil.abbreviate((String)this.context.requestRspec, (int)200);
                        this.logger.info("Using Request Rspec from config. Size: " + this.context.requestRspec.length() + " characters.\nHead: " + head, true);
                        break;
                    }
                    case PROVIDE_FILE: {
                        RequestRSpec specRspecConfig = (ProvidedFileRequestRSpec)rspecConfig;
                        String filename = ((ProvidedRequestRSpec)specRspecConfig).getProvidedContentSource();
                        this.assertNotNull(filename, "Config error: no RSpec filename specified in providedContentSource");
                        this.assertNotEmptyString(filename, "Config error: empty RSpec filename specified in providedContentSource");
                        try {
                            this.context.requestRspec = IOUtils.fileToString((String)filename);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to fetch RSpec from file \"" + filename + "\"", e);
                        }
                        this.assertNotNull(this.context.requestRspec, "Config error: no RSpec provided");
                        if (this.context.requestRspec.trim().isEmpty()) {
                            this.logger.warn("Empty Rspec read from file \"" + filename + "\"");
                        }
                        String head = TextUtil.abbreviate((String)this.context.requestRspec, (int)200);
                        this.logger.info("Using Request Rspec from file \"" + filename + "\". Size: " + this.context.requestRspec.length() + " characters.\nHead: " + head, true);
                        break;
                    }
                    default: {
                        throw new RuntimeException("RequestRSpec source " + this.config.getRequestRSpec().getSource() + " not yet implemented");
                    }
                }
                if (rspecConfig.getSource().isProvide() && ((ProvidedRequestRSpec)rspecConfig).getBindTestedServerToUnboundNodes()) {
                    String origRequestRspec = this.context.requestRspec;
                    this.context.requestRspec = RspecBinder.bindUnboundTo(this.logger::warn, s -> this.logger.warn((String)s, true), this.logger::info, (String)this.context.requestRspec, (String)generateAndBindTargetCmUrn);
                    if (!origRequestRspec.equals(this.context.requestRspec)) {
                        this.logger.info("Unbound nodes were bound to " + generateAndBindTargetCmUrn);
                    }
                }
                this.logger.logExtraXml("rspec" + this.uniqueId, this.context.requestRspec, true);
                this.context.allRequestedNodeComponentIds.addAll(this.logRequestRspecFixedNodes(this.context.requestRspec));
                this.context.requestRspecSource = new ImmutableRequestRspecSource(this.context.requestRspec, ModelRspecType.BASIC);
                this.context.serversInRspec = this.context.requestRspecSource.getAllComponentManagerUrns().stream().map(serverUrn -> this.authorityFinder.findByUrn(serverUrn, AuthorityFinder.Purpose.REQUEST_RSPEC)).collect(Collectors.toList());
                this.context.maxNodeNameLength = this.context.requestRspecSource.getBasicNodeInfo().stream().map(BasicStringRspec.BasicNodeInfo::getClientId).filter(Objects::nonNull).mapToInt(String::length).max().orElse(5);
            }
            if ((eConfig = this.config.getESpec()) != null) {
                String userPem;
                this.assertNotNull(eConfig.getProvidedContentSource());
                this.context.eSpecBundle = ExperimentSetupHelper.createESpecBundle(eConfig, this.user);
                this.assertNotNull(this.context.eSpecBundle);
                this.logger.logExtraXml("experiment-specification.yaml" + this.uniqueId, this.context.eSpecBundle.getExperimentSpecificationYml(), true);
                ExperimentSpecificationParser parser = new ExperimentSpecificationParser();
                this.context.eSpec = parser.parse(this.context.eSpecBundle.getExperimentSpecificationYml());
                String string = userPem = this.user == null || this.user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.user.getPrivateKey()));
                if (this.config.getOverrideESpecRSpec()) {
                    BasicExperimentSpecificationBuilder newEspecBuilder = new BasicExperimentSpecificationBuilder(this.context.eSpec);
                    newEspecBuilder.setRspec(new RspecSpec(new FileSource(FileSource.SourceType.DIRECT, this.context.requestRspec, "GuiLogicTest_generated_RSpec")));
                    this.context.eSpec = newEspecBuilder.create();
                    this.context.eSpecBundle = new ModifiedESpecBundle(this.context.eSpecBundle, this.context.eSpec);
                } else {
                    String requestRspec = new String(new FileFetcher(((RspecSpec)this.context.eSpec.getRspecs().get(0)).getSource(), this.context.eSpecBundle, this.rSpecGeneratorFactoryProvider.get(), (GitAuthPreferences)new SingleSshGitAuthPreferences(userPem)).fetchBytes(), StandardCharsets.UTF_8);
                    this.context.requestRspecSource = new ImmutableRequestRspecSource(requestRspec, ModelRspecType.BASIC);
                    this.context.serversInRspec = this.context.requestRspecSource.getAllComponentManagerUrns().stream().map(serverUrn -> this.authorityFinder.findByUrn(serverUrn, AuthorityFinder.Purpose.REQUEST_RSPEC)).collect(Collectors.toList());
                    this.context.maxNodeNameLength = this.context.requestRspecSource.getBasicNodeInfo().stream().map(BasicStringRspec.BasicNodeInfo::getClientId).filter(Objects::nonNull).mapToInt(String::length).max().orElse(5);
                    this.logger.logExtraXml("rspec" + this.uniqueId, requestRspec, true);
                    this.context.allRequestedNodeComponentIds.addAll(this.logRequestRspecFixedNodes(requestRspec));
                }
            }
        }
        catch (AdvertisementBasedRspecGenerator.RequiredResourcesUnavailableException e) {
            this.notEnoughFreeResourcesDetected = true;
            this.logger.fatal("Not enough free resources detected.", e);
        }
    }

    @Nonnull
    public static ESpecBundle createESpecBundle(@Nonnull ESpec eConfig, @Nullable GeniUser user) throws ESpecBundle.ESpecBundleInitException, InterruptedException {
        return switch (eConfig.getSource()) {
            case ESpec.ESpecSource.PROVIDE_ARCHIVE_FILE -> BundleFetcher.fetchArchiveFile((String)eConfig.getProvidedContentSource());
            case ESpec.ESpecSource.PROVIDE_DIR -> BundleFetcher.fetchDir((String)eConfig.getProvidedContentSource());
            case ESpec.ESpecSource.PROVIDE_ARCHIVE_URL -> BundleFetcher.fetchArchiveUrl((String)eConfig.getProvidedContentSource());
            case ESpec.ESpecSource.PROVIDE_GIT_REPO_DIR -> {
                String userPem = user == null || user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)user.getPrivateKey()));
                yield BundleFetcher.fetchGitRepoDir((String)eConfig.getProvidedContentSource(), (GitAuthPreferences)new SingleSshGitAuthPreferences(userPem));
            }
            default -> throw new IllegalStateException("Unsupported espec.source: " + eConfig.getSource().name());
        };
    }

    @Nonnull
    private List<String> logRequestRspecFixedNodes(@Nullable String requestRspec) {
        try {
            if (requestRspec == null) {
                return Collections.emptyList();
            }
            ImmutableRequestRspecSource requestRspecSource = new ImmutableRequestRspecSource(requestRspec, ModelRspecType.BASIC);
            List bni = requestRspecSource.getBasicNodeInfo();
            if (bni == null) {
                return Collections.emptyList();
            }
            List fixedNodesList = bni.stream().filter(Objects::nonNull).map(BasicStringRspec.BasicNodeInfo::getComponentId).filter(Objects::nonNull).collect(Collectors.toList());
            if (fixedNodesList.isEmpty()) {
                return Collections.emptyList();
            }
            this.logger.logExtraJson("rspec-request-fixed-nodes-" + this.uniqueId, fixedNodesList, false);
            return Collections.unmodifiableList(fixedNodesList);
        }
        catch (Exception e) {
            this.logger.info("Exception while extracting fixed nodes from request rspec", e);
            return Collections.emptyList();
        }
    }

    public void findProject() {
        this.assertNotNull(this.user);
        if (this.userAndSliceApiWrapper == null) {
            this.userAndSliceApiWrapper = this.auasawf.create();
        }
        switch (this.config.getSlice().getProjectSource()) {
            case NONE: {
                this.context.project = null;
                break;
            }
            case PROVIDED: {
                this.context.project = this.config.getSlice().getProject();
                break;
            }
            case AUTO: {
                UserAndSliceApiWrapper.SubAuthoritySupport subAuthoritySupport;
                List subAuthorityNames;
                try {
                    if (!this.userAndSliceApiWrapper.hasUserCredentials()) {
                        this.userAndSliceApiWrapper.getUserCredentials(this.callLogger, this.user.getUserUrn());
                    }
                    subAuthorityNames = this.userAndSliceApiWrapper.getSubAuthorityNames(this.callLogger, this.user.getUserUrn());
                }
                catch (Exception t) {
                    this.logger.warn("Exception while getting sub authority names. will try to ignore. Exception: " + t.getMessage());
                    subAuthorityNames = Collections.emptyList();
                }
                if (!subAuthorityNames.isEmpty()) {
                    this.context.project = (String)subAuthorityNames.get(0);
                    break;
                }
                try {
                    subAuthoritySupport = this.userAndSliceApiWrapper.getSubAuthoritySupport(this.callLogger);
                }
                catch (JFedException e) {
                    throw new RuntimeException("Failed to check if slice authority requires a mandatory authority/project for creating a slice");
                }
                if (Objects.equals(subAuthoritySupport, UserAndSliceApiWrapper.SubAuthoritySupport.SUB_AUTHORITY_MANDATORY)) {
                    throw new RuntimeException("There are no sub authorities for user " + this.user.getUserUrn());
                }
                this.context.project = null;
                break;
            }
        }
        if (this.context.project != null) {
            this.logger.info("Will use project: \"" + this.context.project + "\"");
        } else {
            this.assertFalse(this.config.getSlice().getFailIfNoProject(), "Empty project is not allowed by config");
            this.logger.info("Will NOT use a project");
        }
    }

    @Nullable
    public Slice findExistingSlice(@Nonnull String sliceName, @Nullable String project, boolean checkSliceAuth) {
        Server userAuthorityServer = this.user.getUserAuthorityServer();
        assert (userAuthorityServer != null);
        Object topLevelAuthority = userAuthorityServer.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority();
        if (this.context.project != null) {
            topLevelAuthority = (String)topLevelAuthority + ":" + this.context.project;
        }
        GeniUrn sliceUrn = GeniUrn.createGeniUrnFromEncodedParts((String)topLevelAuthority, (String)"slice", (String)this.context.sliceName);
        if (!checkSliceAuth) {
            return this.sfaModel.logExistSlice(sliceUrn);
        }
        if (!this.userAndSliceApiWrapper.hasUserCredentials()) {
            try {
                this.userAndSliceApiWrapper.getLocalUserCredentials(this.callLogger);
            }
            catch (JFedException e) {
                throw new RuntimeException("Failed to find existing slice: problem with user credential", e);
            }
        }
        try {
            List sliceCreds = this.userAndSliceApiWrapper.getSliceCredentials(this.callLogger, sliceUrn);
            if (sliceCreds == null || sliceCreds.isEmpty()) {
                return null;
            }
        }
        catch (JFedException e) {
            this.logger.info("Could not get credentials for slice '" + sliceUrn + "'", e);
            return null;
        }
        return this.sfaModel.getSlice(sliceUrn);
    }

    public void createExperiment(String sliceName, List<UserSpec> userSpecs, boolean allowNewSlice, boolean allowRecoverSlice) {
        this.assertNotNull(this.user);
        this.context.sliceName = sliceName;
        this.logger.info("Will create slice \"" + this.context.sliceName + "\"");
        Instant requestedEndTime = Instant.now().plus(this.config.getSlice().getExpireTimeMin(), ChronoUnit.MINUTES);
        this.logger.info("Created slice (and slivers) will expire at " + requestedEndTime);
        if (this.context.eSpec == null) {
            assert (this.context.requestRspecSource != null);
            assert (this.context.requestRspecSource.getStringRspec() != null);
            assert (this.context.requestRspecSource.getStringRspec().getXmlString() != null);
            assert (!this.context.requestRspecSource.getStringRspec().getXmlString().trim().isEmpty());
            boolean createNew = allowNewSlice;
            Slice existingSlice = null;
            if (allowNewSlice && allowRecoverSlice && (existingSlice = this.findExistingSlice(this.context.sliceName, this.context.project, true)) != null) {
                createNew = false;
            }
            if (createNew) {
                this.context.experiment = new Experiment(this.context.sliceName, this.context.project, Collections.emptyList(), this.context.requestRspecSource, null, requestedEndTime, userSpecs, false, this.config.getRunLinkTest(), this.scs);
            } else {
                if (existingSlice == null) {
                    existingSlice = this.findExistingSlice(this.context.sliceName, this.context.project, false);
                }
                if (existingSlice == null) {
                    throw new RuntimeException("Implementation error: Failed to assume slice exists");
                }
                existingSlice = this.sfaModel.resetSlice(existingSlice.getUrn());
                this.context.experiment = new Experiment(existingSlice, this.context.requestRspecSource, null, requestedEndTime, userSpecs, null, false, this.config.getRunLinkTest(), this.scs);
            }
        } else {
            String userPem = this.user == null || this.user.getPrivateKey() == null ? null : new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.user.getPrivateKey()));
            this.context.experiment = new Experiment(null, this.context.sliceName, this.context.project, Collections.emptyList(), this.context.eSpecBundle, null, requestedEndTime, userSpecs, false, this.rSpecGeneratorFactoryProvider.get(), (GitAuthPreferences)new SingleSshGitAuthPreferences(userPem), this.config.getRunLinkTest(), this.scs);
        }
        if (this.config.getWaitForReady().isEnabled()) {
            this.context.experiment.setMaxWaitUntilReady(Duration.ofMinutes(this.config.getWaitForReady().getMaxTimeMin()));
            this.context.experiment.setCheckReadyInterval(Duration.ofSeconds(30L));
            if (this.context.experiment.getMaxWaitUntilReady() != null) {
                this.logger.info("Configured experiment for maximum wait time of " + this.context.experiment.getMaxWaitUntilReady().toMinutes() + " minutes");
            }
        }
    }

    public void startExperiment(@Nonnull Injector injector) {
        this.assertTrue(this.config.getProvision().isEnabled(), "A disabled provision step is currently not supported.");
        this.context.notEnoughResourcesDetected = false;
        ExperimentControllerFactory experimentControllerFactory = (ExperimentControllerFactory)injector.getInstance(ExperimentControllerFactory.class);
        this.assertNotNull(experimentControllerFactory);
        this.context.experimentController = experimentControllerFactory.createExperimentController(this.context.experiment);
        this.context.experimentController.setExperimentLinkTesterFactory(experiment -> new TestLinksJob(experiment, (HighLevelTaskFactory)injector.getInstance(HighLevelTaskFactory.class), (TaskThread)injector.getInstance(TaskThread.class), (GeniUserProvider)injector.getInstance(GeniUserProvider.class), (JFedPreferences)injector.getInstance(JFedPreferences.class), (ProxyPreferencesManager)injector.getInstance(ProxyPreferencesManager.class), (ProxyServiceUtil)injector.getInstance(ProxyServiceUtil.class), (JobStateFactory)injector.getInstance(JobStateFactory.class), (ProxySocketFactoryProvider)injector.getInstance(ProxySocketFactoryProvider.class)));
        this.assertNotNull(this.context.experimentController);
        this.context.experimentController.start();
        this.logger.info("Started experimentController. ExperimentState is now " + this.context.experiment.getExperimentState());
    }

    public boolean mustWaitForExperiment() {
        if (!this.config.getWaitForReady().isEnabled() && this.config.eSpec == null) {
            this.logger.info("Will not wait for experiment to be ready (because of config).");
            this.context.waitForExperimentIsOver = true;
            this.context.notEnoughResourcesDetected = false;
            this.context.sawFailure = false;
        }
        if (!this.context.waitForExperimentIsOver) {
            this.assertTrue(this.config.getWaitForReady().isEnabled(), "bug in runExperiment step code.");
            this.logger.info("Current ExperimentState=" + this.context.experiment.getExperimentState());
            this.logger.info("Checking if experiment is ready.");
            if (this.context.experiment.getSliceUrn() != null) {
                this.context.sliceUrn = this.context.experiment.getSliceUrn();
            }
            if (this.context.experiment.getExperimentState() == ExperimentState.READY) {
                this.logger.info("Ready, because ExperimentState is READY");
                this.context.waitForExperimentIsOver = true;
            }
            if (this.context.experiment.getAnyPartSawNotEnoughFreeResourcesError()) {
                this.context.waitForExperimentIsOver = true;
                this.context.notEnoughResourcesDetected = true;
                this.context.sawFailure = true;
                this.logger.info("An experiment failed: not enough free resources");
            } else {
                if (this.context.experiment.getExperimentState().isTerminated()) {
                    this.context.waitForExperimentIsOver = true;
                    this.context.sawFailure = true;
                    this.logger.info("Failure, because ExperimentState is terminated");
                }
                if (!this.context.experiment.getExperimentState().isActiveState()) {
                    this.context.waitForExperimentIsOver = true;
                    this.context.sawFailure = true;
                    this.logger.info("Failure, because ExperimentState is not active state");
                }
            }
        }
        return !this.context.waitForExperimentIsOver;
    }

    public boolean isNotEnoughFreeResourcesDetected() {
        return this.notEnoughFreeResourcesDetected;
    }

    @Contract(value="false -> fail")
    protected void assertTrue(boolean v) {
        this.assertTrue(v, "assertTrue failed");
    }

    @Contract(value="false,_ -> fail")
    protected void assertTrue(boolean v, @Nullable String failText) {
        if (!v) {
            this.logger.fatal(failText);
        }
    }

    @Contract(value="true -> fail")
    protected void assertFalse(boolean v) {
        this.assertFalse(v, "assertFalse failed");
    }

    @Contract(value="true,_ -> fail")
    protected void assertFalse(boolean v, @Nullable String failText) {
        if (v) {
            this.logger.fatal(failText);
        }
    }

    @Contract(value="null -> fail")
    protected void assertNotNull(@Nullable Object o) {
        this.assertNotNull(o, "object is null");
    }

    @Contract(value="null,_ -> fail")
    protected void assertNotNull(@Nullable Object o, @Nullable String failText) {
        if (o == null) {
            this.logger.fatal(failText);
        }
    }

    protected void assertNotEmptyString(@Nonnull String s, @Nullable String failText) {
        if (s.trim().isEmpty()) {
            this.logger.fatal(failText);
        }
    }
}

