/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup.config;

import be.iminds.ilabt.jfed.experiment.setup.config.GenerateSimpleRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class GenerateUsingJFedRequestRSpec
extends RequestRSpec {
    private final int nodeCount;
    @Nullable
    private final String jFedResourceClass;
    @Nonnull
    private final List<String> nodeAnsibleGroup;

    public GenerateUsingJFedRequestRSpec() {
        super(RequestRSpec.RequestRSpecSource.GENERATE_USING_JFED, false, false);
        this.nodeCount = 1;
        this.jFedResourceClass = null;
        this.nodeAnsibleGroup = Collections.emptyList();
    }

    @JsonCreator
    public GenerateUsingJFedRequestRSpec(@Nonnull @JsonProperty(value="source") RequestRSpec.RequestRSpecSource source, @Nullable @JsonProperty(value="nodeCount") Integer nodeCount, @Nullable @JsonProperty(value="jFedResourceClass") String jFedResourceClass, @Nullable @JsonProperty(value="nodeAnsibleGroup") List<String> nodeAnsibleGroup, @Nullable @JsonProperty(value="autoAssignSpecificNodesUsingListResources") Boolean autoAssignSpecificNodesUsingListResources, @Nullable @JsonProperty(value="useNitosLease") Boolean useNitosLease) {
        super(RequestRSpec.RequestRSpecSource.GENERATE_USING_JFED, autoAssignSpecificNodesUsingListResources, useNitosLease);
        assert (source == RequestRSpec.RequestRSpecSource.GENERATE_USING_JFED);
        assert (this.getSource() == RequestRSpec.RequestRSpecSource.GENERATE_USING_JFED);
        this.nodeCount = nodeCount == null ? new GenerateUsingJFedRequestRSpec().getNodeCount() : nodeCount.intValue();
        this.jFedResourceClass = jFedResourceClass == null ? new GenerateUsingJFedRequestRSpec().getjFedResourceClass() : jFedResourceClass;
        this.nodeAnsibleGroup = nodeAnsibleGroup == null ? new GenerateSimpleRequestRSpec().getNodeAnsibleGroup() : nodeAnsibleGroup;
    }

    @Override
    @JsonIgnore
    public boolean isValid() {
        if (this.nodeCount <= 0) {
            throw new IllegalArgumentException("Config Error: rspec.nodeCount == " + this.nodeCount + " makes no sense if rspec.source == " + this.source);
        }
        return true;
    }

    @JsonProperty
    public int getNodeCount() {
        return this.nodeCount;
    }

    @JsonProperty
    @Nullable
    public String getjFedResourceClass() {
        return this.jFedResourceClass;
    }

    @JsonProperty
    @Nonnull
    public List<String> getNodeAnsibleGroup() {
        return this.nodeAnsibleGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateUsingJFedRequestRSpec)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenerateUsingJFedRequestRSpec that = (GenerateUsingJFedRequestRSpec)o;
        if (this.nodeCount != that.nodeCount) {
            return false;
        }
        if (!this.nodeAnsibleGroup.equals(that.nodeAnsibleGroup)) {
            return false;
        }
        return this.jFedResourceClass != null ? this.jFedResourceClass.equals(that.jFedResourceClass) : that.jFedResourceClass == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.nodeCount;
        result = 31 * result + (this.jFedResourceClass != null ? this.jFedResourceClass.hashCode() : 0);
        result = 31 * result + this.nodeAnsibleGroup.hashCode();
        return result;
    }
}

