/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup.config;

import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedContentRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedFileRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedUrlRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="source", defaultImpl=ProvidedContentRequestRSpec.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ProvidedUrlRequestRSpec.class, name="PROVIDE_URL"), @JsonSubTypes.Type(value=ProvidedFileRequestRSpec.class, name="PROVIDE_FILE"), @JsonSubTypes.Type(value=ProvidedContentRequestRSpec.class, name="PROVIDE_CONTENT")})
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public abstract class ProvidedRequestRSpec
extends RequestRSpec {
    @Nullable
    private final String providedContentSource;
    private final boolean bindTestedServerToUnboundNodes;
    @Nullable
    private final String bindUnboundNodesUrn;

    public ProvidedRequestRSpec() {
        super(RequestRSpec.RequestRSpecSource.PROVIDE_CONTENT, false, false);
        this.providedContentSource = "";
        this.bindTestedServerToUnboundNodes = true;
        this.bindUnboundNodesUrn = null;
    }

    @JsonCreator
    public ProvidedRequestRSpec(@Nonnull @JsonProperty(value="source") RequestRSpec.RequestRSpecSource source, @Nullable @JsonProperty(value="providedContentSource") String providedContentSource, @Nullable @JsonProperty(value="bindTestedServerToUnboundNodes") Boolean bindTestedServerToUnboundNodes, @Nullable @JsonProperty(value="bindUnboundNodesUrn") String bindUnboundNodesUrn, @Nullable @JsonProperty(value="autoAssignSpecificNodesUsingListResources") Boolean autoAssignSpecificNodesUsingListResources, @Nullable @JsonProperty(value="useNitosLease") Boolean useNitosLease) {
        super(source, autoAssignSpecificNodesUsingListResources, useNitosLease);
        assert (source == RequestRSpec.RequestRSpecSource.PROVIDE_CONTENT || source == RequestRSpec.RequestRSpecSource.PROVIDE_FILE || source == RequestRSpec.RequestRSpecSource.PROVIDE_URL);
        assert (this.getSource() == RequestRSpec.RequestRSpecSource.PROVIDE_CONTENT || this.getSource() == RequestRSpec.RequestRSpecSource.PROVIDE_FILE || this.getSource() == RequestRSpec.RequestRSpecSource.PROVIDE_URL);
        this.providedContentSource = providedContentSource;
        this.bindTestedServerToUnboundNodes = bindTestedServerToUnboundNodes == null ? new ProvidedContentRequestRSpec().getBindTestedServerToUnboundNodes() : bindTestedServerToUnboundNodes.booleanValue();
        this.bindUnboundNodesUrn = bindUnboundNodesUrn;
    }

    @Override
    @JsonIgnore
    public boolean isValid() {
        if (this.providedContentSource == null) {
            throw new IllegalArgumentException("Config Error: rspec.providedContentSource may not be null if rspec.source == " + this.source);
        }
        if (this.providedContentSource.trim().isEmpty()) {
            throw new IllegalArgumentException("Config Error: rspec.providedContentSource may not be empty if rspec.source == " + this.source);
        }
        return true;
    }

    @JsonProperty
    @Nullable
    public String getProvidedContentSource() {
        return this.providedContentSource;
    }

    @JsonProperty
    public boolean getBindTestedServerToUnboundNodes() {
        return this.bindTestedServerToUnboundNodes;
    }

    @Nullable
    @JsonProperty
    public String getBindUnboundNodesUrn() {
        return this.bindUnboundNodesUrn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProvidedRequestRSpec)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProvidedRequestRSpec that = (ProvidedRequestRSpec)o;
        return this.bindTestedServerToUnboundNodes == that.bindTestedServerToUnboundNodes && Objects.equals(this.providedContentSource, that.providedContentSource) && Objects.equals(this.bindUnboundNodesUrn, that.bindUnboundNodesUrn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.providedContentSource, this.bindTestedServerToUnboundNodes, this.bindUnboundNodesUrn);
    }

    public String toString() {
        return "ProvidedRequestRSpec{source='" + this.getSource() + "', providedContentSource=" + this.providedContentSource + ", bindTestedServerToUnboundNodes=" + this.bindTestedServerToUnboundNodes + ", bindUnboundNodesUrn=" + this.bindUnboundNodesUrn + "}";
    }
}

