/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class Slice {
    @Nullable
    private final String sliceName;
    private final boolean failOnExistingSlice;
    private final boolean failOnNonExistingSlice;
    private final long expireTimeMin;
    private final long maxWaitForExperimentRecoveredSeconds;
    private final boolean renewExistingSliceIfNeeded;
    @Nonnull
    private final ProjectSource projectSource;
    private final boolean failIfNoProject;
    @Nullable
    private final String project;

    public Slice() {
        this.sliceName = null;
        this.failOnExistingSlice = true;
        this.failOnNonExistingSlice = false;
        this.expireTimeMin = 60L;
        this.maxWaitForExperimentRecoveredSeconds = 10L;
        this.renewExistingSliceIfNeeded = true;
        this.projectSource = ProjectSource.AUTO;
        this.failIfNoProject = false;
        this.project = null;
    }

    @JsonCreator
    public Slice(@Nullable @JsonProperty(value="sliceName") String sliceName, @Nullable @JsonProperty(value="failOnExistingSlice") Boolean failOnExistingSlice, @Nullable @JsonProperty(value="failOnNonExistingSlice") Boolean failOnNonExistingSlice, @Nullable @JsonProperty(value="expireTimeMin") Long expireTimeMin, @Nullable @JsonProperty(value="maxWaitForExperimentRecoveredSeconds") Long maxWaitForExperimentRecoveredSeconds, @Nullable @JsonProperty(value="renewExistingSliceIfNeeded") Boolean renewExistingSliceIfNeeded, @Nullable @JsonProperty(value="projectSource") ProjectSource projectSource, @Nullable @JsonProperty(value="failIfNoProject") Boolean failIfNoProject, @Nullable @JsonProperty(value="project") String project) {
        this.sliceName = sliceName == null ? new Slice().getSliceName() : sliceName;
        this.failOnExistingSlice = failOnExistingSlice == null ? new Slice().getFailOnExistingSlice() : failOnExistingSlice.booleanValue();
        this.failOnNonExistingSlice = failOnNonExistingSlice == null ? new Slice().getFailOnNonExistingSlice() : failOnNonExistingSlice.booleanValue();
        this.expireTimeMin = expireTimeMin == null ? new Slice().getExpireTimeMin() : expireTimeMin.longValue();
        this.maxWaitForExperimentRecoveredSeconds = maxWaitForExperimentRecoveredSeconds == null ? new Slice().getMaxWaitForExperimentRecoveredSeconds() : maxWaitForExperimentRecoveredSeconds.longValue();
        this.renewExistingSliceIfNeeded = renewExistingSliceIfNeeded == null ? new Slice().getRenewExistingSliceIfNeeded() : renewExistingSliceIfNeeded.booleanValue();
        this.projectSource = projectSource == null ? new Slice().getProjectSource() : projectSource;
        this.failIfNoProject = failIfNoProject == null ? new Slice().getFailIfNoProject() : failIfNoProject.booleanValue();
        this.project = project == null ? new Slice().getProject() : project;
    }

    @JsonIgnore
    public boolean isValid() {
        if (this.expireTimeMin <= 0L) {
            throw new IllegalArgumentException("Config Error: slice.expireTimeMin <= 0 makes no sense: " + this.expireTimeMin);
        }
        if (this.maxWaitForExperimentRecoveredSeconds <= 0L) {
            throw new IllegalArgumentException("Config Error: slice.maxWaitForExperimentRecoveredSeconds <= 0 makes no sense: " + this.maxWaitForExperimentRecoveredSeconds);
        }
        if (this.projectSource == ProjectSource.PROVIDED && this.project == null && this.failIfNoProject) {
            throw new IllegalArgumentException("Config Error: Combination of failIfNoProject=true and project==null and projectSource == ProjectSource.PROVIDED will always fail");
        }
        if (this.projectSource == ProjectSource.NONE && this.failIfNoProject) {
            throw new IllegalArgumentException("Config Error: Combination of failIfNoProject=true and projectSource == ProjectSource.NONE will always fail");
        }
        if (this.failOnExistingSlice && this.failOnNonExistingSlice) {
            throw new IllegalArgumentException("Config Error: failOnExistingSlice and failOnNonExistingSlice should not both be true");
        }
        return true;
    }

    @Nullable
    public String getSliceName() {
        return this.sliceName;
    }

    public boolean getFailOnExistingSlice() {
        return this.failOnExistingSlice;
    }

    public boolean getFailOnNonExistingSlice() {
        return this.failOnNonExistingSlice;
    }

    public long getExpireTimeMin() {
        return this.expireTimeMin;
    }

    public long getMaxWaitForExperimentRecoveredSeconds() {
        return this.maxWaitForExperimentRecoveredSeconds;
    }

    public boolean getRenewExistingSliceIfNeeded() {
        return this.renewExistingSliceIfNeeded;
    }

    @Nonnull
    public ProjectSource getProjectSource() {
        return this.projectSource;
    }

    public boolean getFailIfNoProject() {
        return this.failIfNoProject;
    }

    @Nullable
    public String getProject() {
        return this.project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice slice = (Slice)o;
        if (this.failOnExistingSlice != slice.failOnExistingSlice) {
            return false;
        }
        if (this.failOnNonExistingSlice != slice.failOnNonExistingSlice) {
            return false;
        }
        if (this.expireTimeMin != slice.expireTimeMin) {
            return false;
        }
        if (this.maxWaitForExperimentRecoveredSeconds != slice.maxWaitForExperimentRecoveredSeconds) {
            return false;
        }
        if (this.renewExistingSliceIfNeeded != slice.renewExistingSliceIfNeeded) {
            return false;
        }
        if (this.failIfNoProject != slice.failIfNoProject) {
            return false;
        }
        if (this.sliceName != null ? !this.sliceName.equals(slice.sliceName) : slice.sliceName != null) {
            return false;
        }
        if (this.projectSource != slice.projectSource) {
            return false;
        }
        return this.project != null ? this.project.equals(slice.project) : slice.project == null;
    }

    public int hashCode() {
        int result = this.sliceName != null ? this.sliceName.hashCode() : 0;
        result = 31 * result + (this.failOnExistingSlice ? 1 : 0);
        result = 31 * result + (this.failOnNonExistingSlice ? 1 : 0);
        result = 31 * result + (int)(this.expireTimeMin ^ this.expireTimeMin >>> 32);
        result = 31 * result + (int)(this.maxWaitForExperimentRecoveredSeconds ^ this.maxWaitForExperimentRecoveredSeconds >>> 32);
        result = 31 * result + (this.renewExistingSliceIfNeeded ? 1 : 0);
        result = 31 * result + this.projectSource.hashCode();
        result = 31 * result + (this.failIfNoProject ? 1 : 0);
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        return result;
    }

    public static enum ProjectSource {
        NONE,
        AUTO,
        PROVIDED;

    }
}

