/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.util;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.annotation.Nullable;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentRestoreInformation {
    private static final DateTimeFormatter EXPIRATION_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final String KEY_RESERVATION_START_TIME = "reservation-start-time";
    private static final String KEY_EXPIRATION_TIME = "expiration-time";
    private static final String KEY_REQUEST_RSPEC = "request-rspec";
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentRestoreInformation.class);
    private static final String SLICE_RESTORE_INFORMATION_EXT = ".sri";
    private static final String SLICE_RESTORE_INFORMATION_BASEDIR = JFedUtils.getUserDataDirectory() + "slice_recovery";
    private final FileConfiguration conf;
    private final GeniUrn sliceUrn;

    public ExperimentRestoreInformation(GeniUrn sliceUrn) {
        this.sliceUrn = sliceUrn;
        this.conf = ExperimentRestoreInformation.createConfigurationFile(sliceUrn);
    }

    public void bindToExperiment(Experiment experiment) {
        assert (experiment != null);
        assert (experiment.getSliceOrNull() != null);
        this.updateSliceRequestRspec(experiment.getSliceOrNull());
        experiment.getSliceOrNull().requestRspecProperty().addListener(observable -> this.updateSliceRequestRspec(experiment.getSliceOrNull()));
        this.updateSliceExpirationTime(experiment.getSliceOrNull());
        experiment.getSliceOrNull().expirationDateProperty().addListener(observable -> this.updateSliceExpirationTime(experiment.getSliceOrNull()));
        this.setReservationStartTime(experiment.getRequestedStartTime());
    }

    private void updateSliceRequestRspec(Slice slice) {
        if (slice.getRequestRspec() != null) {
            this.setRequestRspec(slice.getRequestRspec().getRspecXmlString());
        } else {
            this.setRequestRspec(null);
        }
    }

    private void updateSliceExpirationTime(Slice slice) {
        this.setExpirationTime(slice.getExpirationDate());
    }

    private static FileConfiguration createConfigurationFile(GeniUrn sliceUrn) {
        File file = ExperimentRestoreInformation.getFile(sliceUrn);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LOG.warn("Could not make the necessary directories for storing the slice restore information");
        }
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration(file);
            conf.setEncoding("UTF-8");
            conf.setAutoSave(true);
            return conf;
        }
        catch (ConfigurationException e) {
            LOG.error("Could not initialize file for saving slice backup information", (Throwable)e);
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e2) {
                LOG.error("Could not delete file {}.", (Object)file.getAbsolutePath(), (Object)e2);
            }
            try {
                PropertiesConfiguration conf = new PropertiesConfiguration(file);
                conf.setEncoding("UTF-8");
                conf.setAutoSave(true);
                return conf;
            }
            catch (ConfigurationException e3) {
                LOG.error("Could not initialize file on SECOND TRY for saving slice backup information", (Throwable)e3);
                return null;
            }
        }
    }

    public GeniUrn getSliceUrn() {
        return this.sliceUrn;
    }

    @Nullable
    public Instant getExpirationTime() {
        if (this.conf == null) {
            LOG.warn("Could not access SliceRestoreInformation-file");
            return null;
        }
        if (this.conf.containsKey(KEY_EXPIRATION_TIME)) {
            try {
                return ZonedDateTime.parse(this.conf.getString(KEY_EXPIRATION_TIME), EXPIRATION_DATETIME_FORMAT).toInstant();
            }
            catch (DateTimeParseException ex) {
                LOG.debug("Could not parse expiration date '{}'", (Object)this.conf.getString(KEY_EXPIRATION_TIME), (Object)ex);
                return null;
            }
        }
        return null;
    }

    private void setExpirationTime(Instant dateTime) {
        if (this.conf == null) {
            LOG.warn("Could not access SliceRestoreInformation-file");
            return;
        }
        if (dateTime != null) {
            this.conf.setProperty(KEY_EXPIRATION_TIME, (Object)EXPIRATION_DATETIME_FORMAT.format(ZonedDateTime.ofInstant(dateTime, ZoneId.systemDefault())));
        } else {
            this.conf.clearProperty(KEY_EXPIRATION_TIME);
        }
    }

    @Nullable
    public Instant getReservationStartTime() {
        if (this.conf == null) {
            LOG.warn("Could not access SliceRestoreInformation-file");
            return null;
        }
        if (this.conf.containsKey(KEY_RESERVATION_START_TIME)) {
            try {
                return ZonedDateTime.parse(this.conf.getString(KEY_RESERVATION_START_TIME), EXPIRATION_DATETIME_FORMAT).toInstant();
            }
            catch (DateTimeParseException ex) {
                LOG.debug("Could not parse reservation start time '{}'", (Object)this.conf.getString(KEY_RESERVATION_START_TIME), (Object)ex);
                return null;
            }
        }
        return null;
    }

    private void setReservationStartTime(Instant dateTime) {
        if (this.conf == null) {
            LOG.warn("Could not access SliceRestoreInformation-file");
            return;
        }
        if (dateTime != null) {
            this.conf.setProperty(KEY_RESERVATION_START_TIME, (Object)EXPIRATION_DATETIME_FORMAT.format(ZonedDateTime.ofInstant(dateTime, ZoneId.systemDefault())));
        } else {
            this.conf.clearProperty(KEY_RESERVATION_START_TIME);
        }
    }

    public String getRequestRspec() {
        if (this.conf == null) {
            LOG.warn("Could not access SliceRestoreInformation-file");
            return null;
        }
        return this.conf.getString(KEY_REQUEST_RSPEC);
    }

    private void setRequestRspec(String rspec) {
        if (this.conf == null) {
            LOG.warn("Could not access SliceRestoreInformation-file");
            return;
        }
        if (rspec != null) {
            this.conf.setProperty(KEY_REQUEST_RSPEC, (Object)rspec.replace(",", "\\,"));
        } else {
            this.conf.clearProperty(KEY_REQUEST_RSPEC);
        }
    }

    public static boolean exists(GeniUrn sliceUrn) {
        return ExperimentRestoreInformation.getFile(sliceUrn).exists();
    }

    private static File getFile(GeniUrn urn) {
        StringBuilder sb = new StringBuilder();
        sb.append(SLICE_RESTORE_INFORMATION_BASEDIR);
        sb.append(File.separator);
        sb.append(ExperimentRestoreInformation.scrubIllegalPathCharacters(urn.getEncodedTopLevelAuthority_withoutSubAuth()));
        if (urn.hasSubAuthority()) {
            sb.append(File.separator);
            sb.append(ExperimentRestoreInformation.scrubIllegalPathCharacters(urn.getEncodedSubAuthName()));
        }
        sb.append(File.separator);
        sb.append(ExperimentRestoreInformation.scrubIllegalPathCharacters(urn.getEncodedResourceName()));
        sb.append(SLICE_RESTORE_INFORMATION_EXT);
        return new File(sb.toString());
    }

    public void delete() {
        this.conf.clear();
    }

    private static String scrubIllegalPathCharacters(String input) {
        return input.replaceAll("[^a-zA-Z0-9.-]", "_");
    }
}

