/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.util;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextExperimentExpiration {
    private static final Logger LOG = LoggerFactory.getLogger(NextExperimentExpiration.class);
    private final ExperimentPart firstExpiringPart;
    private final Instant firstExpirationTime;

    public NextExperimentExpiration(@Nonnull Experiment experiment) {
        assert (experiment.getSliceOrNull() != null);
        ExperimentPart firstExpiringPart = null;
        Instant firstExpirationTime = experiment.getSliceOrNull() == null ? null : experiment.getSliceOrNull().getExpirationDate();
        for (ExperimentPart part : experiment.getPartsListCopy()) {
            if (part.getState() == InternalState.UNALLOCATED || part.getState() == InternalState.DELETED) {
                LOG.trace("Skipping part {}, as status is {}", (Object)part.getName(), (Object)part.getState());
                continue;
            }
            if (part instanceof SfaExperimentPart) {
                boolean hasNodes = false;
                boolean hasLinks = false;
                for (Sliver sliver : ((SfaExperimentPart)part).getSlivers()) {
                    hasNodes |= sliver.getNodes() != null && !sliver.getNodes().isEmpty();
                    hasLinks |= sliver.getLinks() != null && !sliver.getLinks().isEmpty();
                }
                if (!hasNodes && hasLinks) {
                    LOG.trace("Skipping part {}, as it has only links", (Object)part.getName());
                    continue;
                }
            }
            if (part.getExpirationTime() == null) {
                LOG.trace("Skipping part {}, as it has no expiration date", (Object)part.getName());
                continue;
            }
            if (firstExpirationTime != null && !part.getExpirationTime().isBefore(firstExpirationTime)) continue;
            firstExpiringPart = part;
            firstExpirationTime = part.getExpirationTime();
        }
        this.firstExpirationTime = firstExpirationTime;
        this.firstExpiringPart = firstExpiringPart;
        LOG.debug("Next expiration time was determined to be {} (source: {})", (Object)firstExpirationTime, (Object)(firstExpiringPart != null ? firstExpiringPart.getName() : "experiment"));
    }

    @Nullable
    public Instant getFirstExpirationTime() {
        return this.firstExpirationTime;
    }

    @Nullable
    public ExperimentPart getFirstExpiringPart() {
        return this.firstExpiringPart;
    }

    public boolean hasPartExpired() {
        return this.firstExpirationTime.isBefore(Instant.now());
    }
}

