/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.util;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpiration;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.ExecuteOnNotNull;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;

public class NextExperimentExpirationBinding
extends ObjectBinding<NextExperimentExpiration> {
    private final Experiment experiment;
    private final ListChangeListener<ExperimentPart> experimentPartsListChangeListener = c -> {
        while (c.next()) {
            c.getAddedSubList().forEach(part -> this.bind(new Observable[]{part.expirationTimeProperty()}));
            c.getRemoved().forEach(part -> this.unbind(new Observable[]{part.expirationTimeProperty()}));
        }
        Platform.runLater(() -> ((NextExperimentExpirationBinding)this).invalidate());
    };

    public NextExperimentExpirationBinding(final Experiment experiment) {
        this.experiment = experiment;
        experiment.getPartsStream().forEach(part -> this.bind(new Observable[]{part.expirationTimeProperty()}));
        experiment.getPartsObservableList().addListener((ListChangeListener)new WeakListChangeListener(this.experimentPartsListChangeListener));
        new ExecuteOnNotNull<Slice>(experiment.sliceProperty()){

            @Override
            public void run() {
                assert (experiment.getSliceOrNull() != null);
                NextExperimentExpirationBinding.this.bind(new Observable[]{experiment.getSlice().expirationDateProperty()});
            }
        };
    }

    protected NextExperimentExpiration computeValue() {
        if (this.experiment.getSliceOrNull() == null) {
            return null;
        }
        return new NextExperimentExpiration(this.experiment);
    }
}

