/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.gui_preferences;

import javax.annotation.Nullable;

public enum DoubleProxyHandling {
    IGNORE_AND_USE_JFED_PROXY("jfed"),
    IGNORE_AND_USE_TESTBED_PROXY("testbed"),
    ASK("ask");

    private final String configValue;

    private DoubleProxyHandling(String configValue) {
        this.configValue = configValue;
    }

    public String getConfigValue() {
        return this.configValue;
    }

    public static DoubleProxyHandling fromConfigValue(@Nullable String configValue) {
        if (configValue == null || configValue.trim().isEmpty()) {
            return ASK;
        }
        configValue = configValue.trim();
        switch (configValue.trim().toLowerCase().replaceAll("[^a-z]*", "").replaceAll("proxy", "")) {
            case "jfed": {
                return IGNORE_AND_USE_JFED_PROXY;
            }
            case "testbed": {
                return IGNORE_AND_USE_TESTBED_PROXY;
            }
        }
        return ASK;
    }
}

