/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.gui_preferences;

import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.gui_preferences.JFedPreferencesApplier;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JFedPreferencesApplierImpl
implements JFedPreferencesApplier {
    private static final Logger LOG = LoggerFactory.getLogger(JFedPreferencesApplierImpl.class);
    private final JFedHLPreferences jFedPreferences;
    private final SfaModel sfaModel;
    private final GeniUserProvider geniUserProvider;
    private final ProxyPreferencesManager proxyPreferencesManager;

    @Inject
    public JFedPreferencesApplierImpl(JFedHLPreferences jFedPreferences, SfaModel sfaModel, GeniUserProvider geniUserProvider, ProxyPreferencesManager proxyPreferencesManager) {
        this.jFedPreferences = jFedPreferences;
        this.sfaModel = sfaModel;
        this.geniUserProvider = geniUserProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
    }

    @Override
    public void applyPreferences() {
        this.registerPrivateKeys();
        this.registerPublicKeys();
        this.proxyPreferencesManager.updateProxySettings();
    }

    private void registerPrivateKeys() {
        GeniUserSshKeyInfo userSshKeyInfo;
        GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
        PuTTYFilesKeyInfo customSshKeyInfo = this.jFedPreferences.getCustomSshKeyInfo();
        if (customSshKeyInfo != null) {
            String customPubKeyStr = PublicKeyConvertor.fromPublicKey((PublicKey)customSshKeyInfo.getPublicKey()).withComment(geniUser.getUserUrn().getResourceName() + " jFed setting custom key").getOpensshFormString();
            LOG.info("Will add public key from configuration to created slivers: " + customPubKeyStr);
            this.sfaModel.addUserKey(customPubKeyStr);
        }
        if ((userSshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser)).getPublicKey() != null) {
            String userPubKeyStr = PublicKeyConvertor.fromPublicKey((PublicKey)userSshKeyInfo.getPublicKey()).withComment(geniUser.getUserUrn().getResourceName() + " jFed login key").getOpensshFormString();
            LOG.info("Will add user specified public key to created slivers: " + userPubKeyStr);
            this.sfaModel.addUserKey(userPubKeyStr);
        } else {
            LOG.warn("No public key in userSshKeyInfo (class=" + userSshKeyInfo.getClass().getName() + ")");
        }
    }

    private void registerPublicKeys() {
        List publicKeyFiles = this.jFedPreferences.getPublicKeyFiles();
        for (File f : publicKeyFiles) {
            try {
                String pubKeyContent = IOUtils.fileToString((File)f);
                this.sfaModel.addUserKey(pubKeyContent);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + f.getAbsolutePath(), (Throwable)e);
            }
        }
    }
}

