/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.call_log_output;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReport;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportConstants;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallRestoreContext;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallReportReader {
    private static final Logger LOG = LoggerFactory.getLogger(CallReportReader.class);
    private final CallRestoreContext callRestoreContext;
    private final CallReportFactory callReportFactory;

    public CallReportReader(CallRestoreContext callRestoreContext, CallReportFactory callReportFactory) {
        this.callRestoreContext = callRestoreContext;
        this.callReportFactory = callReportFactory;
    }

    public CallReport readCallReport(Reader reader) throws XMLStreamException, CallReportParseException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        StreamSource xml = new StreamSource(reader);
        XMLEventReader eventReader = xif.createXMLEventReader(xml);
        assert (eventReader.hasNext());
        XMLEvent e = eventReader.nextEvent();
        while (!e.isStartElement() || !Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_CALL_REPORT)) {
            e = eventReader.nextEvent();
        }
        return this.readCallReport(eventReader, e);
    }

    public CallReport readCallReport(InputStream inputStream) throws XMLStreamException, CallReportParseException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        StreamSource xml = new StreamSource(inputStream);
        XMLEventReader eventReader = xif.createXMLEventReader(xml);
        assert (eventReader.hasNext());
        XMLEvent e = eventReader.nextEvent();
        return this.readCallReport(eventReader, e);
    }

    public CallReport readCallReport(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, CallReportParseException {
        assert (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_CALL_REPORT));
        String reportTitle = e.asStartElement().getAttributeByName(CallReportConstants.Q_TITLE).getValue();
        String reportObject = e.asStartElement().getAttributeByName(CallReportConstants.Q_REPORTER).getValue();
        ArrayList<CallReport.State> states = new ArrayList<CallReport.State>();
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_STATES)) {
                states.addAll(this.readStates(eventReader, e));
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), CallReportConstants.Q_CALL_REPORT)) {
                return this.callReportFactory.createCallReport(reportTitle, reportObject, states);
            }
            this.logUnexpectedElement(CallReportConstants.Q_CALL_REPORT, e);
        }
        throw CallReportReader.createUnexpectedEndException(CallReportConstants.Q_CALL_REPORT, e.getLocation());
    }

    private List<CallReport.State> readStates(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, CallReportParseException {
        assert (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_STATES));
        ArrayList<CallReport.State> res = new ArrayList<CallReport.State>();
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_STATE)) {
                res.add(this.readState(eventReader, e));
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), CallReportConstants.Q_STATES)) {
                return res;
            }
            this.logUnexpectedElement(CallReportConstants.Q_STATES, e);
        }
        throw CallReportReader.createUnexpectedEndException(CallReportConstants.Q_STATES, e.getLocation());
    }

    private CallReport.State readState(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, CallReportParseException {
        assert (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_STATE));
        ChronoZonedDateTime startDate = null;
        ChronoZonedDateTime endDate = null;
        String name = null;
        List<LogOutput.LogEntry> logLines = Collections.emptyList();
        List<ApiCallDetailsRef> calls = Collections.emptyList();
        LogOutput.TestResultState state = null;
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_START)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at start", e.getLocation());
                    }
                    startDate = ZonedDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault()).parse(e.asCharacters().getData()));
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_END)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at end, but got " + e.getEventType(), e.getLocation());
                    }
                    endDate = ZonedDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault()).parse(e.asCharacters().getData()));
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_NAME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at name", e.getLocation());
                    }
                    name = e.asCharacters().getData();
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_LOGENTRIES)) {
                    logLines = this.readLogLines(eventReader, e);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_CALLS)) {
                    calls = this.readCalls(eventReader, e);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_STATESTATE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at " + CallReportConstants.Q_STATESTATE, e.getLocation());
                    }
                    state = LogOutput.TestResultState.valueOf((String)e.asCharacters().getData());
                    continue;
                }
                this.logUnexpectedElement(CallReportConstants.Q_STATE, e);
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), CallReportConstants.Q_STATE)) {
                CallReport.State res = this.callReportFactory.createCallReportState(name, startDate != null ? Date.from(startDate.toInstant()) : null);
                if (endDate != null) {
                    res.setEnd(Date.from(endDate.toInstant()));
                }
                logLines.forEach(res::log);
                calls.forEach(res::logCall);
                res.setState(state);
                return res;
            }
            this.logUnexpectedElement(CallReportConstants.Q_STATE, e);
        }
        throw CallReportReader.createUnexpectedEndException(CallReportConstants.Q_STATE, e.getLocation());
    }

    private List<ApiCallDetailsRef> readCalls(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, CallReportParseException {
        assert (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_CALLS));
        ArrayList<ApiCallDetailsRef> res = new ArrayList<ApiCallDetailsRef>();
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_CALL_REF)) {
                int oldId = Integer.parseInt(e.asStartElement().getAttributeByName(CallReportConstants.Q_CALL_REF_ID).getValue());
                ApiCallDetailsRef newRef = this.callRestoreContext.getNewApiCallDetailsRef(oldId);
                if (newRef == null) {
                    LOG.warn("Could not retrieve ApiCallDetails with ref {}", (Object)oldId);
                }
                res.add(newRef);
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), CallReportConstants.Q_CALLS)) {
                return res;
            }
            this.logUnexpectedElement(CallReportConstants.Q_CALLS, e);
        }
        throw CallReportReader.createUnexpectedEndException(CallReportConstants.Q_CALLS, e.getLocation());
    }

    private List<LogOutput.LogEntry> readLogLines(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, CallReportParseException {
        assert (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_LOGENTRIES));
        ArrayList<LogOutput.LogEntry> res = new ArrayList<LogOutput.LogEntry>();
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_LOGENTRY)) {
                res.add(this.readLogLine(eventReader, e));
                continue;
            }
            if (e.isEndElement() && Objects.equals(e.asEndElement().getName(), CallReportConstants.Q_LOGENTRIES)) {
                return res;
            }
            this.logUnexpectedElement(CallReportConstants.Q_LOGENTRIES, e);
        }
        throw CallReportReader.createUnexpectedEndException(CallReportConstants.Q_LOGENTRIES, e.getLocation());
    }

    private LogOutput.LogEntry readLogLine(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, CallReportParseException {
        assert (e.isStartElement() && Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_LOGENTRY));
        LogOutput.LogLineType type = null;
        String text = null;
        long timeMs = 0L;
        String exception = null;
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_TYPE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at start", e.getLocation());
                    }
                    try {
                        type = LogOutput.LogLineType.valueOf((String)e.asCharacters().getData());
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new CallReportParseException("Could not parse the log line type correctly. Unexpected type: " + e.asCharacters().getData(), ex, e.getLocation());
                    }
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_TEXT)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at name", e.getLocation());
                    }
                    text = e.asCharacters().getData();
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_TIME_IN_MS)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at name", e.getLocation());
                    }
                    timeMs = Long.parseLong(e.asCharacters().getData());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), CallReportConstants.Q_EXCEPTION)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) {
                        throw new CallReportParseException("Expected characters at name", e.getLocation());
                    }
                    exception = e.asCharacters().getData();
                    continue;
                }
                this.logUnexpectedElement(CallReportConstants.Q_LOGENTRY, e);
                continue;
            }
            if (e.isEndElement()) {
                if (Objects.equals(e.asEndElement().getName(), CallReportConstants.Q_LOGENTRY)) {
                    return new LogOutput.LogEntry(type, text, timeMs, exception, false);
                }
                this.logUnexpectedElement(CallReportConstants.Q_LOGENTRY, e);
                continue;
            }
            this.logUnexpectedElement(CallReportConstants.Q_LOGENTRY, e);
        }
        throw CallReportReader.createUnexpectedEndException(CallReportConstants.Q_LOGENTRY, e.getLocation());
    }

    private static CallReportParseException createUnexpectedEndException(QName name, Location location) {
        return new CallReportParseException("Expected to encounter end-tag of " + name.getLocalPart() + ", but never found it before end of stream.", location);
    }

    private void logUnexpectedElement(QName parent, XMLEvent event) {
        if (event.isCharacters() && event.asCharacters().getData().trim().isEmpty()) {
            return;
        }
        if (event.isEndElement()) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            event.writeAsEncodedUnicode(stringWriter);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        String eventContents = stringWriter.toString().trim();
        LOG.warn("Encountered unexpected event {} ({}) while parsing {}@{}", new Object[]{event, eventContents, parent.getLocalPart(), event.getLocation()});
    }

    public static class CallReportParseException
    extends Exception {
        private final Location location;

        public CallReportParseException(Location location) {
            this.location = location;
        }

        public CallReportParseException(Throwable cause, Location location) {
            super(cause);
            this.location = location;
        }

        public CallReportParseException(String message, Location location) {
            super(message);
            this.location = location;
        }

        public CallReportParseException(String message, Throwable cause, Location location) {
            super(message, cause);
            this.location = location;
        }

        public CallReportParseException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Location location) {
            super(message, cause, enableSuppression, writableStackTrace);
            this.location = location;
        }
    }
}

