/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.TaskExecutionFinishedListener;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecutionFinishedCallback;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobReport;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractJob<V>
implements Job<V> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractJob.class);
    @Nonnull
    private final Marker jobMarker;
    @Nonnull
    private final String name;
    @Nonnull
    protected final Experiment experiment;
    @Nonnull
    protected final HighLevelTaskFactory hltf;
    @Nonnull
    private final TaskThread tt;
    private final ReadOnlyObjectWrapper<State> state = new ReadOnlyObjectWrapper();
    private final ReadOnlyStringWrapper message = new ReadOnlyStringWrapper();
    private final ObservableList<TaskExecution> taskExecutions = FXCollections.observableArrayList();
    private final List<TaskExecutionFinishedListener> taskExecutionFinishedListeners = new ArrayList<TaskExecutionFinishedListener>();
    @Nonnull
    private final JobReport jobReport;

    public AbstractJob(@Nonnull String name, @Nonnull Experiment experiment, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt) {
        this(JobReport::new, name, experiment, hltf, tt);
    }

    public AbstractJob(@Nonnull Function<AbstractJob<V>, JobReport> jobReportCreator, @Nonnull String name, @Nonnull Experiment experiment, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt) {
        this.jobReport = jobReportCreator.apply(this);
        this.name = name;
        this.experiment = experiment;
        this.hltf = hltf;
        this.tt = tt;
        this.jobMarker = MarkerFactory.getMarker((String)name);
    }

    @Nonnull
    public Collection<Task> getAlwaysDependsOn() {
        return Collections.emptyList();
    }

    @Nonnull
    public Collection<Task> getDependsOn() {
        return Collections.emptyList();
    }

    @Override
    public final V call() throws Exception {
        ArrayList<Task> tasksToExecute = new ArrayList<Task>();
        tasksToExecute.addAll(this.getAlwaysDependsOn());
        tasksToExecute.addAll(this.getDependsOn().stream().filter(Task::newExecutionNeeded).collect(Collectors.toList()));
        if (!tasksToExecute.isEmpty()) {
            CountDownLatch latch = new CountDownLatch(tasksToExecute.size());
            ArrayList<TaskExecution<Task>> taskExecutions = new ArrayList<TaskExecution<Task>>();
            for (Task task : tasksToExecute) {
                TaskExecution<Task> taskExecution = this.submitTask(task, (t, te, state) -> latch.countDown());
                taskExecutions.add(taskExecution);
            }
            latch.await();
            for (TaskExecution taskExecution : taskExecutions) {
                if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) continue;
                LOG.error(this.jobMarker, "Dependency {} has state {} instead of SUCCESS. Aborting this job!", (Object)taskExecution.getName(), (Object)taskExecution.getState());
                return null;
            }
        }
        this.jobReport.registerStart();
        V res = this.execute();
        this.jobReport.registerEnd();
        return res;
    }

    public abstract V execute() throws Exception;

    @Nonnull
    private <T extends Task> TaskExecutionFinishedCallback<T> createTaskExecutionFinishedCallbackForTask() {
        return (t, te, s) -> this.taskExecutionFinishedListeners.forEach(listener -> listener.onTaskExecutionFinished(te));
    }

    @Override
    @Nonnull
    public <T extends Task> TaskExecution<T> submitTask(@Nonnull T task, @Nonnull TaskExecutionFinishedCallback<T> callback) {
        ArrayList callbacks = new ArrayList();
        callbacks.add(callback);
        callbacks.add(this.createTaskExecutionFinishedCallbackForTask());
        TaskExecution<T> taskExecution = this.tt.addTask(task, callbacks);
        this.taskExecutions.add(taskExecution);
        return taskExecution;
    }

    @Override
    @Nonnull
    public <T extends Task> TaskExecution<T> submitTask(@Nonnull T task) {
        TaskExecution<T> taskExecution = this.tt.addTask(task, this.createTaskExecutionFinishedCallbackForTask());
        this.taskExecutions.add(taskExecution);
        return taskExecution;
    }

    @Override
    @Nonnull
    public <T extends Task> TaskExecution<T> submitTaskAndWait(@Nonnull T task) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        TaskExecution<T> taskExecution = this.submitTask(task, (t, te, state) -> latch.countDown());
        latch.await();
        return taskExecution;
    }

    protected void setAndRunState(@Nonnull State newState) throws JFedException, InterruptedException {
        this.state.set((Object)newState);
        newState.run(this);
    }

    @Override
    @Nullable
    public State getState() {
        return (State)this.state.get();
    }

    @Override
    @Nonnull
    public final ReadOnlyObjectProperty<State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    protected void updateMessage(@Nonnull String message) {
        Platform.runLater(() -> this.message.set(message));
    }

    @Override
    @Nonnull
    public final ReadOnlyStringProperty messageProperty() {
        return this.message.getReadOnlyProperty();
    }

    @Override
    @Nonnull
    public final String getMessage() {
        return this.message.get();
    }

    @Override
    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Nonnull
    public ObservableList<TaskExecution> getTaskExecutions() {
        return this.taskExecutions;
    }

    public void addTaskExecutionFinishedListener(@Nonnull TaskExecutionFinishedListener taskExecutionFinishedListener) {
        this.taskExecutionFinishedListeners.add(taskExecutionFinishedListener);
    }

    @Override
    @Nonnull
    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    @Nonnull
    public JobReport getJobReport() {
        return this.jobReport;
    }
}

