/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;

public abstract class MultipleCallState<T extends Task>
extends State {
    private final AbstractJob<?> job;
    protected final Map<T, TaskExecution<T>> taskExecutions = new HashMap<T, TaskExecution<T>>();

    protected MultipleCallState(String name, AbstractJob<?> job) {
        super(name);
        this.job = job;
    }

    @Override
    @Nonnull
    public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
        Collection<T> tasks = this.getTasks();
        CountDownLatch latch = new CountDownLatch(tasks.size());
        for (Task task : tasks) {
            TaskExecution<Task> taskExecution = this.job.submitTask(task, (t, te, s) -> {
                this.onTaskExecutionFinished(t, te, s);
                latch.countDown();
            });
            this.taskExecutions.put(task, taskExecution);
        }
        latch.await();
        this.onFinished();
        return ExperimentTaskStatus.SUCCESS;
    }

    protected void onTaskExecutionFinished(T task, TaskExecution<T> taskExecution, TaskExecution.TaskState state) {
    }

    protected void onFinished() {
    }

    public abstract Collection<T> getTasks();

    public Map<T, TaskExecution<T>> getTaskExecutions() {
        return Collections.unmodifiableMap(this.taskExecutions);
    }
}

