/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.SfaExperimentPartsSlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.NonSfaExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.RegisterSliversToSlaExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ProvisionSliversOnAuthorityState;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.ExpirationChecker;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisionExperimentJob
extends AbstractJob<Boolean> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(ProvisionExperimentJob.class);
    private final Logger LOG;
    private final JobStateFactory jobStateFactory;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final ExperimentPartControllerManager epcManager;
    private Boolean success = null;
    private Boolean expirationOK = null;

    public ProvisionExperimentJob(Experiment experiment, HighLevelTaskFactory hltf, TaskThread tt, JobStateFactory jobStateFactory, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, ExperimentPartControllerManager epcManager) {
        super("Provision Experiment " + experiment.getName(), experiment, hltf, tt);
        this.jobStateFactory = jobStateFactory;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.epcManager = epcManager;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, this.getJobReport());
        assert (experiment.getRequestedEndTime() != null);
    }

    @Override
    public Boolean execute() throws Exception {
        if (!this.hasSfaParts()) {
            if (this.experiment.getExperimentSpecification() != null) {
                this.experiment.getExperimentSpecificationLogger().firePostRSpecFail((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), "assert failed: experiment.getExperimentSpecification() == null", null);
                this.experiment.getExperimentSpecificationLogger().firePostRspecAll(false, Collections.emptyList());
            }
            return true;
        }
        this.LOG.debug("ProvisionExperimentJob started");
        ProvisionPartsState provisionPartsState = new ProvisionPartsState();
        this.setAndRunState(provisionPartsState);
        if (provisionPartsState.isPermanentFailure()) {
            this.LOG.debug("ProvisionExperimentJob stopped in failure");
            if (this.experiment.getExperimentSpecification() != null) {
                this.experiment.getExperimentSpecificationLogger().firePostRSpecFail((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), "ProvisionExperimentJob stopped in failure", null);
                this.experiment.getExperimentSpecificationLogger().firePostRspecAll(false, this.getExperimentClientIds());
            }
            this.success = false;
            return false;
        }
        this.expirationOK = !ExpirationChecker.isEarlyExpire(this.experiment);
        if (this.experiment.isRequestSla()) {
            RegisterSfaExperimentPartsToSlaCollectorState registerSliversToSlaState = new RegisterSfaExperimentPartsToSlaCollectorState();
            this.setAndRunState(registerSliversToSlaState);
        }
        this.LOG.debug("ProvisionExperimentJob stopped successfully");
        this.success = true;
        return true;
    }

    @Nonnull
    private List<String> getExperimentClientIds() {
        FXModelRspec model;
        if (this.experiment.getSliceOrNull() == null || this.experiment.getSliceOrNull().getRequestRspec() == null) {
            return Collections.emptyList();
        }
        RequestRspecSource requestRspecSource = this.experiment.getSliceOrNull().getRequestRspec();
        FXModelRspec fXModelRspec = model = requestRspecSource == null ? null : (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (model != null);
        if (model == null) {
            return Collections.emptyList();
        }
        return model.getNodes().stream().map(RspecNode::getClientId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public Boolean isExpirationOK() {
        return this.expirationOK;
    }

    private Collection<SfaExperimentPart> getSfaParts() {
        return this.experiment.getPartsStream().filter(part -> part instanceof SfaExperimentPart).map(SfaExperimentPart.class::cast).collect(Collectors.toList());
    }

    private Collection<NonSfaExperimentPartController> getNonSfaExperimentPartControllers() {
        HashSet<NonSfaExperimentPartController> controllers = new HashSet<NonSfaExperimentPartController>();
        for (ExperimentPart experimentPart : this.experiment.getPartsListCopy()) {
            if (experimentPart instanceof SfaExperimentPart) continue;
            ExperimentPartController epc = this.epcManager.getController(experimentPart);
            if (!(epc instanceof NonSfaExperimentPartController)) {
                throw new RuntimeException("Expected a non-sfa ExperimentPartController");
            }
            controllers.add((NonSfaExperimentPartController)epc);
        }
        return controllers;
    }

    private boolean hasNonSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> !(part instanceof SfaExperimentPart));
    }

    private boolean hasSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> part instanceof SfaExperimentPart);
    }

    public class ProvisionPartsState
    extends SlicedState<ProvisionSfaExperimentPartJobSlice> {
        private final List<ProvisionSfaExperimentPartJobSlice> slices;

        protected ProvisionPartsState() {
            super("Provision all ExperimentParts");
            this.slices = ProvisionExperimentJob.this.experiment.getPartsStream().filter(part -> part.getState() != InternalState.FAILED).filter(part -> part instanceof SfaExperimentPart).map(part -> new ProvisionSfaExperimentPartJobSlice((SfaExperimentPart)part)).collect(Collectors.toList());
        }

        public boolean isPermanentFailure() {
            for (ProvisionSfaExperimentPartJobSlice slice : this.slices) {
                if (slice.getResult() != ExperimentTaskStatus.FAILED) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<ProvisionSfaExperimentPartJobSlice> getSlices() {
            return this.slices;
        }
    }

    public class RegisterSfaExperimentPartsToSlaCollectorState
    extends SfaExperimentPartsSlicedState<RegisterSliversToSlaExperimentPartStateSlice> {
        private RegisterSfaExperimentPartsToSlaCollectorState() {
            super("Register resources at SLA Collector", ProvisionExperimentJob.this.getExperiment());
        }

        @Override
        public RegisterSliversToSlaExperimentPartStateSlice createJobSlice(SfaExperimentPart experimentPart) {
            return new RegisterSliversToSlaExperimentPartStateSlice(ProvisionExperimentJob.this, experimentPart, ProvisionExperimentJob.this.hltf);
        }
    }

    public class ProvisionSfaExperimentPartJobSlice
    extends ExperimentPartStateSlice<SfaExperimentPart> {
        public ProvisionSfaExperimentPartJobSlice(SfaExperimentPart experimentPart) {
            super(ProvisionExperimentJob.this, experimentPart);
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            if (!this.supportsAllocateProvision(((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority())) {
                ProvisionExperimentJob.this.LOG.debug("Skipping provisioning on {}, as it does not support it.", (Object)((SfaExperimentPart)this.experimentPart).getName());
                return ExperimentTaskStatus.SUCCESS;
            }
            ProvisionSliversOnAuthorityState provisionSliversOnAuthorityState = ProvisionExperimentJob.this.jobStateFactory.createProvisionSliversOnAuthorityState(ProvisionExperimentJob.this, (SfaExperimentPart)this.experimentPart, this.experiment.getUserSpecs());
            this.setAndRunState(provisionSliversOnAuthorityState);
            return provisionSliversOnAuthorityState.getStatus();
        }

        private boolean supportsAllocateProvision(Server auth) {
            AggregateManagerWrapper amWrapper = ProvisionExperimentJob.this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(auth);
            return amWrapper.hasSeperateAllocateAndProvision();
        }
    }
}

