/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleTaskJob;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterExperimentJob
extends SingleTaskJob<CreateSliceTask, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterExperimentJob.class);

    public RegisterExperimentJob(Experiment experiment, HighLevelTaskFactory hltf, TaskThread tt) {
        super("Register experiment " + experiment.getName(), experiment, hltf, tt);
    }

    @Override
    public CreateSliceTask createTask() {
        assert (this.experiment.getName() != null);
        assert (this.experiment.getSliceOrNull() == null);
        assert (this.experiment.getRequestedEndTime() != null);
        return this.hltf.createSlice(this.experiment.getName(), this.experiment.getSubAuthName(), this.experiment.getInitialShareWithUsers(), this.experiment.getRequestedEndTime());
    }

    @Override
    protected void onFinished(CreateSliceTask task, TaskExecution<CreateSliceTask> taskExecution) {
        LOG.info("RegisterExperimentJob onFinished task.getSlice()=={}", (Object)(task.getSlice() == null ? "null" : "non-null"));
        if (task.getSlice() == null && taskExecution.getException() instanceof JFedException) {
            JFedException ex = (JFedException)taskExecution.getException();
            if (ex.getXmlRpcReply() != null && ex.getXmlRpcReply().getOutput() != null && ex.getXmlRpcReply().getOutput().endsWith(" already a registered slice")) {
                LOG.warn("Detected that exception of register experiment is a duplicate slice error");
                this.updateMessage("Experiment name already in use. Restart the experiment with another name...");
            }
            Platform.runLater(() -> {
                LOG.error("Failed to register experiment -> setting experiment status to FAILED");
                this.experiment.setExperimentState(ExperimentState.FAILED);
            });
        } else {
            Platform.runLater(() -> {
                if (task.getSlice() == null || task.getSlice().getUrn() == null || taskExecution.getState() != TaskExecution.TaskState.SUCCESS) {
                    LOG.error("Something when wrong with the CreateSliceTask -> setting experiment status to FAILED");
                    this.experiment.setExperimentState(ExperimentState.FAILED);
                } else {
                    this.experiment.registerSlice(task.getSlice());
                    this.experiment.setExperimentState(ExperimentState.CREATED);
                }
            });
        }
    }
}

