/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ReloadOSTask;

public class ReloadOSJob
extends AbstractJob<Void> {
    private final Sliver sliver;
    private final JobStateFactory jobStateFactory;

    public ReloadOSJob(Experiment experiment, Sliver sliver, HighLevelTaskFactory hltf, TaskThread tt, JobStateFactory jobStateFactory) {
        super(String.format("Reload sliver %s", sliver.getUrn()), experiment, hltf, tt);
        this.sliver = sliver;
        this.jobStateFactory = jobStateFactory;
    }

    @Override
    public Void execute() throws Exception {
        ReloadOSState reloadOSState = new ReloadOSState();
        this.setAndRunState(reloadOSState);
        if (reloadOSState.getStatus() == ExperimentTaskStatus.SUCCESS) {
            ExperimentPart part = this.experiment.getPart(this.sliver);
            if (!(part instanceof SfaExperimentPart)) {
                throw new UnsupportedOperationException("Can only reload OS on SfaExperimentPart!");
            }
            this.setAndRunState(this.jobStateFactory.createGetStatusUntilReadyOrFailTaskState(this, LOG, this.experiment.getCheckReadyInterval(), this.experiment.getMaxWaitUntilReady(), (SfaExperimentPart)part, DesiredStatus.GENI_READY));
        } else {
            this.updateMessage(String.format("Reloading sliver '%s' failed.", this.sliver.getUrn()));
        }
        return null;
    }

    private class ReloadOSState
    extends SingleCallState<ReloadOSTask> {
        protected ReloadOSState() {
            super(String.format("Reload sliver %s", ReloadOSJob.this.sliver.getUrnString()), ReloadOSJob.this.hltf.reloadOS(ReloadOSJob.this.sliver));
        }
    }
}

