/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartsSlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.UnknownAuthorityException;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.AggregatesForSliceTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreExperimentJob
extends AbstractJob<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreExperimentJob.class);
    private final JFedPreferences jFedPreferences;
    private final AuthorityFinder authorityFinder;
    private final JobStateFactory jobStateFactory;
    private final ExperimentPartControllerManager epcManager;

    public RestoreExperimentJob(Experiment experiment, JFedPreferences jFedPreferences, HighLevelTaskFactory hltf, TaskThread tt, AuthorityFinder authorityFinder, JobStateFactory jobStateFactory, ExperimentPartControllerManager epcManager) {
        super("Restore Experiment", experiment, hltf, tt);
        this.jFedPreferences = jFedPreferences;
        this.authorityFinder = authorityFinder;
        this.jobStateFactory = jobStateFactory;
        this.epcManager = epcManager;
    }

    @Override
    public Void execute() throws Exception {
        if (!this.hasSufficientSliceInformation()) {
            FetchSliceInfoState fetchSliceInfoState = new FetchSliceInfoState();
            this.setAndRunState(fetchSliceInfoState);
            assert (fetchSliceInfoState.getTaskExecution().isCompleted());
            if (fetchSliceInfoState.getTaskExecution().getState() == TaskExecution.TaskState.SUCCESS) {
                assert (this.experiment.getSliceOrNull().getExpirationDate() != null);
                if (this.experiment.getSliceOrNull().getExpirationDate().isBefore(Instant.now())) {
                    this.experiment.setExperimentState(ExperimentState.EXPIRED);
                    return null;
                }
            } else {
                return null;
            }
        }
        assert (this.hasSufficientSliceInformation());
        this.setAndRunState(new PopulateExperimentPartsState());
        LOG.debug("There are " + this.experiment.getPartsSize() + " experiment parts.");
        RestoreExperimentPartsSlicedState restoreExperimentPartsState = new RestoreExperimentPartsSlicedState();
        this.setAndRunState(restoreExperimentPartsState);
        if (this.experiment.getNewRequestRspecSource() != null) {
            this.experiment.setExperimentState(ExperimentState.RENEW_EXISTING);
        } else {
            this.experiment.setExperimentState(ExperimentState.RESTORED);
        }
        return null;
    }

    private boolean hasSufficientSliceInformation() {
        return this.experiment.getSliceOrNull().getExpirationDate() != null;
    }

    private class FetchSliceInfoState
    extends SingleCallState<AggregatesForSliceTask> {
        public FetchSliceInfoState() {
            super("Requesting experiment information", RestoreExperimentJob.this.hltf.getAggregatesForSlice(RestoreExperimentJob.this.experiment.getSliceOrNull()));
        }
    }

    private class PopulateExperimentPartsState
    extends State {
        protected PopulateExperimentPartsState() {
            super("Processing experiment information");
        }

        @Override
        @Nonnull
        public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            LOG.debug("PopulateExperimentPartsState starts with {} experiment parts", (Object)RestoreExperimentJob.this.experiment.getPartsSize());
            if (RestoreExperimentJob.this.experiment.getExistingRequestRspecSource() == null) {
                LOG.info("No (additional) slivers to restore as there is no existingRequestRspecSource for this experiment!");
                return ExperimentTaskStatus.WARNING;
            }
            if (!RestoreExperimentJob.this.experiment.getSliceOrNull().getConnectAuthorities().isEmpty()) {
                LOG.debug("Retrieving SfaExperimentParts from " + RestoreExperimentJob.this.experiment.getSliceOrNull().getConnectAuthorities().size() + " ConnectAuthorities");
                for (Server connectAuth : RestoreExperimentJob.this.experiment.getSliceOrNull().getConnectAuthorities()) {
                    if (RestoreExperimentJob.this.experiment.getPart(connectAuth) != null) continue;
                    RestoreExperimentJob.this.experiment.addExperimentPart(new SfaExperimentPart(RestoreExperimentJob.this.experiment, connectAuth, connectAuth));
                }
            } else {
                LOG.debug("Falling back to retrieving SfaExperimentParts from Request/Manifest Rspec");
                assert (RestoreExperimentJob.this.experiment.getExistingRequestRspecSource().getStringRspec().isWellFormed());
                LOG.debug("  CM urns in ExistingRequestRspecSource: " + RestoreExperimentJob.this.experiment.getExistingRequestRspecSource().getAllComponentManagerUrns());
                HashSet<TargetAuthority> authorities = new HashSet<TargetAuthority>();
                for (GeniUrn componentManagerUrn : RestoreExperimentJob.this.experiment.getExistingRequestRspecSource().getAllComponentManagerUrns()) {
                    String prefenceRecoverExoSM = RestoreExperimentJob.this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD).trim().toLowerCase();
                    Server sfaAuthorityToConnect = Objects.equals(prefenceRecoverExoSM, "single") ? RestoreExperimentJob.this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.RECOVER) : RestoreExperimentJob.this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.RECOVER_BOTH_FIRST);
                    Server sfaAuthorityForRspec = RestoreExperimentJob.this.authorityFinder.findByAnyUrn(componentManagerUrn, AuthorityFinder.Purpose.REQUEST_RSPEC);
                    if (sfaAuthorityToConnect == null) {
                        LOG.error("ERROR: Component Manager Urn in Request RSpec unknown (serverToConnect=null): \"" + componentManagerUrn + "\".");
                        throw new UnknownAuthorityException(componentManagerUrn);
                    }
                    if (sfaAuthorityForRspec == null) {
                        LOG.error("ERROR: Component Manager Urn in Request RSpec unknown (serverForRspecComponentManager=null): \"" + componentManagerUrn + "\".");
                        throw new UnknownAuthorityException(componentManagerUrn);
                    }
                    if (sfaAuthorityToConnect.isEdgeVlan()) continue;
                    authorities.add(new TargetAuthority(componentManagerUrn, sfaAuthorityForRspec, sfaAuthorityToConnect));
                    boolean isCentralBrokerTestbed = sfaAuthorityToConnect.hasFlag(Server.Flag.centralBrokerArchitectureBrokerauth) || sfaAuthorityToConnect.hasFlag(Server.Flag.centralBrokerArchitectureSubauth);
                    if (!isCentralBrokerTestbed) continue;
                    Server secondSfaAuthorityToConnect = RestoreExperimentJob.this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.RECOVER_BOTH_SECOND);
                    if (secondSfaAuthorityToConnect == null) {
                        LOG.error("ERROR: Component Manager Urn in Request RSpec unknown (secondSfaAuthorityToConnect=null): \"" + componentManagerUrn + "\".");
                        throw new UnknownAuthorityException(componentManagerUrn);
                    }
                    if (sfaAuthorityToConnect.isEdgeVlan()) continue;
                    authorities.add(new TargetAuthority(componentManagerUrn, sfaAuthorityForRspec, secondSfaAuthorityToConnect));
                }
                if (!authorities.isEmpty()) {
                    for (TargetAuthority auth : authorities) {
                        if (RestoreExperimentJob.this.experiment.getPart(auth.getServerToConnect()) == null) {
                            RestoreExperimentJob.this.experiment.addExperimentPart(new SfaExperimentPart(RestoreExperimentJob.this.experiment, auth.getServerToConnect(), auth.getServerForRspecComponentManager()));
                            continue;
                        }
                        LOG.debug("An ExperimentPart already exists for authority {}", (Object)auth);
                    }
                } else {
                    LOG.debug("No additional authorities to contact");
                }
            }
            LOG.debug("PopulateExperimentPartsState finishes with {} experiment parts", (Object)RestoreExperimentJob.this.experiment.getPartsSize());
            return ExperimentTaskStatus.SUCCESS;
        }
    }

    private class RestoreExperimentPartsSlicedState
    extends ExperimentPartsSlicedState<ExperimentPartStateSlice> {
        protected RestoreExperimentPartsSlicedState() {
            super(String.format("Requesting experiment information about %s from authorities ", RestoreExperimentJob.this.experiment.getName()), RestoreExperimentJob.this.experiment, RestoreExperimentJob.this.epcManager);
        }

        @Override
        public <EP extends ExperimentPart> ExperimentPartStateSlice createJobSlice(ExperimentPartController<EP> controller, EP experimentPart) {
            return controller.restore(RestoreExperimentJob.this, experimentPart);
        }
    }
}

