/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.WaitForOpStatusExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.NonSfaExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.states.DistributeSshKeysState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExecuteAnsibleServicesState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ShareLanAtAuthorityPartState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.WaitForExecuteFinishedState;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupSoftwareExperimentJob
extends JobWithSshConnectionManager<Boolean> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(SetupSoftwareExperimentJob.class);
    private final Logger LOG;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final ExperimentPartControllerManager epcManager;
    @Nullable
    private final ESpecStep startPosition;
    @Nullable
    private final ESpecStep stopPosition;
    private final boolean runAll;
    private Boolean success = null;

    public SetupSoftwareExperimentJob(@Nonnull Experiment experiment, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt, @Nonnull JobStateFactory jobStateFactory, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull ExperimentPartControllerManager epcManager, @Nonnull ProxySocketFactoryProvider proxySocketFactoryProvider, @Nonnull GeniUserProvider geniUserProvider, @Nullable ESpecStep startPosition, @Nullable ESpecStep stopPosition) {
        super("Setup Software for Experiment " + experiment.getName(), experiment, hltf, tt, jobStateFactory, proxySocketFactoryProvider, geniUserProvider);
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.epcManager = epcManager;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, this.getJobReport());
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.runAll = startPosition == null && stopPosition == null;
    }

    @Nullable
    public ESpecStep getStartPosition() {
        return this.startPosition;
    }

    @Nullable
    public ESpecStep getStopPosition() {
        return this.stopPosition;
    }

    public boolean isRunAll() {
        return this.runAll;
    }

    @Override
    public Boolean execute() throws Exception {
        if (!this.hasSfaParts()) {
            if (this.experiment.getExperimentSpecification() != null) {
                this.experiment.getExperimentSpecificationLogger().firePostRSpecFail((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), "assert failed: experiment.getExperimentSpecification() == null", null);
                this.experiment.getExperimentSpecificationLogger().firePostRspecAll(false, Collections.emptyList());
            }
            return true;
        }
        this.LOG.debug("SetupSoftwareExperimentJob started");
        if (this.experiment.getSliceOrNull() == null || this.experiment.getSlice().getRequestRspec() == null || this.experiment.getSlice().getRequestRspec().getImmutableModelRspec() == null) {
            this.LOG.warn("Problem with experiment.getSlice().getRequestRspec(). Will assume this is normal and ABORT software setup.");
            if (this.experiment.getExperimentSpecification() != null) {
                this.experiment.getExperimentSpecificationLogger().firePostRSpecSuccess((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0));
                this.experiment.getExperimentSpecificationLogger().firePostRspecAll(true, this.getExperimentClientIds());
            }
            this.success = true;
            return true;
        }
        if (this.runAll) {
            boolean hasAutoShareLans = false;
            List links = this.experiment.getSlice().getRequestRspec().getImmutableModelRspec().getLinks();
            for (RspecLink link : links) {
                List autoShareLanNames = link.getAutoShareLanNames();
                if (autoShareLanNames == null || autoShareLanNames.isEmpty()) continue;
                hasAutoShareLans = true;
                break;
            }
            if (hasAutoShareLans) {
                this.LOG.info("Experiment has auto shared LANs. Will share them.");
                AutoShareLanPartsState autoShareLanPartsState = new AutoShareLanPartsState();
                this.setAndRunState(autoShareLanPartsState);
                if (autoShareLanPartsState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                    this.LOG.info("Failure sharing LANs");
                    if (this.experiment.getExperimentSpecification() != null) {
                        this.experiment.getExperimentSpecificationLogger().firePostRSpecFail((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), "Failure sharing LANs", null);
                        this.experiment.getExperimentSpecificationLogger().firePostRspecAll(false, this.getExperimentClientIds());
                    }
                    this.success = false;
                    return false;
                }
                this.LOG.debug("Experiment auto shared LANs have been shared. Will wait for ready again.");
                WaitForOpStatusExperimentJob.UpdateSfaPartsUntilTargetOpStatus updateUntilReadyState2 = new WaitForOpStatusExperimentJob.UpdateSfaPartsUntilTargetOpStatus(this.jobStateFactory, this, this.LOG, DesiredStatus.GENI_READY);
                this.setAndRunState(updateUntilReadyState2);
                if (updateUntilReadyState2.isPermanentFailure()) {
                    this.LOG.info("WaitForPartsReadyState (after auto shared LANs) reported permanent failure");
                    if (this.experiment.getExperimentSpecification() != null) {
                        this.experiment.getExperimentSpecificationLogger().firePostRSpecFail((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), "WaitForPartsReadyState (after auto shared LANs) reported permanent failure", null);
                        this.experiment.getExperimentSpecificationLogger().firePostRspecAll(false, this.getExperimentClientIds());
                    }
                    this.success = false;
                    return false;
                }
                this.LOG.debug("All is ready after sharing LANs");
            } else {
                this.LOG.debug("Experiment has NO auto shared LANs");
            }
            if (!this.experiment.getKeypairs().isEmpty() && DistributeSshKeysState.hasDistributeSshKeyPair(this.experiment)) {
                this.LOG.debug("Experiment requires a distributed keypair. Will generate and distribute it.");
                this.setAndRunSshUsingState(this.jobStateFactory.createDistributeSshKeysState(this));
            } else {
                this.LOG.debug("Experiment does not require a distributed keypair.");
            }
            if (WaitForExecuteFinishedState.hasWaitForExecute(this.experiment)) {
                this.LOG.debug("Experiment requires waiting for some server executes to finish.");
                this.setAndRunSshUsingState(this.jobStateFactory.createWaitForExecuteFinishedState(this));
            } else {
                this.LOG.debug("Experiment does not require waiting for server execute.");
            }
            if (ExecuteAnsibleServicesState.hasAnsibleServices(this.experiment)) {
                this.LOG.debug("Experiment requires executing ansible scripts.");
                this.setAndRunSshUsingState(this.jobStateFactory.createExecuteAnsibleServicesState(this));
            } else {
                this.LOG.debug("Experiment does not require executing ansible scripts.");
            }
        }
        if (this.experiment.getExperimentSpecification() != null) {
            this.LOG.info("Experiment run with ExperimentSpecification. Will now start its dir, upload and execute phases.");
            this.experiment.getExperimentSpecificationLogger().firePostRSpecSuccess((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0));
            this.experiment.getExperimentSpecificationLogger().firePostRspecAll(true, this.getExperimentClientIds());
            List<State> states = this.jobStateFactory.createOrderedExperimentServicesStates(this);
            for (State state : states) {
                this.setAndRunSshUsingState(state);
                if (state.getStatus() == ExperimentTaskStatus.SUCCESS) continue;
                this.LOG.info("Experiment run without ExperimentSpecification. Problem in ESpec phase {} (msg={}), got status={}. Will abort in failure.", new Object[]{state.getName(), state.getMessage(), state.getStatus()});
                this.experiment.getExperimentSpecificationLogger().firePostExecuteAll(false);
                this.success = false;
                return false;
            }
            this.experiment.getExperimentSpecificationLogger().firePostExecuteAll(true);
        } else {
            this.LOG.info("Experiment run without ExperimentSpecification.");
        }
        this.LOG.debug("SetupSoftwareExperimentJob stopped successfully");
        this.success = true;
        return true;
    }

    @Nonnull
    private List<String> getExperimentClientIds() {
        FXModelRspec model;
        if (this.experiment.getSliceOrNull() == null || this.experiment.getSliceOrNull().getRequestRspec() == null) {
            return Collections.emptyList();
        }
        RequestRspecSource requestRspecSource = this.experiment.getSliceOrNull().getRequestRspec();
        FXModelRspec fXModelRspec = model = requestRspecSource == null ? null : (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (model != null);
        if (model == null) {
            return Collections.emptyList();
        }
        return model.getNodes().stream().map(RspecNode::getClientId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Boolean isSuccess() {
        return this.success;
    }

    private Collection<SfaExperimentPart> getSfaParts() {
        return this.experiment.getPartsStream().filter(part -> part instanceof SfaExperimentPart).map(SfaExperimentPart.class::cast).collect(Collectors.toList());
    }

    private Collection<NonSfaExperimentPartController> getNonSfaExperimentPartControllers() {
        HashSet<NonSfaExperimentPartController> controllers = new HashSet<NonSfaExperimentPartController>();
        for (ExperimentPart experimentPart : this.experiment.getPartsListCopy()) {
            if (experimentPart instanceof SfaExperimentPart) continue;
            ExperimentPartController epc = this.epcManager.getController(experimentPart);
            if (!(epc instanceof NonSfaExperimentPartController)) {
                throw new RuntimeException("Expected a non-sfa ExperimentPartController");
            }
            controllers.add((NonSfaExperimentPartController)epc);
        }
        return controllers;
    }

    private boolean hasNonSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> !(part instanceof SfaExperimentPart));
    }

    private boolean hasSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> part instanceof SfaExperimentPart);
    }

    public class AutoShareLanPartsState
    extends SlicedState<AutoShareLanPartStateSlice> {
        private final List<AutoShareLanPartStateSlice> slices;

        protected AutoShareLanPartsState() {
            super("Auto Sharing LANs in all ExperimentParts");
            this.slices = new ArrayList<AutoShareLanPartStateSlice>();
            List sfaExperimentParts = SetupSoftwareExperimentJob.this.experiment.getPartsStream().filter(part -> part.getState() != InternalState.FAILED).filter(part -> part instanceof SfaExperimentPart).map(part -> (SfaExperimentPart)part).collect(Collectors.toList());
            SetupSoftwareExperimentJob.this.experiment.requireSlice();
            if (SetupSoftwareExperimentJob.this.experiment.getSlice().getRequestRspec() == null) {
                throw new IllegalStateException("experiment.getSlice().getRequestRspec() is null which is not supposed to occur in this state");
            }
            if (SetupSoftwareExperimentJob.this.experiment.getSlice().getRequestRspec().getImmutableModelRspec() == null) {
                throw new IllegalStateException("experiment.getSlice().getRequestRspec().getModelRspec() is null which is not supposed to occur in this state");
            }
            if (SetupSoftwareExperimentJob.this.experiment.getSlice().getRequestRspec().getImmutableModelRspec().getLinks() == null) {
                throw new IllegalStateException("experiment.getSlice().getRequestRspec().getModelRspec().getLinks() is null which is not supposed to occur in this state");
            }
            List links = SetupSoftwareExperimentJob.this.experiment.getSlice().getRequestRspec().getImmutableModelRspec().getLinks();
            for (SfaExperimentPart sfaExperimentPart : sfaExperimentParts) {
                Server auth = sfaExperimentPart.getConnectSfaAuthority();
                boolean hasAutoShareLans = false;
                for (RspecLink link : links) {
                    List autoShareLanNames = link.getAutoShareLanNames();
                    if (autoShareLanNames == null || autoShareLanNames.isEmpty() || !link.getComponentManagerUrns().contains(auth.getDefaultComponentManagerAsGeniUrn())) continue;
                    hasAutoShareLans = true;
                    break;
                }
                if (hasAutoShareLans) {
                    SetupSoftwareExperimentJob.this.LOG.debug("Auto Sharing LAN(s) in " + auth.getName());
                    AutoShareLanPartStateSlice slice = new AutoShareLanPartStateSlice(sfaExperimentPart);
                    this.slices.add(slice);
                    continue;
                }
                SetupSoftwareExperimentJob.this.LOG.debug("No Auto Shared LAN  in " + auth.getName());
            }
            SetupSoftwareExperimentJob.this.LOG.debug("AutoShareLanPartsState constructor finished with " + this.slices.size() + " slices.");
            assert (!this.slices.isEmpty());
        }

        @Override
        public Collection<AutoShareLanPartStateSlice> getSlices() {
            return this.slices;
        }
    }

    public class AutoShareLanPartStateSlice
    extends ExperimentPartStateSlice<SfaExperimentPart> {
        public AutoShareLanPartStateSlice(SfaExperimentPart experimentPart) {
            super(SetupSoftwareExperimentJob.this, experimentPart);
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            if (!this.supportsShareLan(((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority())) {
                SetupSoftwareExperimentJob.this.LOG.warn("Share LAN on {} is not supported. Will try anyway.", (Object)((SfaExperimentPart)this.experimentPart).getName());
            }
            this.experiment.requireSlice();
            if (this.experiment.getSlice().getRequestRspec() == null) {
                throw new IllegalStateException("experiment.getSlice().getRequestRspec() is null which is not supposed to occur in this state");
            }
            if (this.experiment.getSlice().getRequestRspec().getImmutableModelRspec() == null) {
                throw new IllegalStateException("experiment.getSlice().getRequestRspec().getModelRspec() is null which is not supposed to occur in this state");
            }
            if (this.experiment.getSlice().getRequestRspec().getImmutableModelRspec().getLinks() == null) {
                throw new IllegalStateException("experiment.getSlice().getRequestRspec().getModelRspec().getLinks() is null which is not supposed to occur in this state");
            }
            List links = this.experiment.getSlice().getRequestRspec().getImmutableModelRspec().getLinks();
            ExperimentTaskStatus worstStatus = null;
            Server auth = ((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority();
            SetupSoftwareExperimentJob.this.LOG.debug("Start sharing LAN(s) on " + auth.getDefaultComponentManagerAsGeniUrn());
            for (RspecLink link : links) {
                List autoShareLanNames = link.getAutoShareLanNames();
                if (autoShareLanNames == null || autoShareLanNames.isEmpty() || !link.getComponentManagerUrns().contains(auth.getDefaultComponentManagerAsGeniUrn())) continue;
                String sharedLanName = (String)autoShareLanNames.get(0);
                if (autoShareLanNames.size() > 1) {
                    SetupSoftwareExperimentJob.this.LOG.warn("There is more than one auto share LAN name per link (for link\"" + link.getClientId() + "\"), ignoring all but first.");
                }
                SetupSoftwareExperimentJob.this.LOG.debug("Sharing LAN " + link.getClientId() + " as " + sharedLanName + " on " + auth.getDefaultComponentManagerAsGeniUrn());
                ShareLanAtAuthorityPartState shareLanState = SetupSoftwareExperimentJob.this.jobStateFactory.createShareLanState(SetupSoftwareExperimentJob.this, (SfaExperimentPart)this.experimentPart, link.getClientId(), sharedLanName);
                this.setAndRunState(shareLanState);
                ExperimentTaskStatus status = shareLanState.getStatus();
                SetupSoftwareExperimentJob.this.LOG.debug("Shared LAN " + link.getClientId() + " as " + sharedLanName + " on " + auth.getDefaultComponentManagerUrn() + " -> status = " + status);
                if (status == ExperimentTaskStatus.SUCCESS && worstStatus != null) continue;
                worstStatus = status;
            }
            assert (worstStatus != null);
            SetupSoftwareExperimentJob.this.LOG.debug("Stopped sharing LAN(s) on " + auth.getDefaultComponentManagerUrn() + " -> worst status = " + worstStatus);
            return worstStatus;
        }

        private boolean supportsShareLan(Server auth) {
            AggregateManagerWrapper amWrapper = SetupSoftwareExperimentJob.this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(auth);
            return amWrapper.isShareLanSupported();
        }
    }
}

