/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ShareLanJob
extends AbstractJob<Void> {
    @Nonnull
    private final FXRspecLink link;
    @Nonnull
    private final String sharedLanName;
    private final boolean share;
    private final AuthorityFinder authorityFinder;

    public ShareLanJob(Experiment experiment, @Nonnull FXRspecLink link, @Nonnull String sharedLanName, boolean share, HighLevelTaskFactory hltf, TaskThread tt, AuthorityFinder authorityFinder) {
        super((share ? "Sharing" : "Unsharing") + " link " + link.getClientId() + " with ID '" + sharedLanName + "'", experiment, hltf, tt);
        this.link = link;
        this.sharedLanName = sharedLanName;
        this.share = share;
        this.authorityFinder = authorityFinder;
    }

    @Override
    public Void execute() throws Exception {
        Set servers = this.link.getComponentManagerUrns().stream().map(u -> this.authorityFinder.findByUrn(u, AuthorityFinder.Purpose.CREATE_SLIVER)).collect(Collectors.toSet());
        for (Server server : servers) {
            ShareLanState shareLanState = new ShareLanState(this.share, server);
            this.setAndRunState(shareLanState);
        }
        return null;
    }

    private class ShareLanState
    extends SingleCallState<Task> {
        protected ShareLanState(boolean share, Server server) {
            super(String.format((share ? "S" : "Uns") + "hare LAN at %s", server.getDefaultComponentManagerUrn()), share ? ShareLanJob.this.hltf.getShareLanTask(ShareLanJob.this.experiment.getSliceOrNull(), server, ShareLanJob.this.link.getClientId(), ShareLanJob.this.sharedLanName) : ShareLanJob.this.hltf.getUnshareLanTask(ShareLanJob.this.experiment.getSliceOrNull(), server, ShareLanJob.this.link.getClientId(), ShareLanJob.this.sharedLanName));
        }
    }
}

