/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSliceThread;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class SlicedState<S extends StateSlice>
extends State {
    protected SlicedState(String name) {
        super(name);
    }

    @Override
    @Nonnull
    protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
        Collection<S> jobSlices = this.getSlices();
        List<StateSliceThread> threads = jobSlices.stream().map(ss -> new StateSliceThread<StateSlice>((StateSlice)ss, this.getName())).collect(Collectors.toList());
        threads.forEach(Thread::start);
        for (StateSliceThread thread : threads) {
            thread.join();
        }
        boolean allSuccess = true;
        boolean allFailed = true;
        for (StateSliceThread thread : threads) {
            if (thread.getResult() != ExperimentTaskStatus.SUCCESS) {
                allSuccess = false;
            }
            if (thread.getResult() == ExperimentTaskStatus.FAILED) continue;
            allFailed = false;
        }
        if (allSuccess) {
            return ExperimentTaskStatus.SUCCESS;
        }
        if (allFailed) {
            return ExperimentTaskStatus.FAILED;
        }
        return ExperimentTaskStatus.WARNING;
    }

    public abstract Collection<S> getSlices();
}

