/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.StateFinishedListener;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class State {
    private static final Logger LOG = LoggerFactory.getLogger(State.class);
    @Nonnull
    private final String name;
    private final ReadOnlyStringWrapper message = new ReadOnlyStringWrapper();
    private final ReadOnlyObjectWrapper<ExperimentTaskStatus> status = new ReadOnlyObjectWrapper((Object)ExperimentTaskStatus.INACTIVE);
    private final List<StateFinishedListener<? extends State>> stateFinishedListeners = new ArrayList<StateFinishedListener<? extends State>>();

    protected State(@Nonnull String name) {
        this.name = name;
    }

    public final ExperimentTaskStatus run(Job<?> job) throws InterruptedException {
        ExperimentTaskStatus finalStatus;
        this.updateStatus(ExperimentTaskStatus.BUSY);
        try {
            finalStatus = this.executeState(job);
        }
        catch (InterruptedException e) {
            ExperimentTaskStatus finalStatus2 = ExperimentTaskStatus.FAILED;
            throw e;
        }
        catch (JFedException | AssertionError e) {
            finalStatus = ExperimentTaskStatus.FAILED;
            LOG.error("Exception while executing {}: {}", new Object[]{this.getName(), ((Throwable)e).getMessage(), e});
        }
        assert (finalStatus == ExperimentTaskStatus.SUCCESS || finalStatus == ExperimentTaskStatus.WARNING || finalStatus == ExperimentTaskStatus.FAILED) : "Unexpected final status";
        this.updateStatus(finalStatus);
        for (StateFinishedListener<? extends State> sfl : this.stateFinishedListeners) {
            try {
                sfl.onStateFinished(this);
            }
            catch (RuntimeException ex) {
                LOG.error("Runtime Exception while executing StateFinishedListener: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        return finalStatus;
    }

    @Nonnull
    protected abstract ExperimentTaskStatus executeState(Job<?> var1) throws InterruptedException, JFedException;

    @Nonnull
    public final String getName() {
        return this.name;
    }

    public final String getMessage() {
        return this.message.get();
    }

    public final ReadOnlyStringProperty messageProperty() {
        return this.message.getReadOnlyProperty();
    }

    private void updateStatus(@Nonnull ExperimentTaskStatus newStatus) {
        FutureTask<Object> updateStatusFuture = new FutureTask<Object>(() -> this.status.set((Object)newStatus), null);
        Platform.runLater(updateStatusFuture);
        try {
            updateStatusFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Error while changing status of state", (Throwable)e);
        }
    }

    protected void updateMessage(String message) {
        Platform.runLater(() -> this.message.set(message));
    }

    public final ExperimentTaskStatus getStatus() {
        return (ExperimentTaskStatus)((Object)this.status.get());
    }

    public final ReadOnlyObjectProperty<ExperimentTaskStatus> statusProperty() {
        return this.status.getReadOnlyProperty();
    }

    public void registerStateFinishedListener(StateFinishedListener<?> stateFinishedListener) {
        this.stateFinishedListeners.add(stateFinishedListener);
    }
}

