/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.Objects;
import java.util.concurrent.Callable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateSlice
implements Callable<ExperimentTaskStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(StateSlice.class);
    protected final Job<?> job;
    protected final Experiment experiment;
    private final ReadOnlyObjectWrapper<State> state = new ReadOnlyObjectWrapper();
    private ExperimentTaskStatus result = null;

    protected StateSlice(@Nonnull Job<?> job) {
        Objects.nonNull(job);
        this.job = job;
        this.experiment = job.getExperiment();
    }

    public abstract String getName();

    @Override
    public ExperimentTaskStatus call() {
        try {
            this.result = this.statefulRun();
        }
        catch (Exception e) {
            this.result = ExperimentTaskStatus.FAILED;
            LOG.error("UNCAUGHT exception in {}: {}", new Object[]{this.getClass().getName(), e.getMessage(), e});
        }
        return this.result;
    }

    public abstract ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException;

    protected void setAndRunState(State newState) throws JFedException, InterruptedException {
        this.state.set((Object)newState);
        newState.run(this.job);
    }

    public State getState() {
        return (State)this.state.get();
    }

    public ReadOnlyObjectProperty<State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public ExperimentTaskStatus getResult() {
        return this.result;
    }
}

