/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXLinkSetting;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLinksJob
extends JobWithSshConnectionManager<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(TestLinksJob.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private final JFedPreferences jFedPreferences;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final ProxyServiceUtil proxyServiceUtil;
    private final List<FXRspecNode> failedNodes = Collections.synchronizedList(new ArrayList());

    public TestLinksJob(@Nonnull Experiment experiment, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull ProxyPreferencesManager proxyPreferencesManager, @Nonnull ProxyServiceUtil proxyServiceUtil, @Nonnull JobStateFactory jobStateFactory, @Nonnull ProxySocketFactoryProvider proxySocketFactoryProvider) {
        super("Testing Links between Resources", experiment, hltf, tt, jobStateFactory, proxySocketFactoryProvider, geniUserProvider);
        this.jFedPreferences = jFedPreferences;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.proxyServiceUtil = proxyServiceUtil;
    }

    @Override
    public Boolean execute() throws Exception {
        LOG.trace("Starting connectivity tests to existing resources in experiment {}", (Object)this.experiment.getName());
        TestLinksExperimentPartsState tcs = new TestLinksExperimentPartsState();
        this.setAndRunSshUsingState(tcs);
        this.closeAllSshConnections();
        return tcs.getStatus() == ExperimentTaskStatus.SUCCESS;
    }

    @Nonnull
    public Collection<FXRspecNode> findTestableResources(@Nonnull ExperimentPart experimentPart) {
        HashMap<String, FXRspecNode> nodesOfAuthorityWithLoginService = new HashMap<String, FXRspecNode>();
        HashSet<String> nodeIdsWithoutLoginService = new HashSet<String>();
        if (!(experimentPart instanceof SfaExperimentPart)) {
            LOG.debug("Currently no support for connectivity testing of {}", (Object)experimentPart.getClass().getName());
            return Collections.emptyList();
        }
        SfaExperimentPart sfaExperimentPart = (SfaExperimentPart)experimentPart;
        for (Sliver sliver : sfaExperimentPart.getSlivers()) {
            if (sliver.isFake() || sliver.isVirtual()) continue;
            if (sliver.getStatus().getGlobalStatus() != StatusDetails.SliverStatus.READY) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Cannot start connectivity test to {} as sliver {} is not READY", (Object)experimentPart.getName(), (Object)sliver.getUrn());
                continue;
            }
            if (sliver.getManifestRspec() == null) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Cannot start connectivity test to {} as manifest is not available for sliver {}", (Object)experimentPart.getName(), (Object)sliver.getUrn());
                continue;
            }
            FXModelRspec modelRspec = (FXModelRspec)sliver.getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
            assert (modelRspec != null);
            List nodes = modelRspec.getNodesByAuthority(sfaExperimentPart.getConnectSfaAuthority());
            for (FXRspecNode node : nodes) {
                if (!node.getLoginServices().isEmpty()) {
                    if (nodesOfAuthorityWithLoginService.containsKey(node.getUniqueId())) continue;
                    nodesOfAuthorityWithLoginService.put(node.getUniqueId(), node);
                    nodeIdsWithoutLoginService.remove(node.getUniqueId());
                    continue;
                }
                if (nodesOfAuthorityWithLoginService.containsKey(node.getUniqueId())) continue;
                nodeIdsWithoutLoginService.add(node.getUniqueId());
            }
        }
        if (!nodesOfAuthorityWithLoginService.isEmpty()) {
            return nodesOfAuthorityWithLoginService.values();
        }
        if (!nodeIdsWithoutLoginService.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cannot start connectivity test for authority {} as no nodes with loginServices are available", (Object)experimentPart.getName());
            }
            return Collections.emptyList();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("No connectivity test will be performed for authority {}, as it isn't responsible for any nodes", (Object)experimentPart.getName());
        }
        return Collections.emptyList();
    }

    private static int getExpectedLinkSpeed_Mbps(@Nonnull FXRspecNode sourceNode, @Nonnull FXRspecNode targetNode) {
        Integer impairedSpeed_Mbps = null;
        for (FXRspecLink link : sourceNode.getLinks()) {
            FXLinkSetting ls;
            FXRspecInterface sourceIface = link.getInterfaceForNode((RspecNode)sourceNode);
            FXRspecInterface targetIface = link.getInterfaceForNode((RspecNode)targetNode);
            if (sourceIface == null || targetIface == null || (ls = link.getLinkSetting((RspecInterface)sourceIface, (RspecInterface)targetIface)) == null || !ls.isCapacitySet()) continue;
            impairedSpeed_Mbps = (int)ls.getCapacity_Kbps() / 1000;
        }
        if (impairedSpeed_Mbps != null && impairedSpeed_Mbps < 100) {
            return impairedSpeed_Mbps;
        }
        if (Objects.equals(sourceNode.getSliverTypeName(), "emulab-xen") || Objects.equals(targetNode.getSliverTypeName(), "emulab-xen")) {
            return 100;
        }
        if (Objects.equals(sourceNode.getSliverTypeName(), "emulab-openvz") || Objects.equals(targetNode.getSliverTypeName(), "emulab-openvz")) {
            return 100;
        }
        if (impairedSpeed_Mbps != null && impairedSpeed_Mbps < 1000) {
            return impairedSpeed_Mbps;
        }
        return 1000;
    }

    public class TestLinksExperimentPartsState
    extends SlicedState<TestLinksExperimentPartStateSlice> {
        private final List<TestLinksExperimentPartStateSlice> slices;

        protected TestLinksExperimentPartsState() {
            super("Test Links of experiment parts");
            this.slices = TestLinksJob.this.experiment.getPartsStream().filter(part -> part instanceof SfaExperimentPart).map(x$0 -> new TestLinksExperimentPartStateSlice((ExperimentPart)x$0)).collect(Collectors.toList());
        }

        @Override
        public Collection<TestLinksExperimentPartStateSlice> getSlices() {
            return this.slices;
        }

        public List<FXRspecNode> getFailedNodes() {
            return TestLinksJob.this.failedNodes;
        }
    }

    public class TestLinksOfExperimentPartState
    extends State {
        private final ExperimentPart experimentPart;
        private final Collection<FXRspecNode> nodesToTest;
        private final List<LinkTestReport> linkReports;

        private TestLinksOfExperimentPartState(ExperimentPart experimentPart, Collection<FXRspecNode> nodesToTest) {
            super(String.format("Testing links of %s", experimentPart.getName()));
            this.linkReports = new ArrayList<LinkTestReport>();
            this.experimentPart = experimentPart;
            this.nodesToTest = nodesToTest;
        }

        @Override
        @Nonnull
        protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            assert (!this.nodesToTest.isEmpty());
            assert (this.experimentPart instanceof SfaExperimentPart);
            assert (((SfaExperimentPart)this.experimentPart).getSlivers() != null);
            for (Sliver sliver : ((SfaExperimentPart)this.experimentPart).getSlivers()) {
                assert (sliver.getStatus().getGlobalStatus() == StatusDetails.SliverStatus.READY);
                assert (sliver.isFake() || sliver.getManifestRspec() != null);
            }
            JFedConnection.SshProxyInfo proxyInfo = null;
            if (Objects.equals(TestLinksJob.this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH), "ALWAYS")) {
                GeniUser geniUser = TestLinksJob.this.geniUserProvider.getLoggedInGeniUser();
                assert (geniUser.getUserAuthorityServer() != null);
                List userAuthProxyInfos = geniUser.getUserAuthorityServer().getTestbed().getProxies();
                proxyInfo = TestLinksJob.this.proxyPreferencesManager.getSshProxySettings(userAuthProxyInfos, geniUser);
                if (proxyInfo == null) {
                    LOG.warn("Link tests to nodes on authority {} are skipped as SSH-proxy is active but proxy info was not found. (this is a jFed bug)", (Object)this.experimentPart.getName());
                    this.updateMessage("Skipped because proxy for SSH-connections is active but proxy info was not found. (this is a jFed bug)");
                    TestLinksJob.this.experiment.getLinkTestLogger().fireAllReports(this.linkReports, LinkTestResult.FAILURE);
                    return ExperimentTaskStatus.FAILED;
                }
            }
            LOG.debug("Starting nodes Link test for {} nodes on {}", (Object)this.nodesToTest.size(), (Object)this.experimentPart.getName());
            Iterator<FXRspecNode> it = this.nodesToTest.iterator();
            while (it.hasNext()) {
                FXRspecNode node = it.next();
                if (!node.getLoginServices().isEmpty()) continue;
                LOG.debug("Removing node {} from test because it doesn't have any loginServices available", (Object)node.getUniqueId());
                it.remove();
            }
            LinkTestReport allTimeWorst = null;
            for (FXRspecNode node : this.nodesToTest) {
                List<LinkTestReport> result = null;
                try {
                    result = this.testLinksOfNode(node, (JFedConnection.ProxyInfo)proxyInfo);
                }
                catch (Exception e) {
                    LOG.debug("Exception while executing link test for node " + node.getUniqueId(), (Throwable)e);
                    this.updateMessage("Link test failed to run on some nodes.");
                    TestLinksJob.this.experiment.getLinkTestLogger().fireAllReports(this.linkReports, LinkTestResult.FAILURE);
                    return ExperimentTaskStatus.FAILED;
                }
                LinkTestReport curWorst = LinkTestReport.worst(result);
                allTimeWorst = LinkTestReport.worstNonNull(curWorst, allTimeWorst);
                for (LinkTestReport r : result) {
                    LOG.debug("Got LinkReport summary=" + r.getSummary() + " from=" + r.getFrom().getClientId() + " to=" + r.getTo().getClientId());
                }
                this.linkReports.addAll(result);
            }
            if (allTimeWorst != null) {
                LOG.debug("allTimeWorst LinkReport summary=" + allTimeWorst.getSummary() + " from=" + allTimeWorst.getFrom().getClientId() + " to=" + allTimeWorst.getTo().getClientId());
            }
            if (allTimeWorst == null || allTimeWorst.getSummary() == LinkTestResult.SUCCESS) {
                TestLinksJob.this.experiment.getLinkTestLogger().fireAllReports(this.linkReports, allTimeWorst == null ? LinkTestResult.SUCCESS : allTimeWorst.summary);
                this.updateMessage("All links working correctly. (click here to open detailed results)");
                return ExperimentTaskStatus.SUCCESS;
            }
            TestLinksJob.this.experiment.getLinkTestLogger().fireAllReports(this.linkReports, allTimeWorst.summary);
            LOG.debug("Link Test detected link failures.");
            this.updateMessage("Link Test detected link failures. (click here to open detailed results)");
            return ExperimentTaskStatus.SUCCESS;
        }

        /*
         * Exception decompiling
         */
        private List<LinkTestReport> testLinksOfNode(FXRspecNode node, JFedConnection.ProxyInfo proxyInfo) throws JFedException, InterruptedException, JobWithSshConnectionManager.SshException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Collection<FXRspecNode> getNodesToTest() {
            return this.nodesToTest;
        }

        public List<LinkTestReport> getLinkReports() {
            return this.linkReports;
        }

        public boolean areAllReportSuccessful() {
            return this.linkReports.stream().allMatch(lr -> lr.getSummary() == LinkTestResult.SUCCESS);
        }
    }

    public static class LinkTestReport {
        @Nonnull
        private final FXRspecNode from;
        @Nonnull
        private final FXRspecNode to;
        private final LinkTestResult summary;
        private final int expectedLinkSpeed_mbps;
        private final String ifaceDevName;
        private final String debug;
        private final boolean connectivityOk;
        private final boolean linkSpeedSettingOk;
        private final boolean throughputOk;
        private final boolean lossOk;
        private final int actualLinkSpeedSetting_mbps;
        private final double actualThroughput_mbps;
        private final double actualLoss_percent;

        public LinkTestReport(@Nonnull FXRspecNode from, @Nonnull FXRspecNode to, int expectedLinkSpeed_mbps, boolean connectivityOk, double actualThroughput_mbps, int actualLinkSpeedSetting_mbps, double actualLoss_percent, String ifaceDevName, String debug) {
            this.from = from;
            this.to = to;
            this.expectedLinkSpeed_mbps = expectedLinkSpeed_mbps;
            this.connectivityOk = connectivityOk;
            this.actualThroughput_mbps = actualThroughput_mbps;
            this.actualLinkSpeedSetting_mbps = actualLinkSpeedSetting_mbps;
            this.actualLoss_percent = actualLoss_percent;
            this.ifaceDevName = ifaceDevName;
            this.debug = debug;
            this.linkSpeedSettingOk = actualLinkSpeedSetting_mbps >= expectedLinkSpeed_mbps;
            boolean bl = this.lossOk = actualLoss_percent <= 0.001;
            this.throughputOk = expectedLinkSpeed_mbps == 10 ? actualThroughput_mbps > 8.0 : (expectedLinkSpeed_mbps == 100 ? actualThroughput_mbps > 80.0 : (expectedLinkSpeed_mbps == 1000 ? actualThroughput_mbps > 200.0 : (expectedLinkSpeed_mbps <= 100 ? actualThroughput_mbps > (double)expectedLinkSpeed_mbps * 0.8 : actualThroughput_mbps > (double)expectedLinkSpeed_mbps * 0.2)));
            LinkTestResult summary = LinkTestResult.FAILURE;
            if (connectivityOk && this.linkSpeedSettingOk && this.throughputOk && this.lossOk) {
                summary = LinkTestResult.SUCCESS;
            } else if (connectivityOk || this.throughputOk || this.lossOk) {
                summary = LinkTestResult.PARTIAL_FAILURE;
            }
            this.summary = summary;
        }

        @Nonnull
        private static <T> T getFromMapOrDefault(Map m, String key, @Nonnull T defaultValue) {
            if (!m.containsKey(key)) {
                return defaultValue;
            }
            Object res = m.get(key);
            if (res == null) {
                return defaultValue;
            }
            return (T)res;
        }

        public static LinkTestReport createFromJson(@Nonnull FXRspecNode from, @Nonnull FXRspecNode to, int expectedLinkSpeed_mbps, @Nonnull Map linkTestResMap, String debug) {
            Object extraDebug;
            boolean ping = LinkTestReport.getFromMapOrDefault(linkTestResMap, "ping", false);
            double measured_bw = LinkTestReport.getFromMapOrDefault(linkTestResMap, "measured_bw", -1.0);
            int iface_speed = LinkTestReport.getFromMapOrDefault(linkTestResMap, "iface_speed", -1);
            double loss = LinkTestReport.getFromMapOrDefault(linkTestResMap, "loss", -1.0);
            String iface_dev = LinkTestReport.getFromMapOrDefault(linkTestResMap, "iface_dev", "unknown");
            try {
                extraDebug = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)linkTestResMap);
            }
            catch (JsonProcessingException e) {
                extraDebug = "Error converting Map to JSON: " + e.getMessage();
            }
            debug = debug == null ? extraDebug : (String)debug + "\n\n" + (String)extraDebug;
            return new LinkTestReport(from, to, expectedLinkSpeed_mbps, ping, measured_bw, iface_speed, loss, iface_dev, (String)debug);
        }

        @Nonnull
        public FXRspecNode getFrom() {
            return this.from;
        }

        @Nonnull
        public FXRspecNode getTo() {
            return this.to;
        }

        public String getIfaceDevName() {
            return this.ifaceDevName;
        }

        public String getDebug() {
            return this.debug;
        }

        public LinkTestResult getSummary() {
            return this.summary;
        }

        public int getExpectedLinkSpeed_mbps() {
            return this.expectedLinkSpeed_mbps;
        }

        public boolean isConnectivityOk() {
            return this.connectivityOk;
        }

        public boolean isLinkSpeedSettingOk() {
            return this.linkSpeedSettingOk;
        }

        public boolean isThroughputOk() {
            return this.throughputOk;
        }

        public boolean isLossOk() {
            return this.lossOk;
        }

        public int getActualLinkSpeedSetting_mbps() {
            return this.actualLinkSpeedSetting_mbps;
        }

        public double getActualThroughput_mbps() {
            return this.actualThroughput_mbps;
        }

        public double getActualLoss_percent() {
            return this.actualLoss_percent;
        }

        @Nullable
        public static LinkTestReport worst(@Nonnull Collection<LinkTestReport> reports) {
            if (reports.isEmpty()) {
                return null;
            }
            LinkTestReport res = reports.iterator().next();
            for (LinkTestReport cur : reports) {
                if (!cur.summary.isWorseThan(res.summary)) continue;
                res = cur;
            }
            return res;
        }

        @Nullable
        @Contract(value="!null,_ -> !null;_,!null -> !null;null,null -> null")
        public static LinkTestReport worstNonNull(@Nullable LinkTestReport a, @Nullable LinkTestReport b) {
            if (a == null && b == null) {
                return null;
            }
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return LinkTestReport.worst(a, b);
        }

        @Nonnull
        public static LinkTestReport worst(@Nonnull LinkTestReport a, @Nonnull LinkTestReport b) {
            if (a.summary.isWorseThan(b.summary)) {
                return a;
            }
            return b;
        }

        public String toString() {
            return "LinkTest " + this.summary + " from=" + this.from.getClientId() + " to=" + this.to.getClientId() + " connectivity " + (this.connectivityOk ? "OK" : "Fail") + " linkSpeed set " + (this.linkSpeedSettingOk ? "OK" : "Fail") + " throughput " + (this.throughputOk ? "OK" : "Fail") + " loss " + (this.lossOk ? "OK" : "Fail") + " expected speed=" + this.expectedLinkSpeed_mbps + " Mbps iface='" + this.ifaceDevName + "' set speed=" + this.actualLinkSpeedSetting_mbps + " Mbps measured bw=" + this.actualThroughput_mbps + " Mbps loss=" + this.actualLoss_percent + "%" + (String)(this.debug == null || this.debug.isEmpty() ? "" : " debug='" + this.debug + "'");
        }

        public String toStringNoSuccessDebug() {
            return "LinkTest " + this.summary + " from=" + this.from.getClientId() + " to=" + this.to.getClientId() + " connectivity " + (this.connectivityOk ? "OK" : "Fail") + " linkSpeed set " + (this.linkSpeedSettingOk ? "OK" : "Fail") + " throughput " + (this.throughputOk ? "OK" : "Fail") + " loss " + (this.lossOk ? "OK" : "Fail") + " expected speed=" + this.expectedLinkSpeed_mbps + " Mbps iface='" + this.ifaceDevName + "' set speed=" + this.actualLinkSpeedSetting_mbps + " Mbps measured bw=" + this.actualThroughput_mbps + " Mbps loss=" + this.actualLoss_percent + "%" + (String)(this.summary == LinkTestResult.SUCCESS ? "" : (this.debug == null || this.debug.isEmpty() ? "" : " debug='" + this.debug + "'"));
        }
    }

    public static enum LinkTestResult {
        SUCCESS,
        PARTIAL_FAILURE,
        FAILURE;


        boolean isWorseThan(@Nonnull LinkTestResult other) {
            switch (this) {
                case SUCCESS: {
                    return false;
                }
                case PARTIAL_FAILURE: {
                    return other == SUCCESS;
                }
                case FAILURE: {
                    return other != FAILURE;
                }
            }
            throw new RuntimeException("Unhandled LinkTestResult" + other);
        }
    }

    public class TestLinksExperimentPartStateSlice
    extends ExperimentPartStateSlice {
        private TestLinksExperimentPartStateSlice(ExperimentPart experimentPart) {
            super(TestLinksJob.this, experimentPart);
        }

        @Override
        public String getName() {
            return "Testing connectivity to resources in " + this.experimentPart.getName();
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            Collection<FXRspecNode> nodesToTest = TestLinksJob.this.findTestableResources(this.experimentPart);
            if (!nodesToTest.isEmpty()) {
                TestLinksOfExperimentPartState tcs = new TestLinksOfExperimentPartState(this.experimentPart, nodesToTest);
                this.setAndRunState(tcs);
                Map failedNodesByClientId = tcs.linkReports.stream().filter(c -> c.getSummary() != LinkTestResult.SUCCESS).map(LinkTestReport::getFrom).collect(Collectors.toMap(FXRspecNode::getClientId, Function.identity(), (a, b) -> a));
                TestLinksJob.this.failedNodes.addAll(failedNodesByClientId.values());
                return tcs.getStatus();
            }
            LOG.debug("Skipping: no testable resources found");
            return ExperimentTaskStatus.SUCCESS;
        }
    }
}

