/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartsSlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateExperimentJob
extends AbstractJob<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateExperimentJob.class);
    private final ExperimentPartControllerManager experimentPartControllerManager;

    public UpdateExperimentJob(Experiment experiment, HighLevelTaskFactory hltf, TaskThread tt, ExperimentPartControllerManager experimentPartControllerManager) {
        super("Check expiration of " + experiment.getName(), experiment, hltf, tt);
        this.experimentPartControllerManager = experimentPartControllerManager;
    }

    @Override
    public Void execute() throws Exception {
        assert (this.experiment.getSliceOrNull() != null);
        assert (this.experiment.getSliceOrNull().getExpirationDate() != null);
        this.setAndRunState(new UpdateExperimentSlicedState());
        if (this.experiment.getSliceOrNull() == null) {
            LOG.error("Tried to start UpdateExperimentJob for experiment with experiment.getSlice() == null");
            return null;
        }
        if (this.experiment.getExperimentState() == ExperimentState.EXPIRING) {
            boolean allResourcesExpired = true;
            boolean hasChangingExperimentParts = false;
            for (ExperimentPart part2 : this.experiment.getPartsListCopy()) {
                if (part2.getState() != InternalState.UNALLOCATED && part2.getState() != InternalState.DELETED && part2.getState() != InternalState.FAILED) {
                    allResourcesExpired = false;
                }
                if (part2.getState() != InternalState.CHANGING) continue;
                hasChangingExperimentParts = true;
            }
            for (Sliver sliver : this.experiment.getSlice().getSliversCopy()) {
                if (sliver.getStatus().getGlobalStatus() == StatusDetails.SliverStatus.UNALLOCATED || sliver.getStatus().getGlobalStatus() == StatusDetails.SliverStatus.FAIL) continue;
                allResourcesExpired = false;
            }
            if (allResourcesExpired) {
                this.experiment.setExperimentState(ExperimentState.EXPIRED);
            } else if (!hasChangingExperimentParts) {
                boolean hasAnyFailingSliver = this.experiment.getSlice().getSliversStream().map(Sliver::hasAnyFailStatus).anyMatch(s -> s);
                if (hasAnyFailingSliver) {
                    this.experiment.setExperimentState(ExperimentState.FAILED);
                } else {
                    this.experiment.setExperimentState(ExperimentState.READY);
                }
            }
        } else {
            boolean hasActiveResources = this.experiment.getPartsStream().anyMatch(part -> InternalState.isActiveState(part.getState()));
            if (!hasActiveResources) {
                this.experiment.setExperimentState(ExperimentState.EMPTY);
            }
        }
        return null;
    }

    private class UpdateExperimentSlicedState
    extends ExperimentPartsSlicedState<ExperimentPartStateSlice> {
        public UpdateExperimentSlicedState() {
            super("Updating experiment status", UpdateExperimentJob.this.experiment, UpdateExperimentJob.this.experimentPartControllerManager);
        }

        @Override
        public <EP extends ExperimentPart> ExperimentPartStateSlice createJobSlice(ExperimentPartController<EP> controller, EP experimentPart) {
            return controller.update(UpdateExperimentJob.this, experimentPart);
        }
    }
}

