/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.link_test;

import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.jobs.link_test.LinkTestListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkTestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(LinkTestLogger.class);
    private final List<LinkTestListener> listeners = new CopyOnWriteArrayList<LinkTestListener>();
    @Nullable
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final AtomicInteger exceptionCount = new AtomicInteger(0);

    public LinkTestLogger() {
        this.uncaughtExceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
    }

    public LinkTestLogger(@Nullable Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public void addLinkTestListener(@Nonnull LinkTestListener listener) {
        this.listeners.add(listener);
    }

    public void removeLinkTestListener(@Nonnull LinkTestListener listener) {
        this.listeners.remove(listener);
    }

    public void fireAllReports(@Nonnull List<TestLinksJob.LinkTestReport> reports, @Nonnull TestLinksJob.LinkTestResult worstResult) {
        this.executeSafeForAllListeners(l -> l.onAllReports(reports, worstResult));
    }

    public void fireReport(@Nonnull TestLinksJob.LinkTestReport report) {
        this.executeSafeForAllListeners(l -> l.onReport(report));
    }

    private void executeSafeForAllListeners(Consumer<LinkTestListener> c) {
        for (LinkTestListener l : this.listeners) {
            try {
                c.accept(l);
            }
            catch (Exception e) {
                this.handleExceptionInListener(e);
            }
        }
    }

    private void handleExceptionInListener(Exception e) {
        int count = this.exceptionCount.getAndIncrement();
        if (count == 0 && this.uncaughtExceptionHandler != null) {
            try {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
            catch (Exception e2) {
                LOG.error("Ignoring exception in uncaughtExceptionHandler", (Throwable)e2);
            }
        } else {
            LOG.error("Ignoring exception " + count + " in LinkTester listener", (Throwable)e);
        }
    }
}

