/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.report;

import be.iminds.ilabt.jfed.highlevel.jobs.AllocateExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobReport;
import be.iminds.ilabt.jfed.highlevel.stitcher.HopInfo;
import be.iminds.ilabt.jfed.lowlevel.stitching.info.Hop;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Pair;

public class StitchingJobReport
extends JobReport {
    private final Map<String, ObservableList<HopInfo>> hopInfoByLinkName = new HashMap<String, ObservableList<HopInfo>>();
    private final Map<String, HopInfo> hopInfoByUrn = new HashMap<String, HopInfo>();

    public <V> StitchingJobReport(AllocateExperimentJob job) {
        super(job);
    }

    void updateHopOverview(Map<String, List<Hop>> hopOverview) {
        ArrayList<Pair> newHopInfo = new ArrayList<Pair>();
        for (Map.Entry<String, List<Hop>> e : hopOverview.entrySet()) {
            String linkName = e.getKey();
            List<Hop> hops = e.getValue();
            ObservableList hopInfos = this.hopInfoByLinkName.computeIfAbsent(linkName, c -> FXCollections.observableArrayList());
            for (int i = 0; i < hops.size(); ++i) {
                HopInfo hopInfo;
                Hop hop = hops.get(i);
                if (hopInfos.size() <= i) {
                    hopInfo = new HopInfo(hop);
                    newHopInfo.add(new Pair((Object)hop, (Object)hopInfo));
                    this.hopInfoByUrn.put(hopInfo.getHopUrn(), hopInfo);
                } else {
                    hopInfo = (HopInfo)hopInfos.get(i);
                }
                assert (Objects.equals(hopInfo.getAuthUrn(), hop.getAuthUrn()));
            }
        }
        for (Pair p : newHopInfo) {
            HopInfo hi;
            Hop hop = (Hop)p.getKey();
            HopInfo hopInfo = (HopInfo)p.getValue();
            for (Hop h : hop.getDependsOn()) {
                hi = this.hopInfoByUrn.get(h.getHopUrn());
                assert (hi != null);
                hopInfo.getDependsOn().add(hi);
            }
            for (Hop h : hop.getDependingOnThis()) {
                hi = this.hopInfoByUrn.get(h.getHopUrn());
                assert (hi != null);
                hopInfo.getDependingOnThis().add(hi);
            }
        }
        for (Pair p : newHopInfo) {
            HopInfo hopInfo = (HopInfo)p.getValue();
            ObservableList<HopInfo> hopInfos = this.hopInfoByLinkName.get(hopInfo.getLinkName());
            hopInfos.add((Object)hopInfo);
        }
    }

    public ObservableList<HopInfo> getLinkHopInfo(String linkName) {
        return this.hopInfoByLinkName.computeIfAbsent(linkName, c -> FXCollections.observableArrayList());
    }
}

