/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts;

import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.RenewSliversTask;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv3Wrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class RenewSfaExperimentPartStateSlice
extends ExperimentPartStateSlice<SfaExperimentPart> {
    private final Instant newExpirationDate;
    private final HighLevelTaskFactory hltf;

    public RenewSfaExperimentPartStateSlice(Job<?> job, SfaExperimentPart experimentPart, Instant newExpirationDate, HighLevelTaskFactory hltf) {
        super(job, experimentPart);
        this.newExpirationDate = newExpirationDate;
        this.hltf = hltf;
    }

    @Override
    public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
        RenewSfaExperimentPartState renewState = new RenewSfaExperimentPartState((SfaExperimentPart)this.experimentPart);
        this.setAndRunState(renewState);
        return renewState.getStatus();
    }

    private class RenewSfaExperimentPartState
    extends SingleCallState<RenewSliversTask> {
        protected RenewSfaExperimentPartState(SfaExperimentPart experimentPart) {
            super(String.format("Renewing resources on %s", experimentPart.getName()), RenewSfaExperimentPartStateSlice.this.hltf.renewSliversAtAuthority(RenewSfaExperimentPartStateSlice.this.experiment.getSliceOrNull(), RenewSfaExperimentPartStateSlice.this.newExpirationDate, experimentPart.getConnectSfaAuthority()));
        }

        @Override
        @NotNull
        public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
            ExperimentTaskStatus res = super.executeState(job);
            if (this.taskExecution.getException() != null && this.taskExecution.getException() instanceof AMv3Wrapper.RenewRefusedException) {
                AMv3Wrapper.RenewRefusedException e = (AMv3Wrapper.RenewRefusedException)this.taskExecution.getException();
                this.updateMessage(e.getMessage());
                ((SfaExperimentPart)RenewSfaExperimentPartStateSlice.this.experimentPart).setRenewStatus(new SfaExperimentPart.RenewStatus(res, true, e.getMessage()));
            } else {
                ((SfaExperimentPart)RenewSfaExperimentPartStateSlice.this.experimentPart).setRenewStatus(new SfaExperimentPart.RenewStatus(res, false, "Renew " + res.name()));
            }
            return res;
        }
    }
}

