/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.AllocateSliverTask;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateSliverTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AllocateSliversOnAuthorityState
extends State {
    private final Job<?> job;
    private final Experiment experiment;
    private final SfaExperimentPart experimentPart;
    private final List<UserSpec> userSpecs;
    @Nullable
    private final RequestRspecSource overridingRequestRspecSource;
    private final HighLevelTaskFactory hltf;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private boolean success = false;
    private List<GeniUrn> createdSlivers = null;
    private AbstractGeniAggregateManager.AggregateManagerReply rawReply;
    private Throwable exception;

    protected AllocateSliversOnAuthorityState(Job<?> job, SfaExperimentPart experimentPart, List<UserSpec> userSpecs, @Nullable RequestRspecSource overridingRequestRspecSource, HighLevelTaskFactory hltf, AggregateManagerWrapperFactory aggregateManagerWrapperFactory) {
        super(String.format("Allocating resources on %s", experimentPart.getName()));
        this.job = job;
        this.userSpecs = userSpecs;
        this.overridingRequestRspecSource = overridingRequestRspecSource;
        this.hltf = hltf;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.experiment = experimentPart.getExperiment();
        this.experimentPart = experimentPart;
    }

    @Override
    @Nonnull
    public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
        this.experimentPart.setState(InternalState.ALLOCATING);
        if (!this.experimentPart.getConnectSfaAuthority().hasFlag(Server.Flag.featureReservationsNitos) && this.supportsAllocateProvision()) {
            AllocateSliverTask ast = this.hltf.allocateSliver(this.experiment.getSliceOrNull(), this.experiment.getRequestedStartTime(), this.experiment.getRequestedEndTime(), this.experiment.getUserSpecs(), this.experimentPart.getConnectSfaAuthority(), this.overridingRequestRspecSource);
            TaskExecution<AllocateSliverTask> taskExecution = this.job.submitTaskAndWait(ast);
            if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) {
                this.rawReply = ast.getRawReply();
                this.success = true;
                this.experimentPart.setState(InternalState.ALLOCATED);
                assert (ast.getCreatedSlivers() != null) : "AllocateSliverTask getCreatedSlivers is null";
                this.createdSlivers = ast.getCreatedSlivers().stream().map(Sliver::getUrn).collect(Collectors.toList());
            } else {
                this.exception = taskExecution.getException();
            }
        } else {
            CreateSliverTask cst = this.hltf.createSliver(this.experiment.getSliceOrNull(), this.experiment.getRequestedStartTime(), this.experiment.getRequestedEndTime(), this.experimentPart.getConnectSfaAuthority(), this.userSpecs, this.overridingRequestRspecSource);
            TaskExecution<CreateSliverTask> taskExecution = this.job.submitTaskAndWait(cst);
            if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) {
                this.rawReply = cst.getRawReply();
                this.success = true;
                this.experimentPart.setState(InternalState.PROVISIONED);
                assert (cst.getCreatedSlivers() != null) : "CreateSliverTask getCreatedSlivers is null";
                assert (!cst.getCreatedSlivers().isEmpty()) : "CreateSliverTask getCreatedSlivers is empty";
                this.createdSlivers = cst.getCreatedSlivers().stream().map(Sliver::getUrn).collect(Collectors.toList());
            } else {
                this.exception = taskExecution.getException();
            }
        }
        return this.success ? ExperimentTaskStatus.SUCCESS : ExperimentTaskStatus.FAILED;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<GeniUrn> getCreatedSlivers() {
        return this.createdSlivers;
    }

    private boolean supportsAllocateProvision() {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(this.experimentPart.getConnectSfaAuthority());
        return amWrapper.hasSeperateAllocateAndProvision();
    }

    public AbstractGeniAggregateManager.AggregateManagerReply getRawReply() {
        return this.rawReply;
    }

    public Throwable getException() {
        return this.exception;
    }
}

