/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.UserSpecHelper;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserWithSpeaksFor;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicDistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateUserSpecListState
extends State {
    private static final Logger LOG = LoggerFactory.getLogger(CreateUserSpecListState.class);
    private List<UserSpec> userSpecs = null;
    private final Experiment experiment;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;

    protected CreateUserSpecListState(Experiment experiment, GeniUserProvider geniUserProvider, SfaModel sfaModel) {
        super("Gathering experiment members info");
        this.experiment = experiment;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        experiment.requireSlice();
    }

    @Override
    @Nonnull
    public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
        assert (this.experiment.getSlice().getRequestRspec() != null);
        if (this.experiment.getSlice().getRequestRspec() == null) {
            throw new IllegalStateException("Experiment slice has no request RSpec");
        }
        this.userSpecs = UserSpecHelper.getMergedUserSpecs(this.geniUserProvider, this.sfaModel, (ModelRspec)this.experiment.getSlice().getRequestRspec().getImmutableModelRspec());
        this.userSpecs = UserSpecHelper.mergeUserSpecs(this.userSpecs, this.experiment.getUserSpecs());
        ArrayList<BasicDistributeSshKeypair> keyPairToDistributeInfo = new ArrayList<BasicDistributeSshKeypair>();
        FXModelRspec rspec = (FXModelRspec)this.experiment.getSlice().getRequestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        if (rspec != null) {
            keyPairToDistributeInfo.addAll(rspec.getDistributeSshKeypairs());
        }
        BasicDistributeSshKeypair ansibleDistributeSshKeypair = null;
        if (this.experiment.getExperimentSpecification() != null) {
            for (UploadSpec uploadSpec : this.experiment.getExperimentSpecification().getUploads()) {
                if (!uploadSpec.getSource().isGeneratedKeyPair() || !uploadSpec.getSource().getValue().toLowerCase().startsWith("keypair.private")) continue;
                keyPairToDistributeInfo.add(new BasicDistributeSshKeypair(uploadSpec.getPath(), null));
            }
            if (keyPairToDistributeInfo.isEmpty() && this.experiment.getExperimentSpecification().getAnsible() != null) {
                ansibleDistributeSshKeypair = new BasicDistributeSshKeypair(null, null);
                keyPairToDistributeInfo.add(ansibleDistributeSshKeypair);
            }
        }
        for (DistributeSshKeypair distributeSshKeypair : keyPairToDistributeInfo) {
            GeniUrn user = distributeSshKeypair.getUser();
            if (user == null) {
                GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
                GeniUserWithSpeaksFor geniUserWithSpeaksFor = geniUser instanceof GeniUserWithSpeaksFor ? (GeniUserWithSpeaksFor)geniUser : null;
                user = geniUserWithSpeaksFor != null ? geniUserWithSpeaksFor.getSpeaksForUrn() : geniUser.getUserUrn();
            }
            BasicDistributeSshKeypair distributeSshKeypairWithAdaptedUser = new BasicDistributeSshKeypair(distributeSshKeypair.getLocation(), user);
            try {
                KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
                keyGen.initialize(2048);
                KeyPair keyPair = keyGen.generateKeyPair();
                assert (keyPair != null);
                assert (keyPair.getPrivate() != null);
                assert (keyPair.getPublic() != null);
                this.experiment.getKeypairs().put((Object)distributeSshKeypairWithAdaptedUser, (Object)keyPair);
                RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
                String comment = ansibleDistributeSshKeypair == distributeSshKeypair ? "ansible_key" : "jfed_key";
                PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromPublicKey((PublicKey)publicKey).withComment(comment);
                String openSshKeyString = publicKeyConvertor.getOpensshFormString();
                this.userSpecs = UserSpecHelper.addUserSpec(this.userSpecs, new UserSpec(user.toString(), openSshKeyString));
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.error("Could not generate keypairs to distribute: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        return ExperimentTaskStatus.SUCCESS;
    }

    public List<UserSpec> getUserSpecs() {
        return this.userSpecs;
    }
}

