/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.util.ExternalFileUtil;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.highlevel.util.StringMemorySourceFile;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributeSshKeysState
extends SlicedState<DistributeSshKeysStateSlice> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(DistributeSshKeysState.class);
    private final Logger LOG;
    private final SetupSoftwareExperimentJob setupSoftwareExperimentJob;
    private final List<DistributeSshKeysStateSlice> slices;
    private final Experiment experiment;

    public DistributeSshKeysState(SetupSoftwareExperimentJob job) {
        super("Distribute generated SSH keys");
        this.setupSoftwareExperimentJob = job;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
        this.experiment = job.getExperiment();
        this.slices = this.experiment.getKeypairs().entrySet().stream().map(entry -> new DistributeSshKeysStateSlice(job, (DistributeSshKeypair)entry.getKey(), (KeyPair)entry.getValue())).collect(Collectors.toList());
        assert (this.experiment.getSliceOrNull() != null);
    }

    @Override
    public List<DistributeSshKeysStateSlice> getSlices() {
        return this.slices;
    }

    public static boolean hasDistributeSshKeyPair(Experiment experiment) {
        return !DistributeSshKeysState.getDistributeSshKeyPairs(experiment).isEmpty();
    }

    @Nonnull
    private static List<? extends DistributeSshKeypair> getDistributeSshKeyPairs(@Nonnull Experiment experiment) {
        ImmutableModelRspec model;
        RequestRspecSource requestRspecSource = experiment.getSlice().getRequestRspec();
        ImmutableModelRspec immutableModelRspec = model = requestRspecSource == null ? null : requestRspecSource.getImmutableModelRspec();
        assert (model != null);
        if (model == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(model.getDistributeSshKeypairs());
    }

    public class DistributeSshKeysStateSlice
    extends StateSlice {
        private final DistributeSshKeypair distributeSshKeypair;
        private final KeyPair keyPair;
        private final String location;

        public DistributeSshKeysStateSlice(@Nonnull Job<?> job, @Nonnull DistributeSshKeypair distributeSshKeypair, KeyPair keyPair) {
            super(job);
            this.distributeSshKeypair = distributeSshKeypair;
            this.keyPair = keyPair;
            String location = distributeSshKeypair.getLocation();
            if (location == null) {
                location = "~/.ssh/id_rsa";
            }
            this.location = location;
        }

        @Override
        public String getName() {
            return "Distribute generated SSH key for user '" + this.distributeSshKeypair.getUser().getResourceName() + "'";
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            assert (this.experiment.getSliceOrNull() != null);
            assert (this.experiment.getSlice().getManifestRspec() != null);
            ImmutableModelRspec manifestModel = this.experiment.getSlice().getManifestRspec().getImmutableModelRspec();
            assert (manifestModel != null);
            if (this.location == null) {
                return ExperimentTaskStatus.FAILED;
            }
            boolean allSuccess = true;
            boolean allFailed = true;
            for (RspecNode node : manifestModel.getNodes()) {
                UploadKeyToNodeState uploadKeyToNodeState = new UploadKeyToNodeState(node);
                this.setAndRunState(uploadKeyToNodeState);
                if (uploadKeyToNodeState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                    allSuccess = false;
                }
                if (uploadKeyToNodeState.getStatus() == ExperimentTaskStatus.FAILED) continue;
                allFailed = false;
            }
            return allSuccess ? ExperimentTaskStatus.SUCCESS : (allFailed ? ExperimentTaskStatus.FAILED : ExperimentTaskStatus.WARNING);
        }

        public class UploadKeyToNodeState
        extends State {
            private final RspecNode node;

            protected UploadKeyToNodeState(RspecNode node) {
                super("Upload generated key for '" + DistributeSshKeysStateSlice.this.distributeSshKeypair.getUser().getResourceName() + "' to '" + node.getClientId() + "'");
                this.node = node;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                SSHClient ssh;
                try {
                    ssh = DistributeSshKeysState.this.setupSoftwareExperimentJob.getSSHClient(this.node, null);
                }
                catch (JobWithSshConnectionManager.SshException e) {
                    DistributeSshKeysState.this.LOG.warn("Aborting UploadKeyToNodeState.statefulRun due to SSH comnection problem", (Throwable)e);
                    return ExperimentTaskStatus.FAILED;
                }
                assert (ssh != null);
                ExternalFileUtil externalFileUtil = new ExternalFileUtil(ssh);
                try {
                    String filename;
                    String localFolder;
                    char[] keyFile;
                    block23: {
                        keyFile = KeyUtil.privateKeyToPem((PrivateKey)DistributeSshKeysStateSlice.this.keyPair.getPrivate());
                        localFolder = externalFileUtil.getFolder(DistributeSshKeysStateSlice.this.location);
                        filename = ExternalFileUtil.getBasename(DistributeSshKeysStateSlice.this.location);
                        try (Session session = ssh.startSession();){
                            Session.Command command = session.exec("mkdir -p " + localFolder.replace(" ", "\\ "));
                            command.join();
                            if (command.getExitStatus() != 0) {
                                String errorMessage;
                                try (BufferedReader buffer = new BufferedReader(new InputStreamReader(command.getErrorStream()));){
                                    errorMessage = buffer.lines().collect(Collectors.joining(" "));
                                }
                                DistributeSshKeysState.this.LOG.warn("Could not create directory to upload key into: {}", (Object)errorMessage);
                                this.updateMessage("Could not create directory to upload key into: " + errorMessage);
                                break block23;
                            }
                            DistributeSshKeysState.this.LOG.info("mkdir command for '{}' completed successfully", (Object)localFolder);
                        }
                    }
                    ssh.newSCPFileTransfer().upload((LocalSourceFile)new StringMemorySourceFile(filename, keyFile), localFolder);
                    DistributeSshKeysState.this.LOG.debug("Successfully uploaded private key to {} on {}", (Object)DistributeSshKeysStateSlice.this.distributeSshKeypair.getLocation(), (Object)this.node.getClientId());
                    ssh.startSession().exec("chmod 600 " + localFolder + "/" + filename);
                    ExperimentTaskStatus experimentTaskStatus = ExperimentTaskStatus.SUCCESS;
                    return experimentTaskStatus;
                }
                catch (UserAuthException ex) {
                    DistributeSshKeysState.this.LOG.error("Could not authenticate on node {} with generated key. Skipping.", (Object)this.node.getClientId(), (Object)ex);
                    this.updateMessage("Could not authenticate with generated key.");
                    ExperimentTaskStatus experimentTaskStatus = ExperimentTaskStatus.FAILED;
                    return experimentTaskStatus;
                }
                catch (IOException ex) {
                    DistributeSshKeysState.this.LOG.error("Error while transferring private key {} to {}", new Object[]{DistributeSshKeysStateSlice.this.distributeSshKeypair.getLocation(), this.node.getClientId(), ex});
                    this.updateMessage("Error while transferring private key: " + ex.getMessage());
                    ExperimentTaskStatus experimentTaskStatus = ExperimentTaskStatus.FAILED;
                    return experimentTaskStatus;
                }
                finally {
                    DistributeSshKeysState.this.setupSoftwareExperimentJob.closeSSH(this.node);
                }
            }
        }
    }
}

