/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.espec.model.ExperimentInfoOutputSpec;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.lib.AnsibleFileWriter;
import be.iminds.ilabt.jfed.util.lib.BestNodeLoginFinder;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentSpecificationOutputState
extends State {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentSpecificationOutputState.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SetupSoftwareExperimentJob job;
    private final Experiment experiment;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;
    private final ExperimentInfoOutputSpec outputSpec;
    private BestNodeLoginFinder.Feedback feedback = new BestNodeLoginFinder.Feedback(){

        public void info(String s) {
            LOG.info(s);
        }

        public void error(String s) {
            LOG.error(s);
        }

        public void debug(String s) {
            LOG.debug(s);
        }
    };

    protected ExperimentSpecificationOutputState(SetupSoftwareExperimentJob job, GeniUserProvider geniUserProvider, SfaModel sfaModel, ExperimentInfoOutputSpec outputSpec) {
        super("Outputting experiment info " + outputSpec.getType() + " to " + (Serializable)((Object)(outputSpec.getDestination() == ExperimentInfoOutputSpec.ExperimentInfoOutputDestination.LOCAL_FILE ? outputSpec.getDestinationDetail() : outputSpec.getDestination())));
        this.job = job;
        this.experiment = job.getExperiment();
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.outputSpec = outputSpec;
        this.experiment.requireSlice();
    }

    @Override
    @Nonnull
    public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
        try {
            Object content;
            block4 : switch (this.outputSpec.getType()) {
                case ANSIBLE_INVENTORY: 
                case ANSIBLE_ZIP: 
                case ANSIBLE_FILES: {
                    if (this.outputSpec.getType() != ExperimentInfoOutputSpec.ExperimentInfoOutputType.ANSIBLE_INVENTORY && this.outputSpec.getDestination() != ExperimentInfoOutputSpec.ExperimentInfoOutputDestination.LOCAL_FILE) {
                        throw new RuntimeException("output with type=" + this.outputSpec.getType() + " must have file destination, not " + this.outputSpec.getDestination());
                    }
                    if (this.outputSpec.getType() == ExperimentInfoOutputSpec.ExperimentInfoOutputType.ANSIBLE_FILES && !new File(this.outputSpec.getDestinationDetail()).isDirectory()) {
                        throw new RuntimeException("output with type=" + this.outputSpec.getType() + " must have existing dir as destination, not \"" + this.outputSpec.getDestinationDetail() + "\"");
                    }
                    if (this.experiment.getSlice().getManifestRspec() == null) {
                        throw new IllegalStateException("Experiment slice has no manifest RSpec");
                    }
                    if (this.experiment.getKeypairs().isEmpty()) {
                        throw new RuntimeException("Experiment has no keypairs that ansible can use.");
                    }
                    KeyPair ansibleKeyPair = (KeyPair)this.experiment.getKeypairs().values().iterator().next();
                    AnsibleFileWriter ansibleFileWriter = AnsibleFileWriter.createWithCopiedPrivateKey((BasicStringRspec)new BasicStringRspec(this.experiment.getSlice().getManifestRspec().getRspecXmlString()), (PrivateKey)ansibleKeyPair.getPrivate(), (PublicKey)ansibleKeyPair.getPublic(), (GeniUser)this.geniUserProvider.getLoggedInGeniUser(), null, (String)this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getResourceName());
                    content = "logic error";
                    switch (this.outputSpec.getType()) {
                        case ANSIBLE_INVENTORY: {
                            content = ansibleFileWriter.getAnsibleHostFileContent();
                            break block4;
                        }
                        case ANSIBLE_ZIP: {
                            assert (this.outputSpec.getDestinationDetail() != null);
                            ansibleFileWriter.writeFilesToZip(new File(this.outputSpec.getDestinationDetail()));
                            content = "none";
                            break block4;
                        }
                        case ANSIBLE_FILES: {
                            try {
                                assert (this.outputSpec.getDestinationDetail() != null);
                                assert (new File(this.outputSpec.getDestinationDetail()).isDirectory());
                                ansibleFileWriter.writeFilesToDir(new File(this.outputSpec.getDestinationDetail()));
                                content = "none";
                                break block4;
                            }
                            catch (IOException e) {
                                LOG.error("Failed to write ansible files", (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    break;
                }
                case ANSIBLE_PRIVATE_KEY: 
                case ANSIBLE_PUBLIC_KEY: {
                    if (this.experiment.getKeypairs().isEmpty()) {
                        throw new RuntimeException("Experiment has no keypairs that ansible can use.");
                    }
                    KeyPair ansibleKeyPair = (KeyPair)this.experiment.getKeypairs().values().iterator().next();
                    content = "logic error";
                    switch (this.outputSpec.getType()) {
                        case ANSIBLE_PRIVATE_KEY: {
                            content = new String(KeyUtil.privateKeyToAnyPem((PrivateKey)ansibleKeyPair.getPrivate()));
                            break;
                        }
                        case ANSIBLE_PUBLIC_KEY: {
                            PublicKeyConvertor publicKeyConvertor = PublicKeyConvertor.fromPublicKey((PublicKey)ansibleKeyPair.getPublic());
                            content = publicKeyConvertor.getOpensshFormString();
                        }
                    }
                    break;
                }
                case MANIFEST_RSPEC: {
                    if (this.experiment.getSlice().getManifestRspec() == null) {
                        throw new IllegalStateException("Experiment slice has no manifest RSpec");
                    }
                    content = this.experiment.getSlice().getManifestRspec().getRspecXmlString();
                    break;
                }
                case REQUEST_RSPEC: {
                    if (this.experiment.getSlice().getRequestRspec() == null) {
                        throw new IllegalStateException("Experiment slice has no request RSpec");
                    }
                    content = this.experiment.getSlice().getRequestRspec().getRspecXmlString();
                    break;
                }
                case SSH_HOST_LIST: 
                case SSH_LOGIN_LIST: 
                case SSH_INFO_CSV: 
                case SSH_INFO_JSON: {
                    if (this.experiment.getSlice().getManifestRspec() == null) {
                        throw new IllegalStateException("Experiment slice has no manifest RSpec");
                    }
                    content = "";
                    ArrayList json = new ArrayList();
                    BestNodeLoginFinder finder = new BestNodeLoginFinder(new BasicStringRspec(this.experiment.getSlice().getManifestRspec().getRspecXmlString()), null, this.geniUserProvider.getLoggedInGeniUser(), this.feedback);
                    for (RspecNode node : this.experiment.getSlice().getManifestRspec().getModelRspec(ModelRspecType.BASIC, new ProgressHandler[0]).getNodes()) {
                        BasicStringRspec.LoginService best = finder.findBestLogin(node.getUniqueId());
                        if (best == null) continue;
                        Object hostname = best.getHostname();
                        if (best.getPort() != 22) {
                            hostname = (String)hostname + ":" + best.getPort();
                        }
                        switch (this.outputSpec.getType()) {
                            case SSH_HOST_LIST: {
                                content = (String)content + (String)hostname + "\n";
                                break;
                            }
                            case SSH_LOGIN_LIST: {
                                content = (String)content + best.getUsername() + "@" + (String)hostname + "\n";
                                break;
                            }
                            case SSH_INFO_CSV: {
                                content = (String)content + node.getClientId() + "," + best.getHostname() + "," + best.getPort() + "," + best.getUsername() + "," + (String)hostname + "," + best.getUsername() + "@" + (String)hostname + "," + String.join((CharSequence)" ", node.getAnsibleGroups()) + "\n";
                                break;
                            }
                            case SSH_INFO_JSON: {
                                HashMap<String, Object> m = new HashMap<String, Object>();
                                m.put("hostname", best.getHostname());
                                m.put("port", "" + best.getPort());
                                m.put("username", best.getUsername());
                                m.put("hostname_portifnot22", hostname);
                                m.put("user_hostname_portifnot22", best.getUsername() + "@" + (String)hostname);
                                json.add(m);
                            }
                        }
                    }
                    if (this.outputSpec.getType() != ExperimentInfoOutputSpec.ExperimentInfoOutputType.SSH_INFO_JSON) break;
                    try {
                        content = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
                        break;
                    }
                    catch (JsonProcessingException e) {
                        LOG.error("Failed to write SSH INFO JSON", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case CLIENT_ID_LIST: {
                    if (this.experiment.getSlice().getManifestRspec() == null) {
                        throw new IllegalStateException("Experiment slice has no manifest RSpec");
                    }
                    content = "";
                    for (BasicStringRspec.BasicNodeInfo info : this.experiment.getSlice().getManifestRspec().getBasicNodeInfo()) {
                        content = (String)content + info.getClientId() + "\n";
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled switch case");
                }
            }
            if (this.outputSpec.getType() == ExperimentInfoOutputSpec.ExperimentInfoOutputType.ANSIBLE_ZIP || this.outputSpec.getType() == ExperimentInfoOutputSpec.ExperimentInfoOutputType.ANSIBLE_FILES) {
                return ExperimentTaskStatus.SUCCESS;
            }
            switch (this.outputSpec.getDestination()) {
                case LOCAL_FILE: {
                    LOG.debug("EXPERIMENT INFO OUTPUT type=" + this.outputSpec.getType() + " destination=" + this.outputSpec.getDestination());
                    assert (this.outputSpec.getDestinationDetail() != null);
                    File destFile = new File(this.makeRelativeToWorkingDir(this.outputSpec.getDestinationDetail()));
                    try {
                        destFile = destFile.getAbsoluteFile();
                        IOUtils.stringToFileWithEx((File)destFile.getAbsoluteFile(), (String)content);
                        break;
                    }
                    catch (IOException e) {
                        LOG.error("Failed to write \"" + this.outputSpec.getDestinationDetail() + "\" (resolved to \"" + destFile.getPath() + "\")", (Throwable)e);
                        return ExperimentTaskStatus.FAILED;
                    }
                }
                case LOG_DEBUG: {
                    LOG.debug("EXPERIMENT INFO OUTPUT type=" + this.outputSpec.getType() + " destination=" + this.outputSpec.getDestination() + ":");
                    LOG.debug((String)content);
                    break;
                }
                case LOG_INFO: {
                    LOG.info("EXPERIMENT INFO OUTPUT type=" + this.outputSpec.getType() + " destination=" + this.outputSpec.getDestination() + ":");
                    LOG.info((String)content);
                    break;
                }
                default: {
                    throw new RuntimeException("unhandled switch case");
                }
            }
            return ExperimentTaskStatus.SUCCESS;
        }
        catch (Exception e) {
            LOG.error("Failed to output", (Throwable)e);
            return ExperimentTaskStatus.FAILED;
        }
    }

    @Nonnull
    private String makeRelativeToWorkingDir(@Nonnull String path) {
        if (path.startsWith("/")) {
            return path;
        }
        if (path.startsWith("./")) {
            return path;
        }
        return "./" + path;
    }
}

